/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing;

import bossa.util.Internal;
import mlsub.typing.AtomicKind;
import mlsub.typing.InternalError;
import mlsub.typing.Monotype;
import mlsub.typing.MonotypeConstructor;
import mlsub.typing.MonotypeVar;
import mlsub.typing.TypeConstructor;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;
import mlsub.typing.lowlevel.Element;
import mlsub.typing.lowlevel.Engine;
import mlsub.typing.lowlevel.Unsatisfiable;

public class NullnessKind
implements AtomicKind {
    public static NullnessKind instance = new NullnessKind();
    private static TypeConstructor maybe;
    private static TypeConstructor sure;

    public static void setMaybe(TypeConstructor tc) {
        maybe = tc;
    }

    public static void setSure(TypeConstructor tc) {
        sure = tc;
    }

    public int arity() {
        return 1;
    }

    public Monotype freshMonotype() {
        TypeConstructor tc = new TypeConstructor(instance);
        Typing.introduce(tc);
        try {
            Typing.leq(tc, maybe);
            Typing.leq(sure, tc);
        }
        catch (TypingEx ex) {
            Internal.error("Nullness creation error");
        }
        MonotypeVar raw = new MonotypeVar();
        Typing.introduce(raw);
        return new MonotypeConstructor(tc, new Monotype[]{raw});
    }

    public void register(Element e) {
    }

    public void leq(Element e1, Element e2, boolean initial) throws Unsatisfiable {
        if (initial) {
            throw new InternalError("initial leq in Nullness");
        }
        this.leq(e1, e2);
    }

    public void leq(Element e1, Element e2) throws Unsatisfiable {
        MonotypeConstructor m1 = this.mc(e1);
        MonotypeConstructor m2 = this.mc(e2);
        Engine.leq(m1.getTC(), m2.getTC());
        Engine.leq(m1.getTP()[0], m2.getTP()[0]);
    }

    private MonotypeConstructor mc(Element e) {
        try {
            return (MonotypeConstructor)((Monotype)e).equivalent();
        }
        catch (ClassCastException ex) {
            throw new InternalError(e + " was expected to be a monotype constructor, " + " it's a " + e.getClass());
        }
    }

    public Engine.Constraint getConstraint() {
        return Engine.getConstraint(this);
    }

    public String toString() {
        return "Nullness kind";
    }
}

