/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing.lowlevel;

import mlsub.typing.lowlevel.BitVector;
import mlsub.typing.lowlevel.Debug;
import mlsub.typing.lowlevel.InternalError;
import mlsub.typing.lowlevel.S;

public final class BitMatrix
implements Cloneable {
    private BitVector[] rows;
    private int size;
    private boolean reflexive;
    private static BitVector[] reflexiveRow = new BitVector[256];

    public BitMatrix() {
        this(10);
    }

    private BitMatrix(int rowCapacity) {
        if (rowCapacity == 0) {
            rowCapacity = 5;
        }
        this.rows = new BitVector[rowCapacity];
    }

    public int size() {
        return this.size;
    }

    public void setSize(int newSize) {
        if (newSize < this.size) {
            int i = 0;
            while (i < newSize) {
                BitVector row = this.rows[i];
                if (row != null) {
                    row.truncate(newSize);
                }
                ++i;
            }
            int i2 = this.size;
            while (i2 > newSize) {
                this.rows[--i2] = null;
            }
        } else if (this.rows.length < newSize) {
            BitVector[] newRows = new BitVector[this.rows.length * 2];
            System.arraycopy(this.rows, 0, newRows, 0, this.rows.length);
            this.rows = newRows;
        }
        this.size = newSize;
    }

    public int extend() {
        this.setSize(this.size + 1);
        return this.size - 1;
    }

    final BitVector getRow(int i) {
        if (i < this.size) {
            if (this.reflexive && this.rows[i] == null) {
                if (i >= reflexiveRow.length || reflexiveRow[i] == null) {
                    BitVector res = new BitVector(i + 1);
                    res.set(i);
                    if (i < reflexiveRow.length) {
                        BitMatrix.reflexiveRow[i] = res;
                    }
                    return res;
                }
                return reflexiveRow[i];
            }
            if (this.reflexive) {
                this.rows[i].set(i);
            }
            return this.rows[i];
        }
        return null;
    }

    public final boolean get(int i, int j) {
        if (i == j && this.reflexive) {
            return true;
        }
        BitVector row = this.rows[i];
        return row != null && row.get(j);
    }

    public final int getNextSetInRow(int i, int j) {
        BitVector row = this.rows[i];
        if (this.reflexive) {
            if (row == null) {
                if (i > j) {
                    return i;
                }
                return Integer.MIN_VALUE;
            }
            int k = row.getNextBit(j);
            if (i > j && (k < 0 || k > i)) {
                return i;
            }
            return k;
        }
        if (row == null) {
            return Integer.MIN_VALUE;
        }
        return row.getNextBit(j);
    }

    public void set(int i, int j) {
        if (i == j && this.reflexive) {
            return;
        }
        BitVector row = this.rows[i];
        if (row == null) {
            this.rows[i] = row = new BitVector(this.size);
        }
        row.set(j);
    }

    public void clear(int i, int j) {
        BitVector row;
        if (i == j && this.reflexive) {
            this.reflexive = false;
            int k = 0;
            while (k < this.size) {
                if (k != i) {
                    this.set(k, k);
                }
                ++k;
            }
        }
        if ((row = this.rows[i]) != null) {
            row.clear(j);
        }
    }

    public void closure() {
        if (S.debug) {
            BitMatrix testcopy = (BitMatrix)this.clone();
            BitMatrix original = (BitMatrix)this.clone();
            this.closure2();
            testcopy.closure1();
            boolean equal = true;
            int i = 0;
            while (i < this.size) {
                if (this.getRow(i) != testcopy.getRow(i) && !this.getRow(i).equals(testcopy.getRow(i))) {
                    equal = false;
                }
                ++i;
            }
            if (!equal) {
                Debug.println("Warning new closure method produced incorrect results.");
                Debug.println("orginal matrix:");
                Debug.println(original.toString());
                Debug.println("closure using new method:");
                Debug.println(this.toString());
                Debug.println("closure using standard method:");
                Debug.println(testcopy.toString());
            }
        } else if (this.size < 16) {
            this.closure1();
        } else {
            this.closure2();
        }
    }

    private void closure1() {
        int size = this.size;
        int k = 0;
        while (k < size) {
            BitVector row_k = this.rows[k];
            if (row_k != null) {
                int i = 0;
                while (i < size) {
                    BitVector row_i = this.rows[i];
                    if (row_i != null && row_i.get(k)) {
                        row_i.or(row_k);
                    }
                    ++i;
                }
            }
            ++k;
        }
        this.reflexive = true;
    }

    private void closure2() {
        int size = this.size;
        boolean[] done = new boolean[size];
        boolean[] busy = new boolean[size];
        int[] index = new int[size];
        int[] bitpos = new int[size];
        int ndone = 0;
        while (ndone < size) {
            if (this.rows[ndone] != null && !done[ndone]) {
                int stackpos = 0;
                index[0] = ndone;
                bitpos[0] = 0;
                busy[ndone] = true;
                BitVector current = this.rows[ndone];
                while (stackpos >= 0) {
                    if (bitpos[stackpos] < 0) {
                        if (stackpos > 0) {
                            this.rows[index[stackpos - 1]].or(this.rows[index[stackpos]]);
                            current = this.rows[index[stackpos - 1]];
                        }
                        done[index[stackpos]] = true;
                        busy[index[stackpos--]] = false;
                        continue;
                    }
                    int nextbitpos = current.getLowestSetBit(bitpos[stackpos]);
                    if (nextbitpos < 0 || nextbitpos >= size) {
                        bitpos[stackpos] = -1;
                        continue;
                    }
                    bitpos[stackpos] = nextbitpos + 1;
                    if (this.rows[nextbitpos] == null) continue;
                    if (done[nextbitpos]) {
                        this.rows[index[stackpos]].or(this.rows[nextbitpos]);
                        continue;
                    }
                    if (!busy[nextbitpos]) {
                        busy[nextbitpos] = true;
                        index[++stackpos] = nextbitpos;
                        bitpos[stackpos] = 0;
                        current = this.rows[index[stackpos]];
                        continue;
                    }
                    if (index[stackpos] == nextbitpos) continue;
                    int tempsp = stackpos - 1;
                    BitVector cyclicmask = new BitVector(size);
                    do {
                        bitpos[tempsp] = -1;
                        this.rows[index[stackpos]].or(this.rows[index[tempsp]]);
                        cyclicmask.set(index[tempsp]);
                    } while (index[tempsp--] != nextbitpos);
                    current = (BitVector)current.clone();
                    current.andNot(cyclicmask);
                    bitpos[stackpos] = 0;
                }
            }
            ++ndone;
        }
        this.reflexive = true;
    }

    public BitMatrix transpose() {
        BitMatrix m = new BitMatrix(this.size);
        m.setSize(this.size);
        int i = 0;
        while (i < this.size) {
            BitVector row = this.rows[i];
            if (row != null) {
                int j = row.getLowestSetBit();
                while (j >= 0) {
                    m.set(j, i);
                    j = row.getLowestSetBit(j + 1);
                }
            }
            ++i;
        }
        m.reflexive = this.reflexive;
        return m;
    }

    public Object clone() {
        try {
            BitMatrix m = (BitMatrix)super.clone();
            BitVector[] v = (BitVector[])this.rows.clone();
            int i = 0;
            while (i < this.size) {
                BitVector row = v[i];
                if (row != null) {
                    v[i] = !row.isEmpty() ? (BitVector)row.clone() : null;
                }
                ++i;
            }
            m.rows = v;
            m.size = this.size;
            m.reflexive = this.reflexive;
            return m;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("Should never happen, since BitMatrix implements Cloneable");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("{");
        boolean needSeparator = false;
        int row = 0;
        while (row < this.size) {
            int col = 0;
            while (col < this.size) {
                if (this.get(row, col)) {
                    if (needSeparator) {
                        sb.append(", ");
                    } else {
                        needSeparator = true;
                    }
                    sb.append("(").append(row).append(",").append(col).append(")");
                }
                ++col;
            }
            ++row;
        }
        return sb.append("}").toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof BitMatrix)) {
            return false;
        }
        BitMatrix that = (BitMatrix)obj;
        int row = 0;
        while (row < this.size) {
            int col = 0;
            while (col < this.size) {
                if (this.get(row, col) != that.get(row, col)) {
                    return false;
                }
                ++col;
            }
            ++row;
        }
        return true;
    }

    public void topologicalSort(int m, int[] S2) {
        int n = this.size;
        int[] sortStack = new int[n - m];
        int sp = -1;
        int s = n - m;
        BitVector touched = new BitVector(n);
        touched.fill(m);
        int i = m;
        while (i < n) {
            if (!touched.get(i)) {
                touched.set(i);
                sortStack[++sp] = i;
                while (sp >= 0) {
                    int succ;
                    int j = sortStack[sp];
                    BitVector row_j = this.getRow(j);
                    if (row_j != null && (succ = row_j.getLowestSetBitNotIn(touched)) >= 0) {
                        touched.set(succ);
                        sortStack[++sp] = succ;
                        continue;
                    }
                    --sp;
                    S2[--s] = j;
                }
            }
            ++i;
        }
    }

    public int[] includedIn(int m, BitMatrix M) {
        if (this == M) {
            return null;
        }
        int i = 0;
        while (i < m) {
            BitVector row2;
            int j;
            BitVector row1 = this.getRow(i);
            if (row1 != null && 0 <= (j = (row2 = M.getRow(i)) != null ? row1.getLowestSetBitNotIn(row2) : row1.getLowestSetBit()) && j < m) {
                return new int[]{i, j};
            }
            ++i;
        }
        return null;
    }

    public void indexMove(int src, int dest) {
        this.rowMove(src, dest);
        this.colMove(src, dest);
    }

    private void rowMove(int src, int dest) {
        this.rows[dest] = this.getRow(src);
        this.rows[src] = null;
    }

    private void colMove(int src, int dest) {
        int i = 0;
        while (i < this.size) {
            BitVector row = this.getRow(i);
            if (row != null) {
                row.bitCopy(src, dest);
            }
            ++i;
        }
    }

    public void indexMerge(int src, int dest) {
        this.rowMerge(src, dest);
        this.colMerge(src, dest);
    }

    private void rowMerge(int src, int dest) {
        BitVector srcRow = this.getRow(src);
        if (srcRow != null) {
            BitVector destRow = this.getRow(dest);
            if (destRow == null) {
                this.rows[dest] = srcRow;
            } else {
                destRow.or(srcRow);
            }
        }
        this.rows[src] = null;
    }

    private void colMerge(int src, int dest) {
        int i = 0;
        while (i < this.size) {
            BitVector row = this.getRow(i);
            if (row != null) {
                row.bitMerge(src, dest);
            }
            ++i;
        }
    }

    public BitVector ideal(int x) {
        BitVector ideal = new BitVector(this.size);
        this.addIdeal(x, ideal);
        return ideal;
    }

    /*
     * WARNING - void declaration
     */
    private void addIdeal(int x, BitVector ideal) {
        ideal.set(x);
        BitVector xUp = this.getRow(x);
        if (xUp != null) {
            int y;
            while ((y = xUp.getLowestSetBitNotIn(ideal)) >= 0) {
                void var4_4;
                this.addIdeal((int)var4_4, ideal);
            }
        }
    }
}

