/*
 * Decompiled with CFR 0.152.
 */
package nice.lang.inline;

import bossa.util.User;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.Procedure2;

public class BinaryNumOp
extends Procedure2
implements Inlineable {
    private static final int error = 0;
    private static final int Sub = 1;
    private static final int Add = 2;
    private static final int Mul = 3;
    private static final int Div = 4;
    private static final int Rem = 5;
    private static final int Neg = 6;
    private static final int And = 7;
    private static final int IOr = 8;
    private static final int XOr = 9;
    private final int kind;

    public static BinaryNumOp create(String param) {
        int kind = 0;
        if ("Sub".equals(param)) {
            kind = 1;
        } else if ("Add".equals(param)) {
            kind = 2;
        } else if ("Mul".equals(param)) {
            kind = 3;
        } else if ("Div".equals(param)) {
            kind = 4;
        } else if ("Rem".equals(param)) {
            kind = 5;
        } else if ("Neg".equals(param)) {
            kind = 6;
        } else if ("And".equals(param)) {
            kind = 7;
        } else if ("IOr".equals(param)) {
            kind = 8;
        } else if ("XOr".equals(param)) {
            kind = 9;
        } else {
            User.error("Unknown inlined numeric operator " + param);
        }
        return new BinaryNumOp(kind);
    }

    private BinaryNumOp(int kind) {
        this.kind = kind;
    }

    public void compile(ApplyExp exp, Compilation comp, Target target) {
        Expression[] args = exp.getArgs();
        Expression arg0 = args[0];
        Expression arg1 = args[1];
        CodeAttr code = comp.getCode();
        PrimType type = (PrimType)Type.lowestCommonSuperType(arg0.getType(), arg1.getType());
        StackTarget stack = new StackTarget(type);
        arg0.compile(comp, stack);
        arg1.compile(comp, stack);
        switch (this.kind) {
            case 1: {
                code.emitSub(type);
                break;
            }
            case 2: {
                code.emitAdd(type);
                break;
            }
            case 3: {
                code.emitMul();
                break;
            }
            case 4: {
                code.emitDiv();
                break;
            }
            case 5: {
                code.emitRem();
                break;
            }
            case 7: {
                code.emitAnd();
                break;
            }
            case 8: {
                code.emitIOr();
                break;
            }
            case 9: {
                code.emitXOr();
                break;
            }
            default: {
                throw new Error("Bad case");
            }
        }
        target.compileFromStack(comp, type);
    }

    public Type getReturnType(Expression[] args) {
        return Type.lowestCommonSuperType(args[0].getType(), args[1].getType());
    }

    public Object apply2(Object arg1, Object arg2) {
        throw new Error("Not implemented");
    }
}

