/*
 * Decompiled with CFR 0.152.
 */
package nice.lang.inline;

import bossa.syntax.Macro;
import bossa.syntax.NullExp;
import bossa.util.User;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Branchable;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.QuoteExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.Procedure2;
import nice.tools.code.Types;

public class ReferenceOp
extends Procedure2
implements Branchable,
Macro {
    private static final int Eq = 1;
    private static final int Ne = 2;
    private final int kind;
    private static final Type retType = Type.boolean_type;

    public static ReferenceOp create(String param) {
        int kind = 0;
        if ("==".equals(param)) {
            kind = 1;
        } else if ("!=".equals(param)) {
            kind = 2;
        } else {
            User.error("Unknown inlined boolean operator " + param);
        }
        return new ReferenceOp(kind);
    }

    private ReferenceOp(int kind) {
        this.kind = kind;
    }

    public void compile(ApplyExp exp, Compilation comp, Target target) {
        Expression[] args = exp.getArgs();
        CodeAttr code = comp.getCode();
        StackTarget stack = new StackTarget(Type.pointer_type);
        Label _else = new Label(code);
        Label _end = new Label(code);
        if (args[0] instanceof QuoteExp && ((QuoteExp)args[0]).getType() == Type.nullType) {
            args[1].compile(comp, stack);
            if (this.kind == 1) {
                code.emitGotoIfNotNull(_else);
            } else {
                code.emitGotoIfNull(_else);
            }
        } else if (args[1] instanceof QuoteExp && ((QuoteExp)args[1]).getType() == Type.nullType) {
            args[0].compile(comp, stack);
            if (this.kind == 1) {
                code.emitGotoIfNotNull(_else);
            } else {
                code.emitGotoIfNull(_else);
            }
        } else {
            args[0].compile(comp, stack);
            args[1].compile(comp, stack);
            if (this.kind == 1) {
                code.emitGotoIfNE(_else);
            } else {
                code.emitGotoIfEq(_else);
            }
        }
        code.emitPushBoolean(true);
        code.emitGoto(_end);
        code.popType();
        _else.define(code);
        code.emitPushBoolean(false);
        _end.define(code);
        target.compileFromStack(comp, retType);
    }

    public void compileJump(Compilation comp, Expression[] args, Label to) {
        CodeAttr code = comp.getCode();
        StackTarget stack = new StackTarget(Type.pointer_type);
        if (args[0] instanceof QuoteExp && ((QuoteExp)args[0]).getType() == Type.nullType) {
            args[1].compile(comp, stack);
            if (this.kind == 1) {
                code.emitGotoIfNull(to);
            } else {
                code.emitGotoIfNotNull(to);
            }
        } else if (args[1] instanceof QuoteExp && ((QuoteExp)args[1]).getType() == Type.nullType) {
            args[0].compile(comp, stack);
            if (this.kind == 1) {
                code.emitGotoIfNull(to);
            } else {
                code.emitGotoIfNotNull(to);
            }
        } else {
            args[0].compile(comp, stack);
            args[1].compile(comp, stack);
            if (this.kind == 1) {
                code.emitGotoIfEq(to);
            } else {
                code.emitGotoIfNE(to);
            }
        }
    }

    public void compileJumpNot(Compilation comp, Expression[] args, Label to) {
        CodeAttr code = comp.getCode();
        StackTarget stack = new StackTarget(Type.pointer_type);
        if (args[0] instanceof QuoteExp && ((QuoteExp)args[0]).getType() == Type.nullType) {
            args[1].compile(comp, stack);
            if (this.kind == 1) {
                code.emitGotoIfNotNull(to);
            } else {
                code.emitGotoIfNull(to);
            }
        } else if (args[1] instanceof QuoteExp && ((QuoteExp)args[1]).getType() == Type.nullType) {
            args[0].compile(comp, stack);
            if (this.kind == 1) {
                code.emitGotoIfNotNull(to);
            } else {
                code.emitGotoIfNull(to);
            }
        } else {
            args[0].compile(comp, stack);
            args[1].compile(comp, stack);
            if (this.kind == 1) {
                code.emitGotoIfNE(to);
            } else {
                code.emitGotoIfEq(to);
            }
        }
    }

    public Type getReturnType(Expression[] args) {
        return retType;
    }

    public void checkSpecialRequirements(bossa.syntax.Expression[] arguments) {
        bossa.syntax.Expression exp = null;
        if (arguments[0] instanceof NullExp) {
            exp = arguments[1];
        } else if (arguments[1] instanceof NullExp) {
            exp = arguments[0];
        }
        if (exp != null && Types.isSure(exp.getType().getMonotype())) {
            User.warning(exp, "Comparing a non-null value with null");
        }
    }

    public Object apply2(Object arg1, Object arg2) {
        throw new Error("Not implemented");
    }
}

