/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.ant;

import bossa.modules.Compilation;
import bossa.modules.fun;
import java.io.File;
import nice.tools.ant.NicecListener;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class Nicec
extends Task {
    private static final String ERROR_MSG = "Compilation failed with errors.";
    private static final String BUG_MSG = "Compilation failed because of a bug in the compiler.";
    private static final String WARNING_MSG = "Compilation successful despite warnings.";
    private static final String OK_MSG = "Compilation successful.";
    private String sourcepath;
    private File destination;
    private String classpath = "";
    private String jar;
    private String output;
    private boolean recompile;
    private boolean recompile_all;
    private boolean compile;
    private boolean exclude_runtime;
    private String runtime = null;
    private String native_compiler;
    private boolean editor;
    private String pack;
    private Path nestedClasspath = null;

    public void setSourcepath(String string) {
        this.sourcepath = string;
    }

    public void setDestination(File file) {
        this.destination = file;
    }

    public void setClasspath(String string) {
        this.classpath = string;
    }

    public void setJar(String string) {
        this.jar = string;
    }

    public void setOutput(String string) {
        this.output = string;
    }

    public void setRecompile(boolean bl) {
        this.recompile = bl;
    }

    public void setRecompile_all(boolean bl) {
        this.recompile_all = bl;
    }

    public void setCompile(boolean bl) {
        this.compile = bl;
    }

    public void setExclude_runtime(boolean bl) {
        this.exclude_runtime = bl;
    }

    public void setRuntime(String string) {
        this.runtime = string;
    }

    public void setNative_compiler(String string) {
        this.native_compiler = string;
    }

    public void setEditor(boolean bl) {
        this.editor = bl;
    }

    public void setPackage(String string) {
        this.pack = string;
    }

    public Path createClasspath() {
        this.nestedClasspath = new Path(((ProjectComponent)this).project);
        return this.nestedClasspath.createPath();
    }

    public void execute() throws BuildException {
        this.log("runtime: " + this.runtime, 3);
        this.log("Base dir: " + ((ProjectComponent)this).project.getBaseDir(), 3);
        String string = System.getProperty("user.dir");
        try {
            System.setProperty("user.dir", ((ProjectComponent)this).project.getBaseDir().getAbsolutePath());
            NicecListener nicecListener = new NicecListener(this);
            Compilation compilation = fun.createCompilation(nicecListener);
            if (this.sourcepath != null) {
                compilation.sourcePath = this.sourcepath;
            }
            if (this.destination != null) {
                compilation.destinationDir = this.destination.getAbsolutePath();
            }
            compilation.packagePath = this.classpath + (this.nestedClasspath != null ? File.pathSeparator + this.nestedClasspath : "");
            compilation.output = this.jar;
            compilation.recompileCommandLine = this.recompile;
            compilation.recompileAll = this.recompile_all;
            compilation.skipLink = this.compile;
            compilation.excludeRuntime = this.exclude_runtime;
            compilation.runtimeFile = this.runtime;
            nice.tools.compiler.fun.compile(compilation, this.pack, this.output, this.native_compiler, this.editor);
            int n = nicecListener.statusCode;
            switch (n) {
                case 2: {
                    throw new BuildException(ERROR_MSG, this.location);
                }
                case 1: {
                    throw new BuildException(BUG_MSG, this.location);
                }
                case 3: {
                    this.log(WARNING_MSG, 1);
                    break;
                }
                case 0: {
                    this.log(OK_MSG, 2);
                }
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            System.setProperty("user.dir", string);
            throw throwable;
        }
        System.setProperty("user.dir", string);
    }

    public static void main(String[] stringArray) {
        Nicec nicec = new Nicec();
        nicec.setRuntime("../share/java/nice.jar");
        nicec.setPackage("test");
        nicec.execute();
    }
}

