/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.testsuite;

import bossa.modules.Package;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mlsub.typing.NullnessKind;
import nice.tools.compiler.console.fun;
import nice.tools.testsuite.TestSuite;
import nice.tools.testsuite.TestSuiteException;
import nice.tools.testsuite.output.ConsoleOutput;
import nice.tools.testsuite.output.HtmlOutput;
import nice.tools.testsuite.output.Output;
import nice.tools.util.DirectoryClassLoader;

public class TestNice {
    private static final String TESTSUITE_FILE_EXTENSION = ".testsuite";
    static final String KEYWORD_SIGN = "///";
    static final String KEYWORD_TOPLEVEL = "toplevel";
    static final String KEYWORD_PACKAGE = "package";
    static final String KEYWORD_IMPORT = "import";
    static final String KEYWORD_DONTCOMPILE = "dontcompile";
    static final String KEYWORD_FAILHERE = "fail here";
    private static File _tempFolder = new File("testsuite-temp-folder");
    private static File _failFolder = new File("testsuite-fail-folder");
    private static int _fileCounter = 0;
    private static int _testCasesSucceeded = 0;
    private static int _testCasesFailed = 0;
    private static int _testCasesWarning = 0;
    private static int _testCasesKnownBug = 0;
    private static int _testCasesFixed = 0;
    private static Output _output = new ConsoleOutput();
    private static List _testSuites = new ArrayList();
    private static boolean _writeComments;
    private static boolean _wait;
    private static String _runtime;
    private static Comparator fileComp;

    public static void main(String[] args) {
        if (!TestNice.processArgs(args)) {
            TestNice.usage();
            System.exit(1);
        }
        _output.startApplication();
        TestNice.cleanupTempFolder();
        TestNice.cleanupFailFolder();
        try {
            Iterator iter = _testSuites.iterator();
            while (iter.hasNext()) {
                new TestNice().performTests((String)iter.next());
            }
        }
        catch (TestSuiteException e) {
            e.printStackTrace();
        }
        if (_wait) {
            TestNice.reclaimMemory(true);
            System.out.println("Test finished.\nPress return to terminate:");
            try {
                new DataInputStream(System.in).readLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        _output.endApplication();
        _output.close();
        if (TestNice.getTestCasesFailed() > 0) {
            System.exit(1);
        }
        if (TestNice.getTestCasesWarning() > 0) {
            System.exit(2);
        }
        System.exit(0);
    }

    private static void reclaimMemory(boolean clear) {
        Package.startNewCompilation();
        NullnessKind.setSure(null);
        NullnessKind.setMaybe(null);
        if (clear) {
            try {
                int[] l = new int[1000];
                while (true) {
                    l = new int[l.length * 2];
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
        }
        System.gc();
        fun.printMemoryUsage();
    }

    private static boolean processArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            String s = args[i];
            ++i;
            if (s.startsWith("-")) {
                if ("-output".equalsIgnoreCase(s)) {
                    TestNice.setOutput(args[i++]);
                    continue;
                }
                if ("-comment".equalsIgnoreCase(s)) {
                    _writeComments = true;
                    continue;
                }
                if ("-runtime".equalsIgnoreCase(s)) {
                    _runtime = args[i++];
                    continue;
                }
                if ("-wait".equalsIgnoreCase(s)) {
                    _wait = true;
                    continue;
                }
                return false;
            }
            _testSuites.add(s);
        }
        return true;
    }

    private static void setOutput(String output) {
        if ("console".equalsIgnoreCase(output)) {
            _output = new ConsoleOutput();
            return;
        }
        if ((output = output.toLowerCase()).endsWith(".html") || output.endsWith(".htm")) {
            try {
                _output = new HtmlOutput(new FileWriter(new File(output)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void usage() {
        System.out.println("usage:\n java nice.tools.testsuiteTestNice [testSuiteFile | folder]");
    }

    static void cleanupTempFolder() {
        if (_tempFolder.exists()) {
            TestNice.deleteFolder(_tempFolder);
        }
        _tempFolder.mkdir();
    }

    private static void cleanupFailFolder() {
        if (_failFolder.exists()) {
            TestNice.deleteFolder(_failFolder);
        }
        _failFolder.mkdir();
    }

    static void moveFilesToFailFolder() {
        File folder = new File(_failFolder, "" + (_testCasesFailed + _testCasesKnownBug));
        _tempFolder.renameTo(folder);
        _tempFolder.mkdir();
    }

    static int getFileCounter() {
        return ++_fileCounter;
    }

    private static void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isFile()) {
                file.delete();
            } else {
                TestNice.deleteFolder(file);
            }
            ++i;
        }
        folder.delete();
    }

    private void performTests(String testSuitePath) throws TestSuiteException {
        File file = new File(testSuitePath);
        if (!file.exists()) {
            throw new TestSuiteException("Could not find testsuite file or folder: " + file.getAbsolutePath());
        }
        if (file.isFile()) {
            new TestSuite(file);
            return;
        }
        HashSet testSuiteFiles = new HashSet();
        this.getTestSuiteFiles(file, testSuiteFiles);
        ArrayList files = new ArrayList(testSuiteFiles);
        Collections.sort(files, fileComp);
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            new TestSuite((File)iter.next());
        }
    }

    private void getTestSuiteFiles(File folder, Set testSuiteFiles) {
        File[] files = folder.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isFile()) {
                if (file.getName().endsWith(TESTSUITE_FILE_EXTENSION)) {
                    testSuiteFiles.add(file);
                }
            } else {
                this.getTestSuiteFiles(file, testSuiteFiles);
            }
            ++i;
        }
    }

    public static File getTempFolder() {
        return _tempFolder;
    }

    public static File getFailFolder() {
        return _failFolder;
    }

    public static void increaseSucceeded() {
        ++_testCasesSucceeded;
    }

    public static void increaseFailed() {
        ++_testCasesFailed;
    }

    public static void increaseWarning() {
        ++_testCasesWarning;
    }

    public static void increaseKnownBug() {
        ++_testCasesKnownBug;
    }

    public static void increaseFixed() {
        ++_testCasesFixed;
    }

    static Output getOutput() {
        return _output;
    }

    static boolean getWriteComments() {
        return _writeComments;
    }

    static String getRuntime() {
        return _runtime;
    }

    static ClassLoader getClassLoader() {
        if (_runtime == null) {
            _runtime = "classes";
        }
        File[] dirs = new File[]{TestNice.getTempFolder(), new File(TestNice.getRuntime())};
        return new DirectoryClassLoader(dirs, null);
    }

    public static int getTotalTestCases() {
        return _testCasesSucceeded + _testCasesFailed + _testCasesWarning + _testCasesKnownBug + _testCasesFixed;
    }

    public static int getTestCasesSucceeded() {
        return _testCasesSucceeded;
    }

    public static int getTestCasesFailed() {
        return _testCasesFailed;
    }

    public static int getTestCasesWarning() {
        return _testCasesWarning;
    }

    public static int getTestCasesKnownBug() {
        return _testCasesKnownBug;
    }

    public static int getTestCasesFixed() {
        return _testCasesFixed;
    }

    static {
        fileComp = new FileComparator();
    }

    private static class FileComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            File file1 = (File)o1;
            File file2 = (File)o2;
            if (file1.lastModified() < file2.lastModified()) {
                return 1;
            }
            if (file1.lastModified() > file2.lastModified()) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            return false;
        }
    }
}

