/*
 * Decompiled with CFR 0.152.
 */
package bossa.link;

import bossa.link.Alternative;
import bossa.syntax.JavaMethod;
import bossa.syntax.LocatedString;
import bossa.syntax.MethodDeclaration;
import bossa.syntax.Node;
import bossa.syntax.Pattern;
import bossa.syntax.PrimitiveType;
import bossa.syntax.VarSymbol;
import bossa.util.Internal;
import bossa.util.Location;
import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.Method;
import gnu.bytecode.MiscAttr;
import gnu.bytecode.Type;
import gnu.expr.Expression;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nice.tools.code.SpecialArray;
import nice.tools.util.System;

public class ImportedAlternative
extends Alternative {
    private Expression code;
    private Location location;

    public static void read(ClassType c, Method method, Location location) {
        MiscAttr attr = (MiscAttr)Attribute.get(method, "definition");
        if (attr == null) {
            return;
        }
        String fullName = new String(attr.data);
        ImportedAlternative.registerJavaMethod(fullName);
        attr = (MiscAttr)Attribute.get(method, "patterns");
        if (attr == null) {
            Internal.error("Method " + method.getName() + " in class " + c.getName() + " has no patterns");
        }
        String rep = new String(attr.data);
        int[] at = new int[]{0};
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(5);
        try {
            Pattern p;
            while ((p = Pattern.read(rep, at, fullName)) != null) {
                int argnum;
                if (p.getTC() == PrimitiveType.arrayTC && method.arg_types[argnum = patterns.size()] == Type.pointer_type) {
                    method.arg_types[argnum] = SpecialArray.unknownTypeArray();
                }
                patterns.add(p);
            }
            ImportedAlternative alt = new ImportedAlternative(method.getName(), patterns.toArray(new Pattern[patterns.size()]), new QuoteExp(new PrimProcedure(method)), location);
            alt.add(System.split(fullName, ';'));
        }
        catch (Pattern.Unknown ex) {
            // empty catch block
        }
    }

    private static void registerJavaMethod(String fullName) {
        if (!fullName.startsWith("JAVA:")) {
            return;
        }
        int end = fullName.lastIndexOf(58);
        LocatedString methodName = new LocatedString(fullName.substring("JAVA:".length(), end), Location.nowhere());
        List methods = Node.getGlobalScope().lookup(methodName);
        Iterator i = methods.iterator();
        while (i.hasNext()) {
            MethodDeclaration md;
            VarSymbol next = (VarSymbol)i.next();
            if (next.getMethodDeclaration() == null || !(md = next.getMethodDeclaration()).getFullName().equals(fullName)) continue;
            ((JavaMethod)md).registerForDispatch();
            return;
        }
    }

    private ImportedAlternative(String name, Pattern[] patterns, Expression code, Location location) {
        super(name, patterns);
        this.code = code;
        this.location = location;
    }

    public Expression methodExp() {
        return this.code;
    }

    public Location location() {
        return this.location;
    }
}

