/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.Arguments;
import bossa.syntax.Constraint;
import bossa.syntax.Definition;
import bossa.syntax.ExpLocalVariable;
import bossa.syntax.Expression;
import bossa.syntax.FieldAccess;
import bossa.syntax.FunExp;
import bossa.syntax.JavaFieldAccess;
import bossa.syntax.LocatedString;
import bossa.syntax.PrimitiveType;
import bossa.syntax.RetypedJavaMethod;
import bossa.syntax.Statement;
import bossa.syntax.SymbolExp;
import bossa.util.Debug;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.Location;
import bossa.util.User;
import bossa.util.Util;
import gnu.bytecode.ClassType;
import gnu.expr.ApplyExp;
import gnu.expr.LetExp;
import java.util.ArrayList;
import java.util.LinkedList;
import mlsub.typing.BadSizeEx;
import mlsub.typing.FunType;
import mlsub.typing.FunTypeKind;
import mlsub.typing.Monotype;
import mlsub.typing.Polytype;
import mlsub.typing.TupleType;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;
import mlsub.typing.lowlevel.Engine;
import nice.tools.code.EnsureTypeProc;
import nice.tools.code.Types;

public class CallExp
extends Expression {
    private boolean overloadingResolved;
    private Polytype instanciatedDomain;
    Expression function;
    protected Arguments arguments;
    final boolean infix;
    public final boolean hasBrackets;
    ClassType declaringClass = null;
    ExpLocalVariable[] localVars = null;

    public CallExp(Expression function, Arguments arguments) {
        this(function, arguments, false, true);
    }

    public CallExp(Expression function, Arguments arguments, boolean infix, boolean hasBrackets) {
        this.function = function;
        this.arguments = arguments;
        this.infix = infix;
        this.hasBrackets = hasBrackets;
    }

    public static CallExp create(Expression function, Expression param1) {
        LinkedList<Arguments.Argument> params = new LinkedList<Arguments.Argument>();
        params.add(new Arguments.Argument(param1));
        CallExp res = new CallExp(function, new Arguments(params));
        res.setLocation(function.location());
        return res;
    }

    public static CallExp create(Expression function, Expression param1, Expression param2) {
        ArrayList<Arguments.Argument> params = new ArrayList<Arguments.Argument>(2);
        params.add(new Arguments.Argument(param1));
        params.add(new Arguments.Argument(param2));
        CallExp res = new CallExp(function, new Arguments(params));
        res.setLocation(function.location());
        return res;
    }

    public static CallExp create(Expression function, Expression param1, Expression param2, Expression param3) {
        ArrayList<Arguments.Argument> params = new ArrayList<Arguments.Argument>(2);
        params.add(new Arguments.Argument(param1));
        params.add(new Arguments.Argument(param2));
        params.add(new Arguments.Argument(param3));
        CallExp res = new CallExp(function, new Arguments(params));
        res.setLocation(function.location());
        return res;
    }

    public void addBlockArgument(Statement block, LocatedString name) {
        this.arguments.add(new FunExp(Constraint.True, new LinkedList(), block), name);
    }

    static Polytype wellTyped(Polytype funt, Polytype[] parameters) {
        try {
            Polytype t = CallExp.getType(funt, parameters, true);
            return t;
        }
        catch (ReportErrorEx e) {
        }
        catch (TypingEx e) {
        }
        catch (BadSizeEx badSizeEx) {
            // empty catch block
        }
        return null;
    }

    static Polytype getTypeAndReportErrors(Location loc, Expression function, Expression[] parameters) {
        Object[] paramTypes = Expression.getType(parameters);
        try {
            return CallExp.getType(function.getType(), (Polytype[])paramTypes, false);
        }
        catch (BadSizeEx e) {
            User.error((Located)loc, function.toString(1) + " expects " + e.expected + " parameters, " + "not " + e.actual);
        }
        catch (ReportErrorEx e) {
            User.error((Located)loc, e.getMessage());
        }
        catch (TypingEx e) {
            if (Typing.dbg) {
                Debug.println(e.getMessage());
            }
            if (function.isFieldAccess()) {
                User.error((Located)loc, parameters[0] + " has no field " + function);
            }
            String end = "not within the domain of function \"" + function + "\"";
            if (parameters.length >= 2) {
                User.error((Located)loc, "Parameters \n" + Util.map("(", ", ", ")", parameters) + "\n of types \n" + Util.map("(", ",\n  ", ")", paramTypes) + "\n are " + end);
            }
            User.error((Located)loc, "Parameter " + Util.map("", ", ", "", parameters) + " of type " + Util.map("", ", ", "", paramTypes) + " is " + end);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Polytype getType(Polytype type, Polytype[] parameters, boolean tentative) throws TypingEx, BadSizeEx, ReportErrorEx {
        Monotype m = type.getMonotype();
        if (m.head() == null) {
            throw new ReportErrorEx("Nullness check");
        }
        try {
            Typing.leq(m.head(), PrimitiveType.sureTC);
        }
        catch (TypingEx ex) {
            throw new ReportErrorEx("This function may be null");
        }
        m = nice.tools.typing.Types.rawType(m);
        if (m.getKind() == Engine.variablesConstraint) {
            m.setKind(null);
        }
        if (m.getKind() == null) {
            m.setKind(FunTypeKind.get(parameters.length));
        }
        if (!((m = m.equivalent()) instanceof FunType)) {
            throw new ReportErrorEx("Not a function");
        }
        FunType funt = (FunType)m;
        Object[] dom = funt.domain();
        mlsub.typing.Constraint cst = type.getConstraint();
        boolean doEnter = true;
        Typing.enter(tentative);
        boolean ok = false;
        try {
            try {
                mlsub.typing.Constraint.enter(cst);
            }
            catch (TypingEx e) {
                throw new ReportErrorEx("The conditions for using this function are not fullfiled");
            }
            if (Typing.dbg) {
                Debug.println("Parameters:\n" + Util.map("", ", ", "\n", parameters));
                Debug.println("Domain:\n" + Util.map("", ", ", "\n", dom));
            }
            Typing.in(parameters, (Monotype[])dom);
            ok = true;
            Typing.leave(tentative, tentative && ok);
        }
        catch (Throwable throwable) {
            Typing.leave(tentative, tentative && ok);
            throw throwable;
        }
        return Polytype.apply(cst, funt, parameters);
    }

    void resolveOverloading() {
        if (this.overloadingResolved) {
            return;
        }
        this.overloadingResolved = true;
        this.arguments.noOverloading();
        this.function = this.function.resolveOverloading(this);
        this.function.checkSpecialRequirements(this.arguments.computedExpressions);
        this.getType();
        Expression.adjustToExpectedType(this.arguments.computedExpressions, nice.tools.typing.Types.parameters(this.function.getType()));
    }

    void computeType() {
        this.resolveOverloading();
        if (this.type == null) {
            this.setComputedType(CallExp.getTypeAndReportErrors(this.location(), this.function, this.arguments.inOrder()), null);
            this.arguments.computedExpressions = this.arguments.inOrder();
        }
    }

    void setComputedType(Polytype type, Monotype[] argTypes) {
        this.type = type;
        if (!type.isMonomorphic() && argTypes != null) {
            this.instanciatedDomain = new Polytype(type.getConstraint(), new TupleType(argTypes));
            this.instanciatedDomain = this.instanciatedDomain.cloneType();
            this.instanciatedDomain.setNotSimplified();
            this.instanciatedDomain.simplify();
        }
        if (!type.trySimplify()) {
            User.warning(this, "This call might have a type error, or this might be a bug in the compiler. \nPlease contact bonniot@users.sourceforge.net");
        }
    }

    public boolean isAssignable() {
        this.resolveOverloading();
        return this.function.isFieldAccess();
    }

    FieldAccess getField() {
        this.resolveOverloading();
        return this.function.getFieldAccessMethod();
    }

    protected gnu.expr.Expression compile() {
        LetExp firstLetExp = null;
        LetExp letExpRes = null;
        if (this.localVars != null) {
            for (int i = this.localVars.length - 1; i >= 0; --i) {
                gnu.expr.Expression[] eVal = new gnu.expr.Expression[1];
                LetExp letExp = new LetExp(eVal);
                eVal[0] = this.localVars[i].variable.compile(letExp);
                if (i == this.localVars.length - 1) {
                    firstLetExp = letExp;
                } else {
                    letExp.setBody(letExpRes);
                }
                letExpRes = letExp;
            }
        }
        gnu.expr.Expression res = this.function.isFieldAccess() ? this.function.getFieldAccessMethod().compileAccess(this.compileParams()) : new ApplyExp(this.function.generateCodeInCallPosition(), this.compileParams());
        this.location().write(res);
        if (firstLetExp != null) {
            firstLetExp.setBody(res);
            res = letExpRes;
        }
        return EnsureTypeProc.ensure(res, Types.javaType(this.type));
    }

    private gnu.expr.Expression[] compileParams() {
        gnu.expr.Expression[] params = Expression.compile(this.arguments.computedExpressions);
        Monotype[] domain = null;
        if (this.instanciatedDomain != null) {
            domain = ((TupleType)this.instanciatedDomain.getMonotype()).getComponents();
        }
        if (domain != null) {
            for (int i = 0; i < params.length; ++i) {
                params[i] = EnsureTypeProc.ensure(params[i], Types.javaType(domain[i]));
            }
        }
        return params;
    }

    gnu.expr.Expression compileAssign(gnu.expr.Expression value) {
        FieldAccess access;
        if (!this.function.isFieldAccess()) {
            Internal.error(this, "Assignment to a call that is not a field access");
        }
        if ((access = this.function.getFieldAccessMethod()).isFinal()) {
            User.error((Located)this, "Field " + access + " is final");
        }
        switch (this.arguments.size()) {
            case 0: {
                return access.compileAssign(value);
            }
            case 1: {
                return access.compileAssign(this.arguments.getExp(0).generateCode(), value);
            }
        }
        Internal.error(this, "A field access should have 0 or 1 parameter");
        return null;
    }

    public String toString() {
        if (!this.infix) {
            return this.function.toString(2) + this.arguments;
        }
        if (this.declaringClass == null) {
            return this.arguments.getExp(0) + "." + this.function + this.arguments.toStringInfix();
        }
        if (this.function instanceof SymbolExp) {
            Definition def = ((SymbolExp)this.function).getSymbol().getDefinition();
            if (def instanceof RetypedJavaMethod) {
                return this.function.toString() + this.arguments;
            }
            if (def instanceof JavaFieldAccess) {
                return this.declaringClass.getName() + "." + ((JavaFieldAccess)def).fieldName + this.arguments;
            }
        }
        return this.declaringClass.getName() + "." + this.function + this.arguments;
    }

    static class ReportErrorEx
    extends Exception {
        ReportErrorEx(String msg) {
            super(msg);
        }
    }
}

