/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.Arguments;
import bossa.syntax.Expression;
import bossa.syntax.FormalParameters;
import bossa.syntax.LocatedString;
import bossa.syntax.MethodDeclaration;
import bossa.syntax.MonoSymbol;
import bossa.syntax.NiceClass;
import bossa.syntax.PrimitiveType;
import bossa.util.Location;
import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.ConstructorExp;
import gnu.expr.Declaration;
import gnu.expr.InitializeProc;
import gnu.expr.InstantiateProc;
import gnu.expr.QuoteExp;
import gnu.expr.ThisExp;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mlsub.typing.Constraint;
import mlsub.typing.FunType;
import mlsub.typing.Monotype;
import mlsub.typing.Polytype;
import nice.tools.code.Gen;

class Constructor
extends MethodDeclaration {
    private NiceClass classe;
    private NiceClass.Field[] fields;
    private MethodDeclaration parent;
    private gnu.expr.Expression initialize;
    private gnu.expr.Expression initializeFromConstructor;
    private gnu.expr.Expression initializeOmitDefaults;
    private gnu.expr.Expression instantiate;
    private static gnu.expr.Expression objectConstructor = new QuoteExp(new InitializeProc(Type.pointer_type.getDeclaredMethod("<init>", 0)));

    Constructor(NiceClass classe, NiceClass.Field[] fields, MethodDeclaration parent, Location location, FormalParameters formals, Constraint cst, Monotype[] parameters, Monotype returnType) {
        super(new LocatedString("<init>", location), formals, cst, parameters, returnType);
        this.classe = classe;
        this.fields = fields;
        this.parent = parent;
        Polytype type = new Polytype(this.getType().getConstraint(), new FunType(this.getArgTypes(), PrimitiveType.voidType));
        classe.addConstructorCallSymbol(new MethodDeclaration.Symbol(this.name, type){

            gnu.expr.Expression compileInCallPosition() {
                Constructor.this.getCode();
                return Constructor.this.initializeFromConstructor;
            }
        });
    }

    gnu.expr.Expression getConstructorInvocation(boolean omitDefaults) {
        this.getCode();
        return omitDefaults && this.initializeOmitDefaults != null ? this.initializeOmitDefaults : this.initialize;
    }

    protected gnu.expr.Expression computeCode() {
        this.createBytecode(true);
        this.createBytecode(false);
        return this.instantiate;
    }

    private void createBytecode(boolean omitDefaults) {
        ClassType thisType = (ClassType)this.javaReturnType();
        Declaration thisDecl = new Declaration("this");
        thisDecl.setType(thisType);
        ThisExp thisExp = new ThisExp(thisDecl);
        MonoSymbol[] fullArgs = this.parameters.getMonoSymbols();
        Type[] fullArgTypes = this.javaArgTypes();
        LinkedList<MonoSymbol> args = new LinkedList<MonoSymbol>();
        LinkedList<Type> argTypes = new LinkedList<Type>();
        for (int i = 0; i < this.parameters.size; ++i) {
            if (omitDefaults && this.parameters.hasDefaultValue(i)) continue;
            args.add(fullArgs[i]);
            argTypes.add(fullArgTypes[i]);
        }
        if (omitDefaults && args.size() == fullArgs.length) {
            return;
        }
        Type[] argTypesArray = argTypes.toArray(new Type[argTypes.size()]);
        MonoSymbol[] argsArray = args.toArray(new MonoSymbol[args.size()]);
        if (this.classe.definition.inInterfaceFile()) {
            throw new Error("Constructors are loaded from the compiled package");
        }
        ConstructorExp lambda2 = Gen.createConstructor(thisDecl, argTypesArray, argsArray);
        lambda2.setSuperCall(this.callSuper(thisExp, fullArgs, omitDefaults));
        Gen.setMethodBody(lambda2, this.body(thisExp, fullArgs, omitDefaults));
        this.classe.getClassExp().addMethod(lambda2);
        if (!omitDefaults) {
            lambda2.addBytecodeAttribute(this.parameters.asBytecodeAttribute());
        }
        if (omitDefaults) {
            this.initializeOmitDefaults = new QuoteExp(new InitializeProc(lambda2));
        } else {
            this.initialize = new QuoteExp(new InitializeProc(lambda2));
            this.initializeFromConstructor = new QuoteExp(new InitializeProc(lambda2, true));
            this.instantiate = new QuoteExp(new InstantiateProc(lambda2));
        }
    }

    private gnu.expr.Expression callSuper(gnu.expr.Expression thisExp, MonoSymbol[] args, boolean omitDefaults) {
        int len = args.length - this.fields.length;
        LinkedList<gnu.expr.Expression> superArgs = new LinkedList<gnu.expr.Expression>();
        superArgs.add(thisExp);
        for (int i = 0; i < len; ++i) {
            if (omitDefaults && this.parameters.hasDefaultValue(i)) continue;
            superArgs.add(args[i].compile());
        }
        gnu.expr.Expression superExp = this.parent == null ? objectConstructor : this.parent.getConstructorInvocation(omitDefaults);
        return new ApplyExp(superExp, superArgs.toArray(new gnu.expr.Expression[superArgs.size()]));
    }

    private gnu.expr.Expression body(gnu.expr.Expression thisExp, MonoSymbol[] fullArgs, boolean omitDefaults) {
        int i;
        int len = this.fields.length + this.classe.nbInitializers();
        if (len == 0) {
            return QuoteExp.voidExp;
        }
        gnu.expr.Expression[] body = new gnu.expr.Expression[len];
        int superArgs = fullArgs.length - this.fields.length;
        for (i = 0; i < this.fields.length; ++i) {
            Expression value = this.fields[i].value;
            gnu.expr.Expression fieldValue = !omitDefaults || value == null ? fullArgs[superArgs + i].compile() : value.compile();
            body[i] = this.fields[i].method.compileAssign(thisExp, fieldValue);
        }
        this.classe.setThisExp(thisExp);
        for (i = 0; i < this.classe.nbInitializers(); ++i) {
            body[this.fields.length + i] = this.classe.compileInitializer(i);
        }
        return new BeginExp(body);
    }

    public void printInterface(PrintWriter s) {
        throw new Error("Should not be called");
    }

    String explainWhyMatchFails(Arguments arguments) {
        String name = this.classe.getName();
        StringBuffer res = new StringBuffer();
        res.append("Class ").append(name);
        if (this.parameters.size == 0) {
            res.append(" has no fields. Therefore its constructor takes no arguments.");
            return res.toString();
        }
        List nonmatching = arguments.noMatchByName(this.parameters);
        if (!nonmatching.isEmpty()) {
            res.append(" has no field named " + nonmatching.get(0));
            return res.toString();
        }
        res = new StringBuffer();
        List missing = arguments.missingArgs(this.parameters);
        Iterator missingFields = null;
        if (arguments.size() == 0 || missing.size() > 0) {
            res.append("Fields of class ").append(name).append(" require initial values.\n");
            if (arguments.size() == 0) {
                res.append(this.syntaxExample()).append("Class ").append(name).append(" has the following fields:\n");
                missingFields = this.parameters.iterator();
            } else {
                res.append("These fields are missing:\n");
                missingFields = missing.iterator();
            }
        } else {
            res.append("Too many arguments when constructing new instance of class ").append(name).append(".\n").append("The constructor accepts the following arguments:\n");
            missingFields = this.parameters.iterator();
        }
        while (missingFields.hasNext()) {
            res.append("  ").append(missingFields.next()).append("\n");
        }
        return res.toString();
    }

    private String syntaxExample() {
        String name = this.classe.getName();
        StringBuffer res = new StringBuffer();
        res.append("Use the following syntax:\n").append("  new ").append(name).append("(");
        Iterator params = this.parameters.getRequiredParameters().iterator();
        int paramCount = 0;
        int len = name.length();
        while (params.hasNext()) {
            FormalParameters.Parameter param = (FormalParameters.Parameter)params.next();
            if (paramCount != 0) {
                res.append(", ");
            }
            if (paramCount == 3 && params.hasNext()) {
                res.append('\n');
                for (int i = 0; i < len; ++i) {
                    res.append(' ');
                }
                res.append("        ");
                paramCount = 0;
            }
            if (param instanceof FormalParameters.NamedParameter) {
                res.append(param.getName()).append(": value");
            } else {
                res.append("value");
            }
            ++paramCount;
        }
        res.append(")\n\n");
        return res.toString();
    }
}

