/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.Arguments;
import bossa.syntax.ClassDefinition;
import bossa.syntax.ConstantExp;
import bossa.syntax.Definition;
import bossa.syntax.Expression;
import bossa.syntax.IdentExp;
import bossa.syntax.LiteralArrayExp;
import bossa.syntax.LocatedString;
import bossa.syntax.MethodBodyDefinition;
import bossa.syntax.MonoSymbol;
import bossa.syntax.Monotype;
import bossa.syntax.NewExp;
import bossa.syntax.NiceClass;
import bossa.syntax.PrimitiveType;
import bossa.syntax.ReturnStmt;
import bossa.syntax.StringConstantExp;
import bossa.syntax.TypeIdent;
import bossa.syntax.dispatch;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.Location;
import bossa.util.User;
import bossa.util.Util;
import gnu.expr.Declaration;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;
import nice.tools.code.Types;

public class EnumDefinition
extends Definition {
    String shortName;
    ClassDefinition classDef;
    List elements;
    List symbols;
    List fields;
    List elementsArgs;
    List interfaces;

    public EnumDefinition(LocatedString name, List elements, List fields, List argsList, List globalDefs, List interfaces) {
        super(name, 1);
        Iterator it;
        this.shortName = name.toString();
        this.classDef = ClassDefinition.makeClass(name, true, false, null, new ArrayList(0), new TypeIdent(new LocatedString("nice.lang.Enum", name.location())), interfaces, null);
        NiceClass impl = new NiceClass(this.classDef);
        int fieldsCount = fields.size();
        if (fieldsCount > 0) {
            ArrayList<NiceClass.Field> newFields = new ArrayList<NiceClass.Field>(fieldsCount);
            it = fields.iterator();
            while (it.hasNext()) {
                newFields.add(impl.makeField((MonoSymbol)it.next(), null, true, false, false, null));
            }
            impl.setFields(newFields);
        } else {
            impl.setFields(null);
        }
        impl.setOverrides(null);
        if (!this.inInterfaceFile()) {
            LinkedList<IdentExp> exps = new LinkedList<IdentExp>();
            it = elements.iterator();
            while (it.hasNext()) {
                exps.add(new IdentExp((LocatedString)it.next()));
            }
            ReturnStmt body = new ReturnStmt(new LiteralArrayExp(exps), true);
            LocatedString mName = new LocatedString("family", Location.nowhere());
            MethodBodyDefinition mBodyDef = new MethodBodyDefinition(impl, mName, null, new LinkedList(), body);
            globalDefs.add(mBodyDef);
        }
        this.classDef.setImplementation(impl);
        this.addChild(this.classDef);
        this.elements = elements;
        this.fields = fields;
        this.elementsArgs = argsList;
        this.interfaces = interfaces;
        this.symbols = new LinkedList();
        for (int ord = 0; ord < elements.size(); ++ord) {
            List args = (List)argsList.get(ord);
            LocatedString elemName = (LocatedString)elements.get(ord);
            if (args.size() != fieldsCount) {
                User.error((Located)elemName, "the number of arguments doesn't match the number of enum fields");
            }
            TypeIdent type = new TypeIdent(name);
            type.nullness = (byte)3;
            this.symbols.add(new EnumSymbol(name, elemName, type, ord, fields, args));
        }
        this.addChildren(this.symbols);
    }

    void resolve() {
        Iterator it = this.symbols.iterator();
        while (it.hasNext()) {
            EnumSymbol symbol = (EnumSymbol)it.next();
            symbol.value = dispatch.analyse(symbol.value, this.scope, this.typeScope);
        }
    }

    void typecheck() {
        Iterator it = this.symbols.iterator();
        while (it.hasNext()) {
            EnumSymbol symbol = (EnumSymbol)it.next();
            try {
                symbol.value = symbol.value.resolveOverloading(symbol.getType());
                dispatch.typecheck(symbol.value);
                Typing.leq(symbol.value.getType(), symbol.getType());
            }
            catch (TypingEx e) {
                Internal.error(this, "Typing error in enum:");
            }
        }
    }

    public void printInterface(PrintWriter s) {
        s.print(this.toString() + "\n");
    }

    public void compile() {
        Iterator it = this.symbols.iterator();
        while (it.hasNext()) {
            EnumSymbol symbol = (EnumSymbol)it.next();
            Declaration declaration = symbol.getDeclaration();
            declaration.setFlag(16384);
            declaration.noteValue(symbol.value.compile());
        }
    }

    public String toString() {
        if (this.fields.isEmpty()) {
            return "enum " + this.shortName + Util.map(" {", " , ", " }", this.elements);
        }
        String res = "enum " + this.shortName + Util.map("(", ", ", ")", this.fields);
        if (this.interfaces != null) {
            res = res + " implements " + Util.map("", " , ", "", this.interfaces);
        }
        res = res + " {";
        for (int i = 0; i < this.elements.size(); ++i) {
            if (i != 0) {
                res = res + ", ";
            }
            res = res + this.elements.get(i) + Util.map("(", ", ", ")", (List)this.elementsArgs.get(i));
        }
        return res + "}";
    }

    class EnumSymbol
    extends MonoSymbol {
        Expression value;

        EnumSymbol(LocatedString enumName, LocatedString name, Monotype type, int ordinal, List fields, List argExps) {
            super(name, type);
            ArrayList<Arguments.Argument> args = new ArrayList<Arguments.Argument>(2 + fields.size());
            args.add(new Arguments.Argument(new StringConstantExp(name.toString()), new LocatedString("name", name.location)));
            Integer val = new Integer(ordinal);
            args.add(new Arguments.Argument(new ConstantExp(PrimitiveType.intTC, val, val.toString(), name.location()), new LocatedString("ordinal", name.location)));
            for (int i = 0; i < fields.size(); ++i) {
                args.add(new Arguments.Argument((Expression)argExps.get(i), ((MonoSymbol)fields.get(i)).getName()));
            }
            this.value = new NewExp(new TypeIdent(enumName), new Arguments(args));
        }

        boolean isAssignable() {
            return false;
        }

        Declaration getDeclaration() {
            Declaration res = super.getDeclaration();
            if (res == null) {
                res = new Declaration(this.name.toString(), Types.javaType(this.type));
                this.setDeclaration(res);
                EnumDefinition.this.module.addGlobalVar(res, true);
            }
            return res;
        }

        Expression getValue() {
            return this.value;
        }

        public Definition getDefinition() {
            return EnumDefinition.this;
        }
    }
}

