/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.ClassDefinition;
import bossa.syntax.JavaClasses;
import bossa.syntax.LocatedString;
import bossa.util.Located;
import bossa.util.User;
import gnu.bytecode.ClassType;
import java.io.PrintWriter;
import mlsub.typing.TypeConstructor;
import nice.tools.code.TypeImport;

public class JavaClass
extends ClassDefinition.ClassImplementation {
    ClassDefinition definition;
    private LocatedString javaName;
    boolean ignoredRetyping;

    public JavaClass(ClassDefinition definition, LocatedString javaName) {
        this.definition = definition;
        this.javaName = javaName;
        this.lookup();
    }

    private void lookup() {
        TypeConstructor old;
        ClassType classType;
        try {
            classType = (ClassType)TypeImport.lookup(this.javaName);
        }
        catch (ClassCastException ex) {
            throw User.error((Located)this.definition, this.javaName + " is a primitive type");
        }
        if (classType == null) {
            if (!this.definition.inInterfaceFile()) {
                User.warning(this.javaName, this.javaName + " was not found in classpath so this retyping is ignored");
            }
            this.ignoredRetyping = true;
            return;
        }
        int nativeArity = classType.getArity();
        if (nativeArity != -1 && nativeArity != this.definition.tc.arity()) {
            User.error((Located)this.definition, this.javaName + " has " + nativeArity + " type parameters");
        }
        if ((old = JavaClasses.setTypeConstructorForJavaClass(this.definition.compilation(), this.definition.tc, classType)) != null) {
            User.error((Located)this.definition, this.javaName + " was already associated with the Nice class " + old);
        }
        this.definition.setJavaType(classType);
    }

    void resolveClass() {
        if (this.ignoredRetyping) {
            return;
        }
        JavaClasses.fetchMethods(this.definition.tc, (ClassType)this.definition.getJavaType());
    }

    public void printInterface(PrintWriter s) {
        s.print(" = native " + this.javaName.toString() + ";\n");
    }
}

