/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.Block;
import bossa.syntax.CallExp;
import bossa.syntax.Expression;
import bossa.syntax.IdentExp;
import bossa.syntax.LocatedString;
import bossa.syntax.Monotype;
import bossa.syntax.MonotypeConstructor;
import bossa.syntax.Statement;
import bossa.syntax.TypeIdent;
import bossa.syntax.TypeParameters;
import bossa.util.Location;
import gnu.expr.BlockExp;
import gnu.expr.LoopExp;
import gnu.expr.QuoteExp;
import java.util.ArrayList;
import java.util.LinkedList;

public class LoopStmt
extends Statement {
    LoopExp code;
    static BlockExp currentLoopBlock;
    private boolean mustCreateBlock = false;
    Expression whileExp;
    Statement loopBody;
    Statement iterationStatements;
    private boolean testFirst;

    public static LoopStmt forLoop(Expression test2, Statement update, Statement body) {
        return new LoopStmt(test2, body, update, true);
    }

    public static LoopStmt whileLoop(Expression test2, Statement body) {
        return new LoopStmt(test2, body, null, true);
    }

    public static LoopStmt doLoop(Expression test2, Statement body) {
        return new LoopStmt(test2, body, null, false);
    }

    public static Statement forInLoop(Monotype vartype, LocatedString var, Location loc, Expression container, Statement body) {
        MonotypeConstructor itertype = null;
        if (vartype != null) {
            ArrayList<Monotype> tparams = new ArrayList<Monotype>(1);
            tparams.add(vartype);
            itertype = new MonotypeConstructor(new TypeIdent(new LocatedString("Iterator", loc)), new TypeParameters(tparams), loc);
            itertype.nullness = (byte)2;
        }
        CallExp getiter = CallExp.create(new IdentExp(new LocatedString("forIterator", loc)), container);
        LocatedString iter = new LocatedString(loc.uniqueIdentifier("for_in_iter_"), loc);
        Block.LocalVariable init = new Block.LocalVariable(iter, itertype, true, getiter);
        IdentExp iterexp = new IdentExp(iter);
        CallExp cond = CallExp.create(new IdentExp(new LocatedString("hasNext", loc)), iterexp);
        CallExp getvar = CallExp.create(new IdentExp(new LocatedString("next", loc)), iterexp);
        Block.LocalVariable assign = new Block.LocalVariable(var, vartype, true, getvar);
        LinkedList<Statement> loopbody = new LinkedList<Statement>();
        loopbody.add(assign);
        loopbody.add(body);
        LoopStmt loop = LoopStmt.whileLoop(cond, new Block(loopbody));
        LinkedList<Statement> l = new LinkedList<Statement>();
        l.add(init);
        l.add(loop);
        return new Block(l);
    }

    private LoopStmt(Expression whileExp, Statement loopBody, Statement iterationStatements, boolean testFirst) {
        this.whileExp = whileExp;
        this.loopBody = loopBody;
        this.iterationStatements = iterationStatements;
        this.testFirst = testFirst;
    }

    boolean isTestFirst() {
        return this.testFirst;
    }

    void createBlock() {
        this.mustCreateBlock = true;
    }

    boolean isBreakTarget() {
        return this.mustCreateBlock;
    }

    boolean isInfinite() {
        return (this.whileExp == null || this.whileExp.isTrue()) && !this.isBreakTarget();
    }

    gnu.expr.Expression generateCode() {
        gnu.expr.Expression res;
        gnu.expr.Expression test2 = this.whileExp == null ? QuoteExp.trueExp : this.whileExp.generateCode();
        gnu.expr.Expression iteration = this.iterationStatements == null ? QuoteExp.voidExp : this.iterationStatements.generateCode();
        this.code = new LoopExp(test2, iteration, this.testFirst);
        BlockExp savedBlock = currentLoopBlock;
        if (this.mustCreateBlock) {
            currentLoopBlock = new BlockExp(this.code);
            res = currentLoopBlock;
        } else {
            res = this.code;
        }
        this.code.setBody(this.loopBody != null ? this.loopBody.generateCode() : null);
        this.code = null;
        currentLoopBlock = savedBlock;
        return res;
    }

    public String toString() {
        if (!this.testFirst) {
            return "do {\n" + (this.loopBody == null ? " " : this.loopBody.toString()) + "}\n while (" + this.whileExp + ");";
        }
        if (this.iterationStatements == null) {
            return "while (" + this.whileExp + ")" + (this.loopBody == null ? ";" : this.loopBody.toString());
        }
        Statement[] itStatements = ((Block)this.iterationStatements).statements;
        String itStats = "";
        for (int i = 0; i < itStatements.length; ++i) {
            String tmp = itStatements[i].toString();
            itStats = itStats + tmp.substring(0, tmp.lastIndexOf(59));
            if (i >= itStatements.length - 1) continue;
            itStats = itStats + ", ";
        }
        return "for(; " + this.whileExp + " ;" + itStats + ")\n " + (this.loopBody == null ? "" : this.loopBody.toString());
    }
}

