/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.AtomicConstraint;
import bossa.syntax.Definition;
import bossa.syntax.LocatedString;
import bossa.syntax.TypeScope;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import mlsub.typing.Monotype;
import mlsub.typing.MonotypeConstructor;
import mlsub.typing.MonotypeVar;
import mlsub.typing.TypeConstructor;
import mlsub.typing.TypeSymbol;
import mlsub.typing.Variance;
import nice.tools.typing.Types;

public abstract class MethodContainer
extends Definition {
    Variance variance;
    final Constraint classConstraint;
    mlsub.typing.AtomicConstraint[] resolvedConstraints;

    MethodContainer(LocatedString name, int propagate, Constraint classConstraint, List variance) {
        super(name, propagate);
        this.name.prepend(this.module.getName() + ".");
        this.variance = MethodContainer.makeVariance(variance);
        this.classConstraint = classConstraint;
    }

    String getSimpleName() {
        String name = this.getName().toString();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    abstract TypeSymbol getTypeSymbol();

    private static Variance makeVariance(List typeParametersVariances) {
        int[] variances = new int[typeParametersVariances.size()];
        int i = typeParametersVariances.size();
        while (--i >= 0) {
            if (typeParametersVariances.get(i) == null) continue;
            if (typeParametersVariances.get(i) == Boolean.TRUE) {
                variances[i] = 1;
                continue;
            }
            variances[i] = -1;
        }
        return Variance.make(variances);
    }

    void resolve() {
        if (this.classConstraint != null) {
            TypeScope scope = new TypeScope(this.typeScope);
            try {
                scope.addSymbols(this.classConstraint.getBinders());
            }
            catch (TypeScope.DuplicateName duplicateName) {
                // empty catch block
            }
            this.resolvedConstraints = AtomicConstraint.resolve(scope, this.classConstraint.getAtoms());
        }
    }

    public TypeSymbol[] getBinders() {
        if (this.classConstraint == null) {
            return null;
        }
        return this.classConstraint.getBinderArray();
    }

    public Monotype[] getTypeParameters() {
        if (this.classConstraint == null) {
            return null;
        }
        return this.classConstraint.typeParameters;
    }

    public mlsub.typing.Constraint getResolvedConstraint() {
        if (this.classConstraint == null) {
            return mlsub.typing.Constraint.True;
        }
        return new mlsub.typing.Constraint(this.classConstraint.getBinderArray(), this.resolvedConstraints);
    }

    public void printInterface(PrintWriter s) {
        if (this.classConstraint == null) {
            return;
        }
        s.print(this.classConstraint);
    }

    String printTypeParameters() {
        if (this.classConstraint == null) {
            return "";
        }
        Monotype[] typeParameters = this.classConstraint.typeParameters;
        StringBuffer res = new StringBuffer("<");
        for (int n = 0; n < typeParameters.length; ++n) {
            switch (this.variance.getVariance(n)) {
                case -1: {
                    res.append("-");
                    break;
                }
                case 1: {
                    res.append("+");
                }
            }
            res.append(typeParameters[n].toString());
            if (n + 1 >= typeParameters.length) continue;
            res.append(", ");
        }
        return res.append(">").toString();
    }

    public static class Constraint
    extends bossa.syntax.Constraint {
        Monotype[] typeParameters;

        public static Constraint make(bossa.syntax.Constraint cst, MonotypeVar[] typeParameters, List atoms) {
            boolean resolve;
            List constraints;
            TypeSymbol[] binders;
            if (cst == bossa.syntax.Constraint.True || cst == null) {
                binders = typeParameters;
                constraints = atoms;
                resolve = false;
            } else {
                constraints = cst.getAtoms();
                binders = cst.getBinderArray();
                resolve = true;
            }
            return new Constraint(binders, constraints, typeParameters, resolve);
        }

        private Constraint(TypeSymbol[] binders, List atoms, MonotypeVar[] typeParameters, boolean resolve) {
            super(binders, atoms);
            if (resolve) {
                this.findBinders(typeParameters);
            } else {
                this.typeParameters = typeParameters;
            }
            for (int i = 0; i < typeParameters.length; ++i) {
                Types.makeMarkedType(typeParameters[i]);
            }
        }

        private void findBinders(MonotypeVar[] typeParameters) {
            this.typeParameters = new Monotype[typeParameters.length];
            for (int i = 0; i < typeParameters.length; ++i) {
                this.typeParameters[i] = this.findBinder(typeParameters[i]);
            }
        }

        private Monotype findBinder(MonotypeVar binder) {
            Iterator i = this.getBinders().iterator();
            while (i.hasNext()) {
                TypeSymbol s = (TypeSymbol)i.next();
                if (!s.toString().equals(binder.getName())) continue;
                if (s instanceof MonotypeVar) {
                    return (MonotypeVar)s;
                }
                return new MonotypeConstructor((TypeConstructor)s, null);
            }
            return binder;
        }
    }
}

