/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.Arguments;
import bossa.syntax.LocatedString;
import bossa.syntax.Monotype;
import bossa.syntax.VarSymbol;
import bossa.util.Located;
import bossa.util.User;
import bossa.util.Util;
import mlsub.typing.FunTypeKind;
import mlsub.typing.Polytype;
import mlsub.typing.lowlevel.Kind;
import nice.tools.typing.Types;

public class MonoSymbol
extends VarSymbol {
    boolean captured = false;
    int depth;
    boolean used = false;
    Monotype syntacticType;
    mlsub.typing.Monotype type;

    public MonoSymbol(LocatedString name, Monotype type) {
        super(name);
        this.syntacticType = type;
    }

    public MonoSymbol(LocatedString name, mlsub.typing.Monotype type) {
        super(name);
        this.type = type;
    }

    public Polytype getType() {
        return new Polytype(this.type);
    }

    public mlsub.typing.Monotype getMonotype() {
        return this.type;
    }

    static mlsub.typing.Monotype[] getMonotype(MonoSymbol[] symbols) {
        if (symbols == null) {
            return null;
        }
        mlsub.typing.Monotype[] res = new mlsub.typing.Monotype[symbols.length];
        for (int i = 0; i < symbols.length; ++i) {
            res[i] = symbols[i].getMonotype();
        }
        return res;
    }

    static Monotype[] getSyntacticMonotype(MonoSymbol[] symbols) {
        if (symbols == null) {
            return Monotype.array0;
        }
        Monotype[] res = new Monotype[symbols.length];
        for (int i = 0; i < symbols.length; ++i) {
            res[i] = symbols[i].syntacticType;
        }
        return res;
    }

    void resolve() {
        this.type = this.syntacticType.resolve(this.typeScope);
        this.syntacticType = null;
        if (Types.isVoid(this.type)) {
            throw User.error((Located)this.name, "A variable cannot have a void type");
        }
    }

    int match(Arguments arguments) {
        Kind k = Types.rawType(this.type).getKind();
        if (k instanceof FunTypeKind) {
            if (!arguments.plainApplication(((FunTypeKind)k).domainArity, this)) {
                return 0;
            }
            return 2;
        }
        return 1;
    }

    String explainWhyMatchFails(Arguments arguments) {
        Kind k = Types.rawType(this.type).getKind();
        if (k instanceof FunTypeKind) {
            int arity = ((FunTypeKind)k).domainArity;
            if (arguments.size() != arity) {
                return this.name + Util.has(arity, "parameter", arguments.size());
            }
            return this.name + " does not have named parameters";
        }
        return this.name + " is not a function";
    }

    final void makeClonedType() {
    }

    final void releaseClonedType() {
    }

    final Polytype getClonedType() {
        return this.getType();
    }

    public String toString() {
        return this.type + " " + this.name;
    }
}

