/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.Monotype;
import bossa.syntax.TypeIdent;
import bossa.syntax.TypeMap;
import bossa.syntax.TypeParameters;
import bossa.util.Located;
import bossa.util.Location;
import bossa.util.User;
import bossa.util.Util;
import java.util.Map;
import mlsub.typing.BadSizeEx;
import mlsub.typing.TypeConstructor;

public class MonotypeConstructor
extends Monotype {
    public TypeIdent tc;
    private TypeConstructor lowlevelTC;
    TypeParameters parameters;
    Location loc;

    public MonotypeConstructor(TypeIdent tc, TypeParameters parameters, Location loc) {
        this.tc = tc;
        this.parameters = parameters == null ? new TypeParameters((Monotype[])null) : parameters;
        this.loc = loc;
    }

    MonotypeConstructor(TypeConstructor tc, TypeParameters parameters, Location loc) {
        this.lowlevelTC = tc;
        this.parameters = parameters;
        this.loc = loc;
    }

    Monotype cloneType() {
        return new MonotypeConstructor(this.tc, this.parameters, this.loc);
    }

    mlsub.typing.Monotype rawResolve(TypeMap typeMap) {
        if (this.lowlevelTC == null) {
            TypeConstructor newTC = this.tc.resolveToTC(typeMap);
            if (!(newTC instanceof TypeConstructor)) {
                User.error((Located)this.tc, this.tc + " should be a type constructor");
            }
            this.lowlevelTC = newTC;
        }
        try {
            mlsub.typing.MonotypeConstructor type = new mlsub.typing.MonotypeConstructor(this.lowlevelTC, this.parameters.resolve(typeMap));
            return type;
        }
        catch (BadSizeEx e) {
            throw User.error((Located)this, (this.tc != null ? "Class " + this.tc : this.lowlevelTC.toString()) + Util.has(e.expected, "type parameter", e.actual));
        }
    }

    Monotype substitute(Map map2) {
        TypeIdent newTC = (TypeIdent)map2.get(this.tc);
        if (newTC == null) {
            newTC = this.tc;
        }
        MonotypeConstructor res = new MonotypeConstructor(newTC, new TypeParameters(Monotype.substitute(map2, this.parameters.content)), this.loc);
        res.nullness = this.nullness;
        return res;
    }

    boolean containsAlike() {
        return Monotype.containsAlike(this.parameters.content);
    }

    public TypeIdent getTC() {
        return this.tc;
    }

    public TypeParameters getTP() {
        return this.parameters;
    }

    public Location location() {
        if (this.loc == null) {
            return this.tc.location();
        }
        return this.loc;
    }

    public String toString() {
        return this.nullnessString() + (this.lowlevelTC != null ? this.lowlevelTC.toString() : this.tc.toString()) + this.parameters;
    }
}

