/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.ConstantExp;
import bossa.syntax.LocatedString;
import bossa.util.Location;

public class StringConstantExp
extends ConstantExp {
    private static LocatedString stringName = new LocatedString("java.lang.String", Location.nowhere());
    String escapedValue;

    public StringConstantExp(String value) {
        this(value, false);
    }

    public StringConstantExp(String value, boolean multiline) {
        this.className = stringName;
        if (multiline) {
            value = StringConstantExp.escapeEOL(value);
        }
        this.escapedValue = value;
        this.value = StringConstantExp.unescape(value);
    }

    public static String unescape(String s) {
        StringBuffer sb = new StringBuffer();
        int n = s.length();
        block10: for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                char c2 = s.charAt(++i);
                switch (c2) {
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        break;
                    }
                    case '\'': {
                        sb.append('\'');
                        break;
                    }
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    default: {
                        char c3;
                        if (c2 < '0') continue block10;
                        if (c2 > '7') break;
                        int code = c2 - 48;
                        if (i + 1 < n && (c3 = s.charAt(i + 1)) >= '0' && c3 <= '7') {
                            char c4;
                            code = 8 * code + (c3 - 48);
                            if (c2 >= '0' && c2 <= '3' && ++i + 1 < n && (c4 = s.charAt(i + 1)) >= '0' && c4 <= '7') {
                                code = 8 * code + (c4 - 48);
                                ++i;
                            }
                        }
                        sb.append((char)code);
                        break;
                    }
                }
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static String escapeEOL(String s) {
        StringBuffer sb = new StringBuffer();
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\r') {
                sb.append("\\n");
                if (s.charAt(i + 1) != '\n') continue;
                ++i;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public String toString() {
        return "\"" + this.escapedValue + "\"";
    }
}

