/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.Expression;
import bossa.syntax.FieldAccess;
import bossa.syntax.LocatedString;
import bossa.syntax.VarSymbol;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.Location;
import bossa.util.User;
import gnu.expr.Declaration;

public class SymbolExp
extends Expression {
    private VarSymbol symbol;

    SymbolExp(VarSymbol symbol, Location loc) {
        this.symbol = symbol;
        this.setLocation(loc);
    }

    public boolean isAssignable() {
        return this.symbol.isAssignable();
    }

    FieldAccess getFieldAccessMethod() {
        return this.symbol.getFieldAccessMethod();
    }

    void checkSpecialRequirements(Expression[] arguments) {
        this.symbol.checkSpecialRequirements(arguments);
    }

    void computeType() {
        this.type = this.symbol.getType().cloneType();
    }

    public gnu.expr.Expression compile() {
        try {
            return this.symbol.compile();
        }
        catch (FieldAccess.UsingAsValue e) {
            throw User.error((Located)this, "You must supply the object that contains this field");
        }
    }

    gnu.expr.Expression generateCodeInCallPosition() {
        try {
            gnu.expr.Expression res = this.symbol.compileInCallPosition();
            this.location().write(res);
            return res;
        }
        catch (FieldAccess.UsingAsValue e) {
            throw User.error((Located)this, "You must supply the object that contains this field");
        }
    }

    Declaration getDeclaration() {
        Declaration decl = this.symbol.getDeclaration();
        if (decl == null) {
            Internal.error(this + " has no bytecode declaration");
        }
        return decl;
    }

    public LocatedString getName() {
        return this.symbol.name;
    }

    public String toString() {
        return this.symbol.name.toQuotedString();
    }

    VarSymbol getSymbol() {
        return this.symbol;
    }
}

