/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.LocatedString;
import bossa.syntax.MonoSymbol;
import bossa.syntax.MonotypeConstructor;
import bossa.syntax.PrimitiveType;
import bossa.syntax.Statement;
import bossa.syntax.TypeIdent;
import bossa.util.Located;
import bossa.util.Location;
import bossa.util.User;
import gnu.bytecode.ClassType;
import gnu.expr.CatchClause;
import gnu.expr.Expression;
import gnu.expr.TryExp;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mlsub.typing.TypeConstructor;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;
import nice.tools.code.Types;

public class TryStmt
extends Statement {
    Statement body;
    Statement finallyBody;
    List catches = new LinkedList();

    public TryStmt(Statement body) {
        this.body = body;
    }

    public void setFinally(Statement body) {
        this.finallyBody = body;
    }

    public void addCatch(TypeIdent tc, LocatedString var, Statement body) {
        this.catches.add(new Catch(tc, var, body));
    }

    public Expression generateCode() {
        TryExp res = new TryExp(this.body.generateCode(), this.finallyBody == null ? null : this.finallyBody.generateCode());
        CatchClause oldc = null;
        Iterator i = this.catches.iterator();
        while (i.hasNext()) {
            Catch c = (Catch)i.next();
            CatchClause newc = c.clause();
            if (oldc != null) {
                oldc.setNext(newc);
            } else {
                res.setCatchClauses(newc);
            }
            oldc = newc;
        }
        return res;
    }

    public String toString() {
        String res = "try\n" + this.body;
        Iterator i = this.catches.iterator();
        while (i.hasNext()) {
            Catch c = (Catch)i.next();
            res = res + "catch (" + c.t + " " + c.var + ")\n" + c.body;
        }
        if (this.finallyBody != null) {
            res = res + "finally " + this.finallyBody;
        }
        return res;
    }

    public class Catch {
        MonoSymbol exnVar;
        TypeIdent tc;
        TypeConstructor t;
        private LocatedString var;
        Statement body;
        private Location typeLocation;

        Catch(TypeIdent tc, LocatedString var, Statement body) {
            MonotypeConstructor type = new MonotypeConstructor(tc, null, tc.location());
            type.nullness = (byte)2;
            this.exnVar = new MonoSymbol(var, type);
            this.tc = tc;
            this.typeLocation = tc.location();
            this.var = var;
            this.body = body;
        }

        CatchClause clause() {
            try {
                Typing.leq(this.t, PrimitiveType.throwableTC());
            }
            catch (TypingEx e) {
                User.error((Located)this.typeLocation, this.t + " is not catchable");
            }
            CatchClause res = new CatchClause(this.var.toString(), (ClassType)Types.javaType(this.t));
            this.exnVar.setDeclaration(res.getDeclaration());
            res.setBody(this.body.generateCode());
            return res;
        }
    }
}

