/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.ClassDefinition;
import bossa.syntax.LocatedString;
import bossa.syntax.Monotype;
import bossa.syntax.TypeMap;
import bossa.syntax.dispatch;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.Location;
import bossa.util.User;
import bossa.util.Util;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mlsub.typing.BadSizeEx;
import mlsub.typing.Interface;
import mlsub.typing.MonotypeConstructor;
import mlsub.typing.TypeConstructor;
import mlsub.typing.TypeSymbol;

public final class TypeIdent
extends Monotype
implements Located {
    public LocatedString name;

    public TypeIdent(LocatedString name) {
        this.name = name;
    }

    public TypeIdent cloneTypeIdent() {
        return new TypeIdent(this.name);
    }

    boolean containsAlike() {
        return false;
    }

    public boolean isVoid() {
        return "void".equals(this.getName().toString());
    }

    Monotype substitute(Map map2) {
        Monotype res = (Monotype)map2.get(this.name.toString());
        if (res != null) {
            return res;
        }
        return this;
    }

    public final TypeSymbol resolveToTypeSymbol(TypeMap scope) {
        TypeSymbol res = scope.lookup(this.name);
        if (res == null) {
            throw dispatch.unknownIdent(this.name);
        }
        return res;
    }

    mlsub.typing.Monotype rawResolve(TypeMap scope) {
        TypeSymbol res = this.resolveToTypeSymbol(scope);
        if (res instanceof mlsub.typing.Monotype) {
            return (mlsub.typing.Monotype)((Object)res);
        }
        if (res instanceof TypeConstructor) {
            TypeConstructor tc = (TypeConstructor)res;
            try {
                return new MonotypeConstructor(tc, null);
            }
            catch (BadSizeEx e) {
                throw User.error((Located)this, this.name + Util.has(e.expected, "type parameter", e.actual));
            }
        }
        if (res instanceof Interface) {
            User.error((Located)this, "This abstract interface cannot be used as a type");
        }
        Internal.error("Invalid type ident: " + res.getClass() + " = " + res);
        return null;
    }

    public TypeConstructor resolveToTC(TypeMap scope) {
        TypeSymbol res = this.resolveToTypeSymbol(scope);
        if (res instanceof TypeConstructor) {
            return (TypeConstructor)res;
        }
        throw User.error((Located)this, this + " is not a class");
    }

    public TypeSymbol resolvePreferablyToItf(TypeMap scope) {
        Interface itf;
        ClassDefinition def;
        TypeSymbol res = this.resolveToTypeSymbol(scope);
        if (res instanceof Interface) {
            return (Interface)res;
        }
        if (res instanceof TypeConstructor && (def = ClassDefinition.get((TypeConstructor)res)) != null && (itf = def.getAssociatedInterface()) != null) {
            return itf;
        }
        return res;
    }

    public Interface resolveToItf(TypeMap scope) {
        Interface itf;
        ClassDefinition def;
        TypeSymbol res = this.resolveToTypeSymbol(scope);
        if (res instanceof Interface) {
            return (Interface)res;
        }
        if (res instanceof TypeConstructor && (def = ClassDefinition.get((TypeConstructor)res)) != null && (itf = def.getAssociatedInterface()) != null) {
            return itf;
        }
        throw User.error((Located)this, res + " should be an interface");
    }

    public static Interface[] resolveToItf(TypeMap scope, List idents) {
        if (idents == null || idents.size() == 0) {
            return null;
        }
        Interface[] res = new Interface[idents.size()];
        int n = 0;
        Iterator i = idents.iterator();
        while (i.hasNext()) {
            res[n++] = ((TypeIdent)i.next()).resolveToItf(scope);
        }
        return res;
    }

    public String toString() {
        return this.nullnessString() + this.name.toString();
    }

    public LocatedString getName() {
        return this.name;
    }

    public boolean hasName(LocatedString name) {
        return this.name.equals(name);
    }

    public Location location() {
        return this.name.location();
    }
}

