/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.Constraint;
import bossa.syntax.Contract;
import bossa.syntax.FormalParameters;
import bossa.syntax.LocatedString;
import bossa.syntax.MethodDeclaration;
import bossa.syntax.MonoSymbol;
import bossa.syntax.Monotype;
import bossa.syntax.TypeScope;
import bossa.syntax.VarScope;
import bossa.util.Located;
import bossa.util.User;
import mlsub.typing.FunType;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;
import nice.tools.code.Types;

abstract class UserOperator
extends MethodDeclaration {
    private Contract contract;
    private boolean resolved = false;
    private MonoSymbol[] symbols;

    UserOperator(LocatedString name, Constraint constraint, Monotype returnType, FormalParameters parameters, Contract contract) {
        super(name, constraint, returnType, parameters);
        this.contract = contract;
    }

    public Contract getContract() {
        return this.contract;
    }

    void doResolve() {
        if (this.resolved) {
            return;
        }
        this.resolved = true;
        this.removeChild(this.getSymbol());
        this.getSymbol().doResolve();
        this.symbols = this.parameters.getMonoSymbols();
        if (this.symbols != null) {
            mlsub.typing.Monotype[] paramTypes = this.getArgTypes();
            for (int i = 0; i < this.symbols.length; ++i) {
                if (nice.tools.typing.Types.isVoid(paramTypes[i])) {
                    throw User.error((Located)this.symbols[i].syntacticType, "A parameter cannot have a void type");
                }
                if (this.symbols[i].name == null) continue;
                this.symbols[i].type = paramTypes[i];
                this.scope.addSymbol(this.symbols[i]);
            }
        }
        VarScope scope = this.scope;
        TypeScope typeScope = this.typeScope;
        super.doResolve();
        this.contract.resolve(scope, typeScope, this.getReturnType(), this.location());
    }

    void resolve() {
        super.resolve();
        mlsub.typing.Constraint cst = this.getType().getConstraint();
        if (mlsub.typing.Constraint.hasBinders(cst)) {
            try {
                this.typeScope.addSymbols(cst.binders());
            }
            catch (TypeScope.DuplicateName ex) {
                User.error((Located)this, "Double declaration of the same type parameter");
            }
        }
    }

    public String toString() {
        return super.toString() + String.valueOf(this.contract);
    }

    public MonoSymbol[] getSymbols() {
        return this.symbols;
    }

    void innerTypecheck() throws TypingEx {
        Typing.implies();
        this.contract.typecheck();
        FunType ft = (FunType)this.getType().getMonotype();
        Types.setBytecodeType(ft.domain());
        Types.setBytecodeType(ft.codomain());
    }

    void typecheckCompiled() {
        if (this.contract != Contract.noContract) {
            this.typecheck();
        }
    }
}

