/*
 * Decompiled with CFR 0.152.
 */
package bossa.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import mlsub.typing.Enumeration;
import mlsub.typing.Polytype;
import mlsub.typing.Typing;
import mlsub.typing.lowlevel.Engine;
import mlsub.typing.lowlevel.K0;

public abstract class Debug {
    private static final Properties props = new Properties();
    public static final boolean resolution;
    public static final boolean K0;
    public static final boolean typing;
    public static final boolean engine;
    public static final boolean modules;
    public static final boolean IDs;
    public static final boolean overloading;
    public static final boolean powerUser;
    public static final boolean bytecodeAttributes;
    public static final boolean codeGeneration;
    public static final boolean javaTypes;
    public static final boolean linkTests;
    public static final boolean passes;
    public static final boolean alwaysDumpStack;
    public static final boolean ignorePrelude;
    public static final String defaultFile;

    public static void println(String msg) {
        System.out.println(msg);
    }

    public static void print(String msg) {
        System.out.print(msg);
    }

    public static boolean getBoolean(String name, boolean defaultValue) {
        String value = props.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return value.equals("true");
    }

    public static String getProperty(String name, String def) {
        String res = props.getProperty(name, null);
        if (res == null) {
            res = System.getProperty(name, def);
        }
        return res;
    }

    static {
        try {
            File f = new File(System.getProperty("user.home"), ".nice.conf");
            FileInputStream in = new FileInputStream(f);
            props.load(new BufferedInputStream(in));
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        resolution = Debug.getBoolean("debug.resolution", false);
        K0 = Debug.getBoolean("debug.K0", false);
        typing = Debug.getBoolean("debug.typing", false);
        engine = Debug.getBoolean("debug.engine", false);
        modules = Debug.getBoolean("debug.modules", false);
        IDs = Debug.getBoolean("debug.IDs", false);
        overloading = Debug.getBoolean("debug.overloading", false);
        powerUser = Debug.getBoolean("debug.powerUser", false);
        bytecodeAttributes = Debug.getBoolean("debug.bytecodeAttributes", false);
        codeGeneration = Debug.getBoolean("debug.codeGeneration", false);
        javaTypes = Debug.getBoolean("debug.javaTypes", false);
        linkTests = Debug.getBoolean("debug.linkTests", false);
        passes = Debug.getBoolean("debug.passes", false);
        alwaysDumpStack = Debug.getBoolean("debug.alwaysDumpStack", false);
        ignorePrelude = Debug.getBoolean("debug.ignorePrelude", false);
        mlsub.typing.lowlevel.K0.debugK0 = K0;
        Engine.dbg = engine;
        Typing.dbg = typing;
        Enumeration.linkDbg = linkTests;
        Polytype.noSimplify = Debug.getBoolean("debug.noSimplify", false);
        defaultFile = props.getProperty("debug.defaultFile", null);
    }
}

