/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.PrimType;
import gnu.bytecode.Scope;
import gnu.bytecode.SwitchState;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ChainLambdas;
import gnu.expr.CheckedTarget;
import gnu.expr.ClassExp;
import gnu.expr.ConditionalTarget;
import gnu.expr.ConsumerTarget;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.FindCapturedVars;
import gnu.expr.FindTailCalls;
import gnu.expr.IgnoreTarget;
import gnu.expr.Initializer;
import gnu.expr.InlineCalls;
import gnu.expr.Interpreter;
import gnu.expr.LambdaExp;
import gnu.expr.LitTable;
import gnu.expr.Literal;
import gnu.expr.ModuleExp;
import gnu.expr.Package;
import gnu.expr.PushApply;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.expr.Undefined;
import gnu.lists.LList;
import gnu.lists.Sequence;
import gnu.mapping.OutPort;
import gnu.mapping.Values;
import gnu.text.SourceError;
import java.util.Hashtable;

public class Compilation {
    int maxSelectorValue;
    public ClassType curClass;
    public ClassType mainClass;
    public LambdaExp curLambda;
    public ModuleExp mainLambda;
    public Variable thisDecl;
    Field instanceField;
    public static boolean fewerClasses;
    public static boolean debugPrintFinalExpr;
    public static boolean usingCPStyle;
    public static boolean usingTailCalls;
    public static int moduleStatic;
    ClassType[] classes;
    int numClasses;
    boolean immediate;
    public Method method;
    int method_counter;
    SwitchState fswitch;
    Field fswitchIndex;
    Variable callStackContext;
    public static ClassType typeObject;
    public static ClassType scmBooleanType;
    public static ClassType typeString;
    public static ClassType javaStringType;
    public static ClassType scmSymbolType;
    public static ClassType scmKeywordType;
    public static ClassType scmSequenceType;
    public static ClassType javaIntegerType;
    public static ClassType scmListType;
    public static ClassType typePair;
    public static ClassType scmPairType;
    public static ClassType scmUndefinedType;
    public static final ArrayType objArrayType;
    public static final ArrayType symbolArrayType;
    public static ClassType scmNamedType;
    public static ClassType typeRunnable;
    public static ClassType typeObjectType;
    public static ClassType typeClassType;
    public static ClassType typeProcedure;
    public static ClassType typeInterpreter;
    public static ClassType typeMacro;
    public static ClassType typeEnvironment;
    public static ClassType typeLocation;
    public static ClassType typeBinding;
    public static final Method getLocationMethod;
    public static final Method getProcedureBindingMethod;
    public static final Field trueConstant;
    public static final Field falseConstant;
    static final Field voidConstant;
    static final Field undefinedConstant;
    static final Field emptyConstant;
    static final Field eofConstant;
    static final Method setNameMethod;
    static Method initIntegerMethod;
    static Method lookupGlobalMethod;
    static Method defineGlobalMethod;
    static Method defineFunctionMethod;
    static Method putGlobalMethod;
    static Method makeListMethod;
    public static final Type[] int1Args;
    public static final Type[] string1Arg;
    public static final Type[] sym1Arg;
    public static final Method getBindingEnvironmentMethod;
    public static Method getCurrentEnvironmentMethod;
    public static Type[] apply0args;
    public static Type[] apply1args;
    public static Type[] apply2args;
    public static Type[] applyNargs;
    static Method checkArgCountMethod;
    public static Method apply0method;
    public static Method apply1method;
    public static Method apply2method;
    public static Method apply3method;
    public static Method apply4method;
    public static Method applyNmethod;
    public static Method[] applymethods;
    public static ClassType typeProcedure0;
    public static ClassType typeProcedure1;
    public static ClassType typeProcedure2;
    public static ClassType typeProcedure3;
    public static ClassType typeProcedure4;
    public static ClassType typeProcedureN;
    public static ClassType typeModuleBody;
    public static ClassType typeApplet;
    public static ClassType typeServlet;
    public static ClassType typeModuleMethod;
    public static ClassType typeApplyMethodProc;
    public static ClassType typeApplyMethodContainer;
    public static ClassType typeCallContext;
    public static final ClassType typeConsumer;
    public static Method popCallContextMethod;
    public static ClassType typeValues;
    public static Field noArgsField;
    public static Field pcCallContextField;
    public static ClassType typeCpsProcedure;
    public static ClassType typeCallFrame;
    public static ClassType typeCpsMethodProc;
    public static ClassType typeCpsMethodContainer;
    public static Field numArgsCallFrameField;
    public static Field argsCallContextField;
    public static Field procCallContextField;
    public static Field callerCallFrameField;
    public static Field saved_pcCallFrameField;
    private static Type[] applyCpsArgs;
    public static Method applyCpsMethod;
    public static ClassType[] typeProcedureArray;
    Hashtable literalTable;
    int literalsCount;
    Initializer clinitChain;
    Literal literalsChain;
    public static boolean generateMainDefault;
    public boolean generateMain = generateMainDefault;
    LitTable litTable;
    public static boolean generateAppletDefault;
    public boolean generateApplet = generateAppletDefault;
    public static boolean generateServletDefault;
    public boolean generateServlet = generateServletDefault;
    public String classPrefix;
    String source_filename;
    int localFieldIndex;
    String filename;
    int position;
    Package currentPackage;
    public LambdaExp topLambda;
    ClassType topClass;

    public final CodeAttr getCode() {
        return this.method.getCode();
    }

    public static final ClassType getMethodProcType(ClassType modClass) {
        return usingTailCalls ? typeCpsMethodProc : typeModuleMethod;
    }

    public final ClassType getModuleSuperType(ModuleExp module) {
        ClassType sup = module.getSuperType();
        return sup != null ? sup : (Compilation.usingCPStyle() ? typeCallFrame : (this.generateApplet ? typeApplet : (this.generateServlet ? typeServlet : typeModuleBody)));
    }

    public Interpreter getInterpreter() {
        return Interpreter.defaultInterpreter;
    }

    public Literal findLiteral(Object value) {
        if (value == null) {
            return Literal.nullLiteral;
        }
        Literal literal = (Literal)this.literalTable.get(value);
        if (literal == null) {
            if (value instanceof Boolean) {
                boolean val = (Boolean)value;
                literal = new Literal(value, val ? trueConstant : falseConstant, this);
            } else if (value == Values.empty) {
                literal = new Literal(value, voidConstant, this);
            } else if (value == LList.Empty) {
                literal = new Literal(value, emptyConstant, this);
            } else if (value == Sequence.eofValue) {
                literal = new Literal(value, eofConstant, this);
            } else if (value instanceof Undefined) {
                literal = new Literal(value, undefinedConstant, this);
            } else if (this.immediate) {
                literal = new Literal(value, this);
            } else {
                Type literalType = Type.make(value.getClass());
                if (literalType == Type.byte_ctype || literalType == Type.short_ctype) {
                    literalType = Type.int_ctype;
                }
                literal = new Literal(value, literalType, this);
            }
        }
        return literal;
    }

    public void compileConstant(Object value) {
        CodeAttr code = this.getCode();
        if (value == null) {
            code.emitPushNull();
        } else if (value instanceof String && !this.immediate) {
            code.emitPushString((String)value);
        } else {
            Literal literal = this.findLiteral(value);
            if (literal.field == null) {
                literal.assign(this);
            }
            code.emitGetStatic(literal.field);
        }
    }

    public void compileConstant(Object value, Target target) {
        if (target instanceof IgnoreTarget) {
            return;
        }
        if (target instanceof ConsumerTarget && value == Values.empty) {
            return;
        }
        if (target instanceof ConditionalTarget) {
            ConditionalTarget ctarg = (ConditionalTarget)target;
            this.getCode().emitGoto(this.getInterpreter().isTrue(value) ? ctarg.ifTrue : ctarg.ifFalse);
            return;
        }
        if (target instanceof StackTarget) {
            if (value == null) {
                this.getCode().emitPushNull();
                return;
            }
            Type type = ((StackTarget)target).getType();
            if (type instanceof PrimType) {
                try {
                    int sig1;
                    String signature = type.getSignature();
                    CodeAttr code = this.getCode();
                    int n = sig1 = signature == null || signature.length() != 1 ? 32 : (int)signature.charAt(0);
                    if (value instanceof Number) {
                        Number num = (Number)value;
                        switch (sig1) {
                            case 67: 
                            case 73: {
                                code.emitPushInt(num.intValue());
                                return;
                            }
                            case 83: {
                                code.emitPushInt(num.shortValue());
                                return;
                            }
                            case 66: {
                                code.emitPushInt(num.byteValue());
                                return;
                            }
                            case 74: {
                                code.emitPushLong(num.longValue());
                                return;
                            }
                            case 70: {
                                code.emitPushFloat(num.floatValue());
                                return;
                            }
                            case 68: {
                                code.emitPushDouble(num.doubleValue());
                                return;
                            }
                        }
                    } else if (value instanceof Character) {
                        if (sig1 == 67 || sig1 == 73 || sig1 == 74) {
                            code.emitPushInt(((Character)value).charValue());
                            return;
                        }
                        if (sig1 == 70) {
                            code.emitPushFloat(((Character)value).charValue());
                            return;
                        }
                        if (sig1 == 68) {
                            code.emitPushDouble(((Character)value).charValue());
                            return;
                        }
                    }
                    if (sig1 == 67) {
                        code.emitPushInt(((PrimType)type).charValue(value));
                        return;
                    }
                    if (sig1 == 90) {
                        PrimType cfr_ignored_0 = (PrimType)type;
                        boolean val = PrimType.booleanValue(value);
                        code.emitPushBoolean(val);
                        return;
                    }
                    if (sig1 == 86 && value == Values.empty) {
                        return;
                    }
                }
                catch (ClassCastException ex) {
                    // empty catch block
                }
            }
            try {
                value = type.coerceFromObject(value);
            }
            catch (Exception ex) {
                this.error('w', "cannot convert literal (of type " + value.getClass().getName() + ") to " + type.getName());
            }
        }
        this.compileConstant(value);
        target.compileFromStack(this, value == null ? target.getType() : Type.make(value.getClass()));
    }

    void dumpInitializers(Initializer inits, Method initMethod) {
        Method save = this.method;
        this.method = initMethod;
        this.dumpInitializers(inits);
        this.method = save;
    }

    private void dumpInitializers(Initializer inits) {
        Initializer init = Initializer.reverse(inits);
        while (init != null) {
            init.emit(this);
            init = init.next;
        }
    }

    public ClassType findNamedClass(String name) {
        for (int i = 0; i < this.numClasses; ++i) {
            if (!name.equals(this.classes[i].getName())) continue;
            return this.classes[i];
        }
        return null;
    }

    public static String mangleName(String name) {
        return Compilation.mangleName(name, false);
    }

    public static String mangleNameIfNeeded(String name) {
        if (Compilation.isValidJavaName(name)) {
            return name;
        }
        return Compilation.mangleName(name, true);
    }

    public static boolean isValidJavaName(String name) {
        int len = name.length();
        if (len == 0 || !Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        int i = len;
        while (--i > 0) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String mangleName(String name, boolean reversible) {
        int len = name.length();
        StringBuffer mangled = new StringBuffer(len);
        boolean upcaseNext = false;
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (upcaseNext) {
                ch = Character.toTitleCase(ch);
                upcaseNext = false;
            }
            if (Character.isDigit(ch)) {
                if (i == 0) {
                    mangled.append("$N");
                }
                mangled.append(ch);
                continue;
            }
            if (Character.isLetter(ch) || ch == '_') {
                mangled.append(ch);
                continue;
            }
            if (ch == '$') {
                mangled.append(reversible ? "$$" : "$");
                continue;
            }
            switch (ch) {
                case '+': {
                    mangled.append("$Pl");
                    break;
                }
                case '-': {
                    char next;
                    if (reversible) {
                        mangled.append("$Mn");
                        break;
                    }
                    char c = next = i + 1 < len ? name.charAt(i + 1) : (char)'\u0000';
                    if (next == '>') {
                        mangled.append("$To$");
                        ++i;
                        break;
                    }
                    if (Character.isLowerCase(next)) break;
                    mangled.append("$Mn");
                    break;
                }
                case '*': {
                    mangled.append("$St");
                    break;
                }
                case '/': {
                    mangled.append("$Sl");
                    break;
                }
                case '=': {
                    mangled.append("$Eq");
                    break;
                }
                case '<': {
                    mangled.append("$Ls");
                    break;
                }
                case '>': {
                    mangled.append("$Gr");
                    break;
                }
                case '@': {
                    mangled.append("$At");
                    break;
                }
                case '~': {
                    mangled.append("$Tl");
                    break;
                }
                case '%': {
                    mangled.append("$Pc");
                    break;
                }
                case '.': {
                    mangled.append("$Dt");
                    break;
                }
                case ',': {
                    mangled.append("$Cm");
                    break;
                }
                case '(': {
                    mangled.append("$LP");
                    break;
                }
                case ')': {
                    mangled.append("$RP");
                    break;
                }
                case '[': {
                    mangled.append("$LB");
                    break;
                }
                case ']': {
                    mangled.append("$RB");
                    break;
                }
                case '{': {
                    mangled.append("$LC");
                    break;
                }
                case '}': {
                    mangled.append("$RC");
                    break;
                }
                case '\'': {
                    mangled.append("$Sq");
                    break;
                }
                case '\"': {
                    mangled.append("$Dq");
                    break;
                }
                case '&': {
                    mangled.append("$Am");
                    break;
                }
                case '#': {
                    mangled.append("$Nm");
                    break;
                }
                case '?': {
                    char first;
                    char c = first = mangled.length() > 0 ? mangled.charAt(0) : (char)'\u0000';
                    if (!reversible && i + 1 == len && Character.isLowerCase(first)) {
                        mangled.setCharAt(0, Character.toTitleCase(first));
                        mangled.insert(0, "is");
                        break;
                    }
                    mangled.append("$Qu");
                    break;
                }
                case '!': {
                    mangled.append("$Ex");
                    break;
                }
                case ':': {
                    mangled.append("$Cl");
                    break;
                }
                case ';': {
                    mangled.append("$SC");
                    break;
                }
                case '^': {
                    mangled.append("$Up");
                    break;
                }
                case '|': {
                    mangled.append("$VB");
                    break;
                }
                default: {
                    mangled.append('$');
                    mangled.append(Character.forDigit(ch >> 12 & 0xF, 16));
                    mangled.append(Character.forDigit(ch >> 8 & 0xF, 16));
                    mangled.append(Character.forDigit(ch >> 4 & 0xF, 16));
                    mangled.append(Character.forDigit(ch & 0xF, 16));
                }
            }
            if (reversible) continue;
            upcaseNext = true;
        }
        String mname = mangled.toString();
        return mname.equals(name) ? name : mname;
    }

    public static char demangle2(char char1, char char2) {
        switch (char1 << 16 | char2) {
            case 4259949: {
                return '&';
            }
            case 4259956: {
                return '@';
            }
            case 4391020: {
                return ':';
            }
            case 4391021: {
                return ',';
            }
            case 4456561: {
                return '\"';
            }
            case 0x440074: {
                return '.';
            }
            case 4522097: {
                return '=';
            }
            case 4522104: {
                return '!';
            }
            case 4653170: {
                return '>';
            }
            case 4980802: {
                return '[';
            }
            case 4980803: {
                return '{';
            }
            case 4980816: {
                return '(';
            }
            case 4980851: {
                return '<';
            }
            case 5046371: {
                return '%';
            }
            case 5046382: {
                return '-';
            }
            case 5111917: {
                return '#';
            }
            case 5242979: {
                return '%';
            }
            case 5242988: {
                return '+';
            }
            case 5308533: {
                return '?';
            }
            case 5374018: {
                return ']';
            }
            case 5374019: {
                return '}';
            }
            case 0x520050: {
                return ')';
            }
            case 5439555: {
                return ';';
            }
            case 5439596: {
                return '/';
            }
            case 5439601: {
                return '\\';
            }
            case 5439604: {
                return '*';
            }
            case 5505132: {
                return '~';
            }
            case 0x550070: {
                return '^';
            }
            case 5636162: {
                return '|';
            }
        }
        return '\uffff';
    }

    public static String demangleName(String name) {
        return Compilation.demangleName(name, false);
    }

    public static String demangleName(String name, boolean reversible) {
        StringBuffer sbuf = new StringBuffer();
        int len = name.length();
        boolean mangled = false;
        boolean predicate = false;
        boolean downCaseNext = false;
        for (int i = 0; i < len; ++i) {
            char d;
            char ch = name.charAt(i);
            if (downCaseNext && !reversible) {
                ch = Character.toLowerCase(ch);
                downCaseNext = false;
            }
            if (!reversible && ch == 'i' && i == 0 && len > 2 && name.charAt(i + 1) == 's' && !Character.isLowerCase(d = name.charAt(i + 2))) {
                mangled = true;
                predicate = true;
                ++i;
                if (!Character.isUpperCase(d) && !Character.isTitleCase(d)) continue;
                sbuf.append(Character.toLowerCase(d));
                ++i;
                continue;
            }
            if (ch == '$' && i + 2 < len) {
                char c2;
                char c1 = name.charAt(i + 1);
                d = Compilation.demangle2(c1, c2 = name.charAt(i + 2));
                if (d != '\uffff') {
                    sbuf.append(d);
                    i += 2;
                    mangled = true;
                    downCaseNext = true;
                    continue;
                }
                if (c1 == 'T' && c2 == 'o' && i + 3 < len && name.charAt(i + 3) == '$') {
                    sbuf.append("->");
                    i += 3;
                    mangled = true;
                    downCaseNext = true;
                    continue;
                }
            } else if (!reversible && i > 1 && (Character.isUpperCase(ch) || Character.isTitleCase(ch)) && Character.isLowerCase(name.charAt(i - 1))) {
                sbuf.append('-');
                mangled = true;
                ch = Character.toLowerCase(ch);
            }
            sbuf.append(ch);
        }
        if (predicate) {
            sbuf.append('?');
        }
        return mangled ? sbuf.toString() : name;
    }

    public String generateClassName(String hint) {
        hint = Compilation.mangleName(hint, true);
        if (this.mainClass != null) {
            hint = this.mainClass.getName() + '$' + hint;
        } else if (this.classPrefix != null) {
            hint = this.classPrefix + hint;
        }
        if (this.findNamedClass(hint) == null) {
            return hint;
        }
        int i = 0;
        String new_hint;
        while (this.findNamedClass(new_hint = hint + i) != null) {
            ++i;
        }
        return new_hint;
    }

    public String generateUniqueName(String hint) {
        if (this.currentPackage.findNamedClass(hint) == null) {
            return hint;
        }
        int i = 0;
        String new_hint;
        while (this.currentPackage.findNamedClass(new_hint = hint + i) != null) {
            ++i;
        }
        return new_hint;
    }

    public Compilation(ModuleExp lexp, String classname, String prefix, boolean immediate) {
        this.source_filename = lexp.filename;
        this.classPrefix = prefix;
        this.immediate = immediate;
        this.mainClass = new ClassType(classname);
        this.mainLambda = lexp;
        PushApply.pushApply(lexp);
        InlineCalls.inlineCalls(lexp);
        ChainLambdas.chainLambdas(lexp, this);
        FindTailCalls.findTailCalls(lexp);
        lexp.setCanRead(true);
        FindCapturedVars.findCapturedVars(lexp);
        if (debugPrintFinalExpr) {
            OutPort dout = OutPort.outDefault();
            dout.println("[Compiling final " + lexp.getName() + " class=" + classname + ':');
            lexp.print(dout);
            dout.println(']');
            dout.flush();
        }
        this.mainClass = this.addClass(lexp, this.mainClass);
        this.literalTable = new Hashtable(100);
        try {
            this.addClass(lexp);
        }
        catch (RuntimeException ex) {
            this.error('f', "Internal compiler exception: " + ex);
            throw ex;
        }
    }

    ClassType allocClass(ModuleExp module) {
        String name = module.getJavaName();
        name = this.generateClassName(name);
        return this.addClass(module, new ClassType(name));
    }

    ClassType addClass(LambdaExp lexp, ClassType type) {
        ClassType superType;
        if (lexp.isModuleBody()) {
            ModuleExp module = (ModuleExp)lexp;
            superType = this.getModuleSuperType(module);
            ClassType[] interfaces = module.getInterfaces();
            if (interfaces != null) {
                type.setInterfaces(interfaces);
            }
        } else {
            superType = usingCPStyle ? typeCallFrame : (lexp.isHandlingTailCalls() ? typeCpsProcedure : (lexp.min_args != lexp.max_args || lexp.min_args > 4 ? typeProcedureN : typeProcedureArray[lexp.min_args]));
        }
        type.setSuper(superType);
        lexp.type = type;
        this.addClass(type);
        return type;
    }

    public final Method getConstructor(LambdaExp lexp) {
        return Compilation.getConstructor(lexp.getHeapFrameType(), lexp);
    }

    public static final Method getConstructor(ClassType clas, LambdaExp lexp) {
        Type[] args = lexp instanceof ClassExp && lexp.staticLinkField != null ? new Type[]{lexp.staticLinkField.getType()} : apply0args;
        return clas.addMethod("<init>", 1, args, Type.void_type);
    }

    public final void generateConstructor(LambdaExp lexp) {
        this.generateConstructor(lexp.getHeapFrameType(), lexp);
    }

    public final void generateConstructor(ClassType clas, LambdaExp lexp) {
        Initializer init;
        Method constructor_method;
        if (lexp instanceof ClassExp && !((ClassExp)lexp).needsConstructor) {
            return;
        }
        Method save_method = this.method;
        ClassType save_class = this.curClass;
        this.curClass = clas;
        clas.constructor = constructor_method = Compilation.getConstructor(clas, lexp);
        constructor_method.eraseCode();
        Method superConstructor = clas.getSuperclass().addMethod("<init>", 1, apply0args, Type.void_type);
        this.method = constructor_method;
        constructor_method.init_param_slots();
        CodeAttr code = this.getCode();
        code.emitPushThis();
        code.emitInvokeSpecial(superConstructor);
        if (lexp instanceof ClassExp && lexp.staticLinkField != null) {
            code.emitPushThis();
            code.emitLoad(code.getCurrentScope().getVariable(1));
            code.emitPutField(lexp.staticLinkField);
        }
        lexp.initChain = Initializer.reverse(lexp.initChain);
        while ((init = lexp.initChain) != null) {
            lexp.initChain = init.next;
            init.emit(this);
        }
        if (lexp instanceof ClassExp) {
            ClassExp cexp = (ClassExp)lexp;
            LambdaExp initMethod = cexp.initMethod;
            if (initMethod != null) {
                code.emitPushThis();
                code.emitInvoke(initMethod.getMainMethod());
            }
        }
        code.emitReturn();
        this.method = save_method;
        this.curClass = save_class;
    }

    public void generateApplyMethods(LambdaExp lexp) {
        int i;
        int numApplyMethods;
        int n = numApplyMethods = lexp.applyMethods == null ? 0 : lexp.applyMethods.size();
        if (numApplyMethods == 0) {
            return;
        }
        boolean generateApplyMethodContainer = !this.curClass.getSuperclass().isSubtype(typeProcedure);
        ClassType procType = Compilation.getMethodProcType(this.curClass);
        if (usingTailCalls) {
            this.curClass.addInterface(typeCpsMethodContainer);
        } else if (generateApplyMethodContainer) {
            this.curClass.addInterface(typeApplyMethodContainer);
        }
        Method save_method = this.method;
        CodeAttr code = null;
        int n2 = i = usingTailCalls ? 5 : 0;
        while (i < 6) {
            boolean needThisApply = false;
            SwitchState aswitch = null;
            String mname = null;
            Type[] applyArgs = null;
            int j = numApplyMethods;
            while (--j >= 0) {
                int methodIndex;
                LambdaExp source = (LambdaExp)lexp.applyMethods.elementAt(j);
                int min_args = source.min_args;
                if (source.isClassMethod()) {
                    ++min_args;
                }
                Method[] primMethods = source.primMethods;
                int numMethods = primMethods.length;
                boolean varArgs = source.max_args < 0 || usingTailCalls || source.max_args >= min_args + numMethods;
                boolean skipThisProc = false;
                if (i < 5) {
                    methodIndex = i - min_args;
                    if (methodIndex < 0 || methodIndex >= numMethods || methodIndex == numMethods - 1 && varArgs) {
                        skipThisProc = true;
                    }
                    numMethods = 1;
                    varArgs = false;
                } else {
                    methodIndex = 5 - min_args;
                    if (methodIndex > 0 && numMethods <= methodIndex && !varArgs) {
                        skipThisProc = true;
                    }
                    methodIndex = numMethods - 1;
                }
                if (skipThisProc && !generateApplyMethodContainer) continue;
                if (!needThisApply) {
                    if (i < 5) {
                        mname = "apply" + i;
                        applyArgs = new Type[i + 1];
                        for (int k = i; k > 0; --k) {
                            applyArgs[k] = typeObject;
                        }
                    } else if (usingTailCalls) {
                        mname = "apply";
                        applyArgs = new Type[2];
                        applyArgs[1] = typeCallContext;
                    } else {
                        mname = "applyN";
                        applyArgs = new Type[2];
                        applyArgs[1] = objArrayType;
                    }
                    applyArgs[0] = procType;
                    this.method = this.curClass.addMethod(mname, applyArgs, usingTailCalls ? Type.void_type : Type.pointer_type, 1);
                    this.method.init_param_slots();
                    code = this.getCode();
                    code.emitLoad(code.getArg(1));
                    code.emitGetField(procType.getDeclaredField("selector"));
                    aswitch = new SwitchState(code);
                    needThisApply = true;
                }
                if (skipThisProc && generateApplyMethodContainer) continue;
                aswitch.addCase(source.getSelectorValue(this), code);
                Method primMethod = primMethods[methodIndex];
                Type[] primArgTypes = primMethod.getParameterTypes();
                int nargs = primArgTypes.length;
                int singleArgs = varArgs ? nargs - 1 : nargs;
                Variable counter = null;
                int pendingIfEnds = 0;
                if (i > 4 && numMethods > 1) {
                    counter = code.addLocal(Type.int_type);
                    code.emitLoad(code.getArg(2));
                    code.emitArrayLength();
                    if (min_args != 0) {
                        code.emitPushInt(min_args);
                        code.emitSub(Type.int_type);
                    }
                    code.emitStore(counter);
                }
                int argumentStart = 2;
                if (source.getNeedsClosureEnv()) {
                    code.emitPushThis();
                }
                if (source.isClassMethod()) {
                    code.emitLoad(code.getArg(argumentStart++));
                    ClassType ptype = primMethod.getDeclaringClass();
                    ((Type)ptype).emitCoerceFromObject(code);
                }
                Declaration var = source.firstDecl();
                for (int k = 0; k < singleArgs; ++k) {
                    if (counter != null && k >= min_args) {
                        code.emitLoad(counter);
                        code.emitIfIntLEqZero();
                        code.emitInvoke(primMethods[k - min_args]);
                        code.emitElse();
                        ++pendingIfEnds;
                        code.emitInc(counter, (short)-1);
                    }
                    if (i > 4) {
                        code.emitLoad(code.getArg(2));
                        code.emitPushInt(k);
                        code.emitArrayLoad(Type.pointer_type);
                    } else {
                        code.emitLoad(code.getArg(k + argumentStart));
                    }
                    Type ptype = var.getType();
                    if (ptype != Type.pointer_type) {
                        CheckedTarget.emitCheckedCoerce(this, source, k, ptype);
                    }
                    var = var.nextDecl();
                }
                if (varArgs) {
                    Type lastArgType = primArgTypes[singleArgs];
                    if (lastArgType instanceof ArrayType) {
                        boolean mustConvert;
                        Type elType = ((ArrayType)lastArgType).getComponentType();
                        boolean bl = mustConvert = !"java.lang.Object".equals(elType.getName());
                        if (singleArgs == 0 && !mustConvert) {
                            code.emitLoad(code.getArg(2));
                        } else {
                            code.pushScope();
                            if (counter == null) {
                                counter = code.addLocal(Type.int_type);
                                code.emitLoad(code.getArg(2));
                                code.emitArrayLength();
                                if (singleArgs != 0) {
                                    code.emitPushInt(singleArgs);
                                    code.emitSub(Type.int_type);
                                }
                                code.emitStore(counter);
                            }
                            code.emitLoad(counter);
                            code.emitNewArray(elType);
                            Label testLabel = new Label(code);
                            code.emitGoto(testLabel);
                            Label loopTopLabel = new Label(code);
                            loopTopLabel.define(code);
                            code.emitDup(1);
                            code.emitLoad(counter);
                            code.emitLoad(code.getArg(2));
                            code.emitLoad(counter);
                            if (singleArgs != 0) {
                                code.emitPushInt(singleArgs);
                                code.emitAdd(Type.int_type);
                            }
                            code.emitArrayLoad(Type.pointer_type);
                            if (mustConvert) {
                                CheckedTarget.emitCheckedCoerce(this, source, source.getName(), -1, elType);
                            }
                            code.emitArrayStore(elType);
                            testLabel.define(code);
                            code.emitInc(counter, (short)-1);
                            code.emitLoad(counter);
                            code.emitGotoIfIntGeZero(loopTopLabel);
                            code.popScope();
                        }
                    } else if ("gnu.lists.LList".equals(lastArgType.getName())) {
                        code.emitLoad(code.getArg(2));
                        code.emitPushInt(singleArgs);
                        code.emitInvokeStatic(makeListMethod);
                    } else if (lastArgType == typeCallContext) {
                        code.emitLoad(code.getArg(2));
                    } else {
                        throw new RuntimeException("unsupported #!rest type:" + lastArgType);
                    }
                }
                code.emitInvoke(primMethod);
                while (--pendingIfEnds >= 0) {
                    code.emitFi();
                }
                if (!usingTailCalls) {
                    Target.pushObject.compileFromStack(this, source.getReturnType());
                }
                code.emitReturn();
            }
            if (needThisApply) {
                aswitch.finish(code);
            }
            ++i;
        }
        lexp.applyMethods = null;
        this.method = save_method;
    }

    private Method startClassInit() {
        ClassType interpreterType;
        Method registerMethod;
        this.method = this.curClass.addMethod("<clinit>", apply0args, Type.void_type, 9);
        this.method.init_param_slots();
        CodeAttr code = this.getCode();
        if ((this.generateMain || this.generateApplet || this.generateServlet) && (registerMethod = (interpreterType = (ClassType)Type.make(this.getInterpreter().getClass())).getDeclaredMethod("registerEnvironment", 0)) != null) {
            code.emitInvokeStatic(registerMethod);
        }
        return this.method;
    }

    public final ClassType addClass(ModuleExp module) {
        int line;
        Method apply_method;
        Type[] arg_types;
        int arg_letter;
        ClassType new_class = module.type;
        if (new_class == typeProcedure) {
            new_class = this.allocClass(module);
        }
        this.curClass = new_class;
        String filename = module.getFile();
        module.type = new_class;
        if (filename != null) {
            new_class.setSourceFile(filename);
        }
        LambdaExp saveLambda = this.curLambda;
        this.curLambda = module;
        if (module.isHandlingTailCalls() || Compilation.usingCPStyle()) {
            boolean arg_count = true;
            arg_letter = 63;
            arg_types = new Type[]{typeCallContext};
        } else if (module.min_args != module.max_args || module.min_args > 4 || fewerClasses && this.curClass == this.mainClass) {
            boolean arg_count = true;
            arg_letter = 78;
            arg_types = new Type[]{new ArrayType(typeObject)};
        } else {
            int arg_count = module.min_args;
            arg_letter = Character.forDigit(arg_count, 10);
            arg_types = new Type[arg_count];
            int i = arg_count;
            while (--i >= 0) {
                arg_types[i] = typeObject;
            }
        }
        if (arg_letter == 78 || arg_letter == 63) {
            this.method = this.curClass.addMethod("numArgs", apply0args, Type.int_type, 1);
            this.method.init_param_slots();
            CodeAttr code = this.getCode();
            code.emitPushInt(module.min_args | module.max_args << 12);
            code.emitReturn();
        }
        Expression body = module.body;
        Variable heapFrame = module.heapFrame;
        boolean staticModule = false;
        Label classInitLabel = null;
        Label classBodyLabel = null;
        if (Compilation.usingCPStyle()) {
            apply_method = this.curClass.addMethod("step", arg_types, Type.void_type, 17);
        } else if (module.isHandlingTailCalls()) {
            apply_method = this.curClass.addMethod("apply", arg_types, Type.void_type, 17);
        } else {
            staticModule = true;
            this.generateConstructor(module);
            this.instanceField = this.curClass.addField("$instance", this.curClass, 24);
            apply_method = this.startClassInit();
            CodeAttr code = this.getCode();
            code.emitNew(this.curClass);
            code.emitDup(this.curClass);
            code.emitInvokeSpecial(this.curClass.constructor);
            code.emitPutStatic(this.instanceField);
            classInitLabel = new Label(code);
            classBodyLabel = new Label(code);
            code.emitGoto(classInitLabel);
            classBodyLabel.define(code);
        }
        this.method = apply_method;
        this.method.initCode();
        CodeAttr code = this.getCode();
        this.thisDecl = this.method.getStaticFlag() ? null : module.declareThis(new_class);
        module.closureEnv = module.thisVariable;
        module.heapFrame = module.thisVariable;
        module.allocChildClasses(this);
        if (module.isHandlingTailCalls() || Compilation.usingCPStyle()) {
            this.callStackContext = new Variable("$ctx", typeCallContext);
            Scope scope = module.scope;
            scope.addVariableAfter(this.thisDecl, this.callStackContext);
            this.callStackContext.setParameter(true);
            this.callStackContext.setArtificial(true);
        }
        if ((line = module.getLine()) > 0) {
            code.putLineNumber(module.getFile(), line);
        }
        module.allocParameters(this);
        module.enterFunction(this);
        if (Compilation.usingCPStyle()) {
            code.emitLoad(this.callStackContext);
            code.emitGetField(pcCallContextField);
            this.fswitch = new SwitchState(code);
            Label l = new Label(code);
            l.define(code);
            this.fswitch.addCase(0, l, code);
        }
        try {
            module.compileBody(this);
        }
        catch (Exception ex) {
            this.error('f', "internal error while compiling - caught: " + ex);
            ex.printStackTrace(System.err);
            System.exit(-1);
        }
        module.compileEnd(this);
        if (fewerClasses) {
            this.method.popScope();
        }
        module.heapFrame = heapFrame;
        module.compileChildMethods(this);
        if (Compilation.usingCPStyle() || fewerClasses && this.curClass == this.mainClass) {
            code = this.getCode();
            this.fswitch.finish(code);
        }
        if (usingTailCalls && !staticModule) {
            this.generateConstructor(module);
        }
        if (this.curClass == this.mainClass && (staticModule || this.clinitChain != null || this.literalsChain != null || this.generateMain || this.generateApplet || this.generateServlet)) {
            Method save_method = this.method;
            if (staticModule) {
                classInitLabel.define(code);
            } else {
                this.startClassInit();
            }
            code = this.getCode();
            if (this.clinitChain != null) {
                Label lab0 = new Label(code);
                Label lab1 = new Label(code);
                Label lab2 = new Label(code);
                code.emitGoto(lab1);
                lab0.define(code);
                this.dumpInitializers(this.clinitChain);
                code.emitGoto(lab2);
                lab1.define(code);
                Literal.emit(this);
                code.emitGoto(lab0);
                lab2.define(code);
            } else {
                Literal.emit(this);
            }
            if (staticModule) {
                code.emitGoto(classBodyLabel);
            } else {
                code.emitReturn();
            }
            this.method = save_method;
        }
        this.curLambda = saveLambda;
        if (this.generateMain && this.curClass == this.mainClass) {
            Type[] args = new Type[]{new ArrayType(javaStringType)};
            this.method = this.curClass.addMethod("main", 9, args, Type.void_type);
            this.method.init_param_slots();
            code = this.getCode();
            code.emitNew(this.curClass);
            code.emitDup(this.curClass);
            code.emitInvokeSpecial(this.curClass.constructor);
            code.emitLoad(code.getArg(0));
            Method moduleMain = typeModuleBody.addMethod("runAsMain", 1, args, Type.void_type);
            code.emitInvokeVirtual(moduleMain);
            code.emitReturn();
        }
        return new_class;
    }

    public static boolean usingCPStyle() {
        return usingCPStyle;
    }

    public boolean usingTailCalls() {
        return usingTailCalls;
    }

    public Field allocLocalField(Type type, String name) {
        if (name == null) {
            name = "tmp_" + ++this.localFieldIndex;
        }
        Field field = this.curClass.addField(name, type, 0);
        return field;
    }

    public final void loadCallContext() {
        this.getCode().emitLoad(this.callStackContext);
    }

    public void freeLocalField(Field field) {
    }

    public void error(char severity, String message) {
        this.error(severity, this.filename, this.position >> 12, this.position & 0xFFF, message);
    }

    public void error(char severity, String filename, int line, int column, String message) {
        this.error(new SourceError(severity, filename, line, column, message));
    }

    public void error(SourceError err) {
        System.err.println(err);
    }

    public Compilation() {
        this.immediate = false;
    }

    public void compile(Package root) {
        Package pkg = root;
        while (pkg != null) {
            this.allocate(pkg);
            pkg = pkg.next;
        }
        pkg = root;
        while (pkg != null) {
            this.generate(pkg);
            pkg = pkg.next;
        }
    }

    public void allocate(Package pkg) {
        this.currentPackage = pkg;
        this.classPrefix = pkg.name == null ? "" : pkg.name + ".";
        ChainLambdas.chainLambdas(pkg, this);
        FindTailCalls.findTailCalls(pkg);
        FindCapturedVars.findCapturedVars(pkg);
        LambdaExp c = pkg.firstClass;
        while (c != null) {
            c.declareParts(this);
            c = c.nextSibling;
        }
    }

    public void generate(Package pkg) {
        this.currentPackage = pkg;
        this.source_filename = pkg.directory.getPath();
        this.classPrefix = pkg.name + ".";
        this.compileAll(pkg);
    }

    private final void compileAll(Package pkg) {
        LambdaExp c = pkg.firstClass;
        while (c != null) {
            this.literalTable = new Hashtable(100);
            c.literalTable = this.literalTable;
            this.topLambda = c;
            if (c.outer != null) {
                this.topLambda = (LambdaExp)c.outer;
            }
            this.topClass = (ClassType)this.topLambda.getType();
            ((LambdaExp)c).compileChildMethods(this);
            c = c.nextSibling;
        }
        c = pkg.firstClass;
        while (c != null) {
            this.topLambda = c;
            if (c.outer != null) {
                this.topLambda = (LambdaExp)c.outer;
            }
            this.literalTable = c.literalTable;
            this.curClass = this.topClass = (ClassType)this.topLambda.getType();
            c.generateClassInit(this);
            this.generateApplyMethods(c);
            c = c.nextSibling;
        }
    }

    public void addClass(ClassType new_class) {
        this.currentPackage.addClass(new_class);
        new_class.access_flags |= 1;
    }

    static {
        usingTailCalls = false;
        moduleStatic = 0;
        typeObject = Type.pointer_type;
        scmBooleanType = ClassType.make("java.lang.Boolean");
        javaStringType = typeString = ClassType.make("java.lang.String");
        scmSymbolType = typeString;
        scmKeywordType = ClassType.make("gnu.expr.Keyword");
        scmSequenceType = ClassType.make("gnu.lists.Sequence");
        javaIntegerType = ClassType.make("java.lang.Integer");
        scmListType = ClassType.make("gnu.lists.LList");
        scmPairType = typePair = ClassType.make("gnu.lists.Pair");
        scmUndefinedType = ClassType.make("gnu.expr.Undefined");
        objArrayType = ArrayType.make(typeObject);
        symbolArrayType = ArrayType.make(scmSymbolType);
        scmNamedType = ClassType.make("gnu.mapping.Named");
        typeRunnable = ClassType.make("java.lang.Runnable");
        typeObjectType = ClassType.make("gnu.bytecode.ObjectType");
        typeClassType = ClassType.make("gnu.bytecode.ClassType", typeObjectType);
        typeProcedure = ClassType.make("gnu.mapping.Procedure");
        typeInterpreter = ClassType.make("gnu.expr.Interpreter");
        typeMacro = ClassType.make("kawa.lang.Macro");
        typeEnvironment = ClassType.make("gnu.mapping.Environment");
        typeLocation = ClassType.make("gnu.mapping.Location");
        typeBinding = ClassType.make("gnu.mapping.Binding", typeLocation);
        getLocationMethod = typeLocation.addMethod("get", Type.typeArray0, Type.pointer_type, 1);
        getProcedureBindingMethod = typeBinding.addMethod("getProcedure", Type.typeArray0, typeProcedure, 1);
        trueConstant = scmBooleanType.addField("TRUE", scmBooleanType, 9);
        falseConstant = scmBooleanType.addField("FALSE", scmBooleanType, 9);
        voidConstant = typeInterpreter.addField("voidObject", typeObject, 9);
        undefinedConstant = typeInterpreter.addField("undefinedObject", scmUndefinedType, 9);
        emptyConstant = scmListType.addField("Empty", scmListType, 9);
        eofConstant = scmSequenceType.addField("eofValue", typeObject, 9);
        setNameMethod = typeProcedure.getDeclaredMethod("setName", 1);
        int1Args = new Type[]{Type.int_type};
        string1Arg = new Type[]{javaStringType};
        sym1Arg = string1Arg;
        getBindingEnvironmentMethod = typeEnvironment.addMethod("getBinding", string1Arg, typeBinding, 1);
        Type[] makeListArgs = new Type[]{objArrayType, Type.int_type};
        makeListMethod = scmListType.addMethod("makeList", makeListArgs, scmListType, 9);
        initIntegerMethod = javaIntegerType.addMethod("<init>", int1Args, Type.void_type, 1);
        lookupGlobalMethod = typeEnvironment.addMethod("lookup_global", sym1Arg, typeObject, 9);
        Type[] symObjArgs = new Type[]{scmSymbolType, typeObject};
        defineGlobalMethod = typeEnvironment.addMethod("define_global", symObjArgs, Type.void_type, 9);
        defineFunctionMethod = typeEnvironment.addMethod("defineFunction", symObjArgs, Type.void_type, 9);
        putGlobalMethod = typeEnvironment.addMethod("put_global", symObjArgs, Type.void_type, 9);
        getCurrentEnvironmentMethod = typeEnvironment.addMethod("getCurrent", Type.typeArray0, typeEnvironment, 9);
        apply0args = Type.typeArray0;
        apply1args = new Type[]{typeObject};
        apply2args = new Type[]{typeObject, typeObject};
        applyNargs = new Type[]{objArrayType};
        apply0method = typeProcedure.addMethod("apply0", apply0args, typeObject, 17);
        apply1method = typeProcedure.addMethod("apply1", apply1args, typeObject, 1);
        apply2method = typeProcedure.addMethod("apply2", apply2args, typeObject, 1);
        Type[] apply3args = new Type[]{typeObject, typeObject, typeObject};
        apply3method = typeProcedure.addMethod("apply3", apply3args, typeObject, 1);
        Type[] apply4args = new Type[]{typeObject, typeObject, typeObject, typeObject};
        apply4method = typeProcedure.addMethod("apply4", apply4args, typeObject, 1);
        applyNmethod = typeProcedure.addMethod("applyN", applyNargs, typeObject, 1);
        Type[] args = new Type[]{typeProcedure, Type.int_type};
        checkArgCountMethod = typeProcedure.addMethod("checkArgCount", args, Type.void_type, 9);
        applymethods = new Method[]{apply0method, apply1method, apply2method, apply3method, apply4method, applyNmethod};
        typeProcedure0 = ClassType.make("gnu.mapping.Procedure0", typeProcedure);
        typeProcedure1 = ClassType.make("gnu.mapping.Procedure1", typeProcedure);
        typeProcedure2 = ClassType.make("gnu.mapping.Procedure2", typeProcedure);
        typeProcedure3 = ClassType.make("gnu.mapping.Procedure3", typeProcedure);
        typeProcedure4 = ClassType.make("gnu.mapping.Procedure4", typeProcedure);
        typeProcedureN = ClassType.make("gnu.mapping.ProcedureN", typeProcedure);
        typeModuleBody = ClassType.make("gnu.expr.ModuleBody", typeProcedure0);
        typeApplet = ClassType.make("java.applet.Applet");
        typeServlet = ClassType.make("gnu.kawa.servlet.KawaServlet");
        typeModuleMethod = ClassType.make("gnu.expr.ModuleMethod", typeProcedureN);
        typeApplyMethodProc = ClassType.make("gnu.mapping.ApplyMethodProc", typeProcedureN);
        typeApplyMethodContainer = ClassType.make("gnu.mapping.ApplyMethodContainer");
        typeCallContext = ClassType.make("gnu.mapping.CallContext");
        typeConsumer = ClassType.make("gnu.lists.Consumer");
        popCallContextMethod = typeCallContext.addMethod("pop", apply0args, Type.void_type, 1);
        typeValues = ClassType.make("gnu.mapping.Values");
        noArgsField = typeValues.addField("noArgs", objArrayType, 9);
        pcCallContextField = typeCallContext.addField("pc", Type.int_type, 4);
        typeCpsProcedure = ClassType.make("gnu.mapping.CpsProcedure");
        typeCallFrame = ClassType.make("gnu.mapping.CallFrame");
        typeCpsMethodProc = ClassType.make("gnu.mapping.CpsMethodProc", typeCpsProcedure);
        typeCpsMethodContainer = ClassType.make("gnu.mapping.CpsMethodContainer");
        numArgsCallFrameField = typeCallFrame.addField("numArgs", Type.int_type, 4);
        argsCallContextField = typeCallContext.addField("values", objArrayType, 4);
        procCallContextField = typeCallContext.addField("proc", typeProcedure, 4);
        callerCallFrameField = typeCallFrame.addField("caller", typeCallFrame, 4);
        saved_pcCallFrameField = typeCallFrame.addField("saved_pc", Type.int_type, 4);
        applyCpsArgs = new Type[]{typeCallContext};
        applyCpsMethod = typeProcedure.addMethod("apply", applyCpsArgs, Type.void_type, 1);
        typeProcedureArray = new ClassType[]{typeProcedure0, typeProcedure1, typeProcedure2, typeProcedure3, typeProcedure4};
        generateMainDefault = false;
        generateAppletDefault = false;
        generateServletDefault = false;
    }
}

