/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing;

import bossa.util.Util;
import mlsub.typing.AtomicKind;
import mlsub.typing.InternalError;
import mlsub.typing.Monotype;
import mlsub.typing.TypeSymbol;
import mlsub.typing.lowlevel.Element;
import mlsub.typing.lowlevel.Engine;
import mlsub.typing.lowlevel.Kind;

public class TypeConstructor
implements Element,
TypeSymbol {
    private int id = -1;
    private Kind kind;
    public AtomicKind variance;
    private boolean concrete;
    private boolean rigid;
    String name;

    public TypeConstructor(String name, AtomicKind v, boolean concrete, boolean rigid) {
        this.name = name;
        this.concrete = concrete;
        this.rigid = rigid;
        if (v != null) {
            this.setVariance(v);
        }
    }

    public TypeConstructor(String name) {
        this(name, null, false, false);
    }

    public TypeConstructor(AtomicKind v) {
        this(null, v, false, false);
    }

    public void setMinimal() {
        this.variance.getConstraint().assertMinimal(this);
    }

    public boolean isMinimal() {
        return this.variance.getConstraint().isMinimal(this);
    }

    public TypeSymbol cloneTypeSymbol() {
        return new TypeConstructor(this.name, this.variance, this.concrete, this.rigid);
    }

    public static TypeConstructor fromTypeSymbol(TypeSymbol s) {
        if (s instanceof TypeConstructor) {
            return (TypeConstructor)s;
        }
        return null;
    }

    public void setVariance(AtomicKind v) {
        this.setKind(v.getConstraint());
    }

    public int arity() {
        if (this.variance == null) {
            throw new InternalError("Variance of " + this + " not known in arity()");
        }
        return this.variance.arity();
    }

    public boolean isConcrete() {
        return this.concrete;
    }

    public boolean isExistential() {
        return false;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int value) {
        this.id = value;
    }

    public Kind getKind() {
        return this.kind;
    }

    public void setKind(Kind value) {
        if (this.kind != null) {
            if (this.kind == value) {
                return;
            }
            throw new InternalError("Variance already set in type constructor " + this);
        }
        this.variance = (AtomicKind)((Engine.Constraint)value).associatedKind;
        this.kind = value;
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return super.toString();
    }

    public String toString(Monotype[] parameters) {
        return this.toString(parameters, false, null);
    }

    public String toString(Monotype[] parameters, boolean isNull, String suffix) {
        String res = this.toString() + Util.map("<", ", ", ">", parameters);
        if (isNull) {
            res = "?" + res;
        }
        if (suffix != null) {
            res = res + suffix;
        }
        return res;
    }

    public final boolean isRigid() {
        return this.rigid;
    }
}

