/*
 * Decompiled with CFR 0.152.
 */
package nice.lang.inline;

import bossa.syntax.ConstantExp;
import bossa.syntax.Macro;
import bossa.util.User;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Branchable;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.Procedure2;
import mlsub.typing.TypeConstructor;
import mlsub.typing.Typing;
import nice.lang.inline.Tools;
import nice.tools.typing.Types;

public class CompOp
extends Procedure2
implements Branchable,
Macro {
    private static final int error = 0;
    private static final int Eq = 1;
    private static final int Ge = 2;
    private static final int Le = 3;
    private static final int Lt = 4;
    private static final int Gt = 5;
    private static final int Ne = 6;
    private final int kind;
    private final PrimType argType;
    private final Type retType = Type.boolean_type;

    public static CompOp create(String param) {
        PrimType argType = Tools.numericType(param.charAt(0));
        if (argType == null) {
            User.error("Unknown type in inlined comparison operator: " + param);
        }
        param = param.substring(1);
        int kind = 0;
        if ("Eq".equals(param)) {
            kind = 1;
        } else if ("Ge".equals(param)) {
            kind = 2;
        } else if ("Le".equals(param)) {
            kind = 3;
        } else if ("Lt".equals(param)) {
            kind = 4;
        } else if ("Gt".equals(param)) {
            kind = 5;
        } else if ("Ne".equals(param)) {
            kind = 6;
        } else {
            User.error("Unknown inlined numeric operator " + param);
        }
        return new CompOp(kind, argType);
    }

    private CompOp(int kind, PrimType argType) {
        this.kind = kind;
        this.argType = argType;
    }

    public void compile(ApplyExp exp, Compilation comp, Target target) {
        Expression[] args = exp.getArgs();
        CodeAttr code = comp.getCode();
        StackTarget stack = new StackTarget(this.argType);
        args[0].compile(comp, stack);
        args[1].compile(comp, stack);
        switch (this.kind) {
            case 1: {
                code.emitIfEq();
                break;
            }
            case 3: {
                code.emitIfLe();
                break;
            }
            case 2: {
                code.emitIfGe();
                break;
            }
            case 4: {
                code.emitIfLt();
                break;
            }
            case 5: {
                code.emitIfGt();
                break;
            }
            case 6: {
                code.emitIfNEq();
            }
        }
        code.emitPushBoolean(true);
        code.emitElse();
        code.emitPushBoolean(false);
        code.emitFi();
        target.compileFromStack(comp, this.retType);
    }

    public void compileJump(Compilation comp, Expression[] args, Label to) {
        CodeAttr code = comp.getCode();
        StackTarget stack = new StackTarget(this.argType);
        args[0].compile(comp, stack);
        args[1].compile(comp, stack);
        switch (this.kind) {
            case 1: {
                code.emitGotoIfEq(to);
                break;
            }
            case 3: {
                code.emitGotoIfLe(to);
                break;
            }
            case 2: {
                code.emitGotoIfGe(to);
                break;
            }
            case 4: {
                code.emitGotoIfLt(to);
                break;
            }
            case 5: {
                code.emitGotoIfGt(to);
                break;
            }
            case 6: {
                code.emitGotoIfNE(to);
            }
        }
    }

    public void compileJumpNot(Compilation comp, Expression[] args, Label to) {
        CodeAttr code = comp.getCode();
        StackTarget stack = new StackTarget(this.argType);
        args[0].compile(comp, stack);
        args[1].compile(comp, stack);
        switch (this.kind) {
            case 1: {
                code.emitGotoIfNE(to);
                break;
            }
            case 3: {
                code.emitGotoIfGt(to);
                break;
            }
            case 2: {
                code.emitGotoIfLt(to);
                break;
            }
            case 4: {
                code.emitGotoIfGe(to);
                break;
            }
            case 5: {
                code.emitGotoIfLe(to);
                break;
            }
            case 6: {
                code.emitGotoIfEq(to);
            }
        }
    }

    public Type getReturnType(Expression[] args) {
        return this.retType;
    }

    public void checkSpecialRequirements(bossa.syntax.Expression[] arguments) {
        TypeConstructor tc;
        ConstantExp literalexp = null;
        bossa.syntax.Expression otherexp = null;
        if (arguments[0] instanceof ConstantExp && !(arguments[1] instanceof ConstantExp)) {
            literalexp = (ConstantExp)arguments[0];
            otherexp = arguments[1];
        } else if (arguments[1] instanceof ConstantExp && !(arguments[0] instanceof ConstantExp)) {
            literalexp = (ConstantExp)arguments[1];
            otherexp = arguments[0];
        }
        if (literalexp != null && Typing.testRigidLeq(tc = Types.equivalent(otherexp.getType().getMonotype()).head(), literalexp.tc) && !Typing.testRigidLeq(literalexp.tc, tc)) {
            User.warning(otherexp, "Comparing a value with a constant outside the range of that value");
        }
    }

    public Object apply2(Object arg1, Object arg2) {
        throw new Error("Not implemented");
    }
}

