/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.typing;

import bossa.syntax.Monotype;
import bossa.syntax.PrimitiveType;
import gnu.bytecode.PrimType;
import mlsub.typing.Constraint;
import mlsub.typing.Domain;
import mlsub.typing.FunType;
import mlsub.typing.MonotypeConstructor;
import mlsub.typing.MonotypeVar;
import mlsub.typing.NullnessKind;
import mlsub.typing.Polytype;
import mlsub.typing.TypeConstructor;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;
import mlsub.typing.lowlevel.Element;

public final class Types {
    public static boolean isVoid(mlsub.typing.Monotype m) {
        return Types.equivalent(m).head() == PrimitiveType.voidTC;
    }

    public static boolean isVoid(Polytype t) {
        return Types.isVoid(t.getMonotype());
    }

    public static boolean isPrimitive(TypeConstructor tc) {
        return nice.tools.code.Types.javaType(tc) instanceof PrimType;
    }

    public static boolean isPrimitive(mlsub.typing.Monotype t) {
        return nice.tools.code.Types.javaType(t) instanceof PrimType;
    }

    public static boolean isPrimitive(Polytype t) {
        return nice.tools.code.Types.javaType(t) instanceof PrimType;
    }

    public static boolean isMaybe(mlsub.typing.Monotype m) {
        return m instanceof MonotypeConstructor && ((MonotypeConstructor)m).getTC() == PrimitiveType.maybeTC;
    }

    public static boolean isSure(mlsub.typing.Monotype m) {
        return m instanceof MonotypeConstructor && ((MonotypeConstructor)m).getTC() == PrimitiveType.sureTC;
    }

    public static boolean isDispatchable(mlsub.typing.Monotype m) {
        if (Types.parameters(m) != null) {
            return false;
        }
        return !Types.isPrimitive(m);
    }

    public static mlsub.typing.Monotype equivalent(mlsub.typing.Monotype m) {
        return Types.rawType(m).equivalent();
    }

    public static void setMarkedKind(mlsub.typing.Monotype m) {
        m.setKind(NullnessKind.instance);
    }

    public static void makeMarkedType(MonotypeVar m) {
        m.setPersistentKind(NullnessKind.instance);
    }

    public static mlsub.typing.Monotype rawType(mlsub.typing.Monotype m) {
        if ((m = m.equivalent()).getKind() != NullnessKind.instance) {
            return m;
        }
        return ((MonotypeConstructor)m).getTP()[0];
    }

    public static mlsub.typing.Monotype rawType(MonotypeConstructor mc) {
        return mc.getTP()[0];
    }

    public static mlsub.typing.Monotype[] parameters(mlsub.typing.Monotype type) {
        return Types.rawType(type).domain();
    }

    public static mlsub.typing.Monotype[] parameters(Polytype type) {
        return Types.rawType(type.getMonotype()).domain();
    }

    public static mlsub.typing.Monotype result(Polytype type) {
        return ((FunType)Types.rawType(type.getMonotype())).codomain();
    }

    public static mlsub.typing.Monotype getTypeParameter(Polytype type, int rank) {
        type.simplify();
        return Types.getTypeParameter(type.getMonotype(), rank);
    }

    public static Polytype addSure(Polytype type) {
        return new Polytype(type.getConstraint(), Monotype.sure(type.getMonotype()));
    }

    public static TypeConstructor constructor(mlsub.typing.Monotype type) {
        return Types.equivalent(type).head();
    }

    public static TypeConstructor concreteConstructor(mlsub.typing.Monotype type) {
        TypeConstructor res = Types.constructor(type);
        if (res == null || res.isConcrete()) {
            return res;
        }
        return Typing.lowestInstance(res);
    }

    public static mlsub.typing.Monotype getTypeParameter(mlsub.typing.Monotype type, int rank) {
        if (!((type = Types.rawType(type)) instanceof MonotypeConstructor)) {
            return null;
        }
        mlsub.typing.Monotype[] parameters = ((MonotypeConstructor)type).getTP();
        if (parameters.length <= rank) {
            return null;
        }
        return parameters[rank];
    }

    public static Domain domain(Polytype t) {
        mlsub.typing.Monotype[] m = Types.parameters(t.getMonotype());
        return new Domain(t.getConstraint(), m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean covariantSpecialization(Polytype spec, Polytype origin) {
        boolean entered = false;
        if (Constraint.hasBinders(spec.getConstraint()) || Constraint.hasBinders(origin.getConstraint())) {
            entered = true;
            Typing.enter();
        }
        try {
            try {
                if (entered) {
                    Polytype clonedSpec = spec.cloneType();
                    Constraint.enter(origin.getConstraint());
                    Constraint.enter(clonedSpec.getConstraint());
                    Element[] args = MonotypeVar.news(Types.parameters(origin).length);
                    Typing.introduce(args);
                    Typing.leq((mlsub.typing.Monotype[])args, Types.parameters(origin));
                    Typing.leq((mlsub.typing.Monotype[])args, Types.parameters(clonedSpec));
                    Typing.implies();
                    Constraint.enter(spec.getConstraint());
                    Typing.leq((mlsub.typing.Monotype[])args, Types.parameters(spec));
                }
                Typing.leq(Types.result(spec), Types.result(origin));
            }
            finally {
                if (entered) {
                    Typing.leave();
                }
            }
        }
        catch (TypingEx ex) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean typeParameterDispatch(Polytype spec, Polytype origin) {
        mlsub.typing.Monotype[] originalParams = Types.parameters(origin);
        if (originalParams.length == 0) {
            return false;
        }
        Typing.enter();
        try {
            try {
                Polytype clonedSpec = spec.cloneType();
                Constraint.enter(origin.getConstraint());
                Constraint.enter(clonedSpec.getConstraint());
                Element[] args = MonotypeVar.news(originalParams.length);
                Typing.introduce(args);
                Typing.leq((mlsub.typing.Monotype[])args, originalParams);
                Typing.leqHead((mlsub.typing.Monotype[])args, Types.parameters(clonedSpec));
                Typing.implies();
                Constraint.enter(spec.getConstraint());
                Typing.leq((mlsub.typing.Monotype[])args, Types.parameters(spec));
            }
            finally {
                Typing.leave();
            }
        }
        catch (TypingEx ex) {
            return true;
        }
        return false;
    }
}

