# -*- coding: utf-8 -*-
#
#  lettuce.py - a LETTUCE compatible Saori module for ninix
#  Copyright (C) 2002-2009 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#  Copyright (C) 2002, 2003 by MATSUMURA Namihiko <nie@counterghost.net>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

import os
import sys
import signal
import socket

from ninix.dll import SAORI


class Saori(SAORI):

    module_name = 'LETTUCE'
    dll_name = 'lettuce.dll'

    def __init__(self):
	SAORI.__init__(self)
        self.files = {}
        self.sstpport = None
        self.__sakura = None

    def need_ghost_backdoor(self, sakura):
        self.__sakura = sakura

    def load(self, dir=os.curdir):
        self.dir = dir
        result = 0
        if self.loaded:
	    result = 2
        elif self.__sakura is not None:
            signal.signal(signal.SIGCHLD, self.signal_handler)
            self.loaded = 1
            result = 1
	return result

    def finalize(self):
        #for name in self.files:
        #    pid = self.files[name]['pid']
        #    if pid:
        #        os.kill(pid, 9)
        #        os.waitpid(pid, 0)
        self.files = {}
        return 1

    def signal_handler(self, signum, frame):
        for name in self.files:
            pid = self.files[name]['pid']
            if not pid:
                continue
            result = os.waitpid(pid, os.WNOHANG)
            if result:
                if os.WIFSTOPPED(result[1]):
                    self.files[name]['status'] = 'pause'
                else:
                    self.files[name]['pid'] = None
                    self.files[name]['status'] = 'stop'
                    ### send SSTP message ###
                    if os.WIFEXITED(result[1]) and self.sstpport:
                        address = ('', int(self.sstpport))
                        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
                        try:
                            s.connect(address)
                        except socket.error:
                            sys.stderr.write(
                                '%s: cannot connect to the SSTP server\n' % \
                                self.module_name)
                            return
                        s.send(
                            ''.join(('SEND SSTP/1.1\r\n'
                                     'Sender: %s\r\n' % self.module_name,
                                     'Event: OnApplicationOperationFinish\r\n',
                                     'Reference0: %s\r\n' % self.dll_name,
                                     'Reference1: play.finished\r\n',
                                     'Reference2: %s\r\n' % name,
                                     'Charset: ASCII\r\n\r\n')))
                        s.recv(1024)
                        s.close()

    def request(self, req):
        req_type, argument = self.evaluate_request(req)
        if not req_type:
            return 'SAORI/1.0 400 Bad Request\r\n\r\n'
        elif req_type == 'GET Version':
            return 'SAORI/1.0 200 OK\r\n\r\n'
        elif req_type == 'EXECUTE':
            if not argument:
                return 'SAORI/1.0 400 Bad Request\r\n\r\n'
            command = argument[0]
            result = 0
            if command == 'set.hwnd':
                if len(argument) < 2:
                    return 'SAORI/1.0 400 Bad Request\r\n\r\n'
                else:
                    self.sstpport = argument[1]
                    result = 1
            elif command == 'play':
                if len(argument) < 2:
                    return 'SAORI/1.0 400 Bad Request\r\n\r\n'
                else:
                    name = argument[1].replace('\\', '/').lower() ## FIXME: Shiori -> filename
                    filepath = os.path.join(self.dir,
                                            ''.join(('./', name, 'ogg')))
                if name in self.files:
                    pid = self.files[name]['pid']
                    if pid and self.files[name]['status'] == 'play':
                        try:
                            os.kill(-pid, 9)
                            os.waitpid(pid, 0)
                        except:
                            pass
                        self.files[name]['pid'] = 0
                else:
                    self.files[name] = {}
                if filepath:
                    pid = os.fork()
                    self.files[name]['pid'] = pid
                    if pid == 0:
                        os.setsid()
                        if os.path.isfile(filepath):
                            for regex, command in self.prefs.get_helpers_regex():
                                if regex.search(filepath):
                                    self.execute_command(command, filepath)
                        os._exit(0)
                    self.files[name]['status'] = 'play'
                    result = 1
            elif command == 'play.ex':
                pass # FIXME
            elif command == 'stop':
                if len(argument) < 2:
                    for name in self.files:
                        pid = self.files[name]['pid']
                        if pid:
                            try:
                                os.kill(-pid, 9)
                                os.waitpid(pid, 0)
                            except:
                                pass
                            self.files[name]['pid'] = 0
                    result = 1
                else:
                    name = argument[1].replace('\\', '/').lower()
                    if name in self.files:
                        pid = self.files[name]['pid']
                        if pid:
                            try:
                                os.kill(-pid, 9)
                                os.waitpid(pid, 0)                        
                            except:
                                pass
                            self.files[name]['pid'] = 0
                        result = 1
            elif command == 'pause':
                pass # FIXME
            elif command == 'set.loop':
                pass # FIXME
            elif command == 'reset.loop':
                pass # FIXME
            return 'SAORI/1.0 200 OK\r\nResult: %s\r\n\r\n' % result
        else:
            return 'SAORI/1.0 400 Bad Request\r\n\r\n'

    def execute_command(self, command, arg):
        if '%s' not in command:
            sys.stderr.write('cannot execute command (%s missing)\n')
            return
        os.system(command.replace('%s', arg, 1))
