# -*- coding: utf-8 -*-
#
#  textcopy.py - a TEXTCOPY compatible Saori module for ninix
#  Copyright (C) 2002-2011 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#  Copyright (C) 2002, 2003 by MATSUMURA Namihiko <nie@counterghost.net>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

import os

if 'DISPLAY' in os.environ:
    import gtk
else:
    gtk = None

from ninix.dll import SAORI


class Saori(SAORI):

    def __init__(self):
        SAORI.__init__(self)
        self.clipboard = None

    def check_import(self):
        return int(gtk is not None)

    def setup(self):
        self.clipboard = gtk.Clipboard(selection='PRIMARY')
        return 1

    def finalize(self):
        self.clipboard = None
        return 1

    def execute(self, argument):
        if not argument or self.clipboard is None:
            return self.RESPONSE[400]
        text = argument[0].encode('utf-8')
        self.clipboard.set_text(text)
        if len(argument) >= 2 and argument[1] != 0:
            return 'SAORI/1.0 200 OK\r\n' \
                   'Result: %s\r\n\r\n' % \
                   argument[0].encode(self.charset, 'replace')
        else:
            return self.RESPONSE[204]
