# -*- coding: utf-8 -*-
#
#  wmove.py - a wmove.dll compatible Saori module for ninix
#  Copyright (C) 2003-2011 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

# TODO:
# - STANDBY, STANDBY_INSIDE

import sys
import os

import glib

from ninix.dll import SAORI
import ninix.pix


class Saori(SAORI):

    def __init__(self):
        SAORI.__init__(self)
        self.__sakura = None

    def need_ghost_backdoor(self, sakura):
        self.__sakura = sakura

    def load(self, dir=os.curdir):
        self.commands = [[], []]
        self.timeout_id = None
        self.dir = dir
        result = 0
        if not self.__sakura:
            pass
        elif self.loaded:
	    result = 2
        else:
            self.sakura_name = self.__sakura.get_selfname()
            self.kero_name = self.__sakura.get_keroname()
            self.loaded = 1
            result = 1
	return result

    def finalize(self):
        if self.timeout_id:
            glib.source_remove(self.timeout_id)
            self.timeout_id = None
        self.commands = [[], []]
        self.sakura_name = ''
        self.kero_name = ''
        return 1

    def __check_argument(self, argument):
        name = argument[0]
        result = 1
        list_hwnd = [self.sakura_name, self.kero_name] ## FIXME: HWND
        if name in ['MOVE', 'MOVE_INSIDE', 'MOVETO', 'MOVETO_INSIDE']:
            if len(argument) != 4 or argument[1] not in list_hwnd:
                result = 0
        elif name in ['ZMOVE', 'WAIT']:
            if len(argument) != 3 or argument[1] not in list_hwnd:
                result = 0
        elif name in ['STANDBY', 'STANDBY_INSIDE']:
            if len(argument) != 6 or \
               argument[1] not in list_hwnd or argument[2] not in list_hwnd:
                result = 0
        elif name in ['GET_POSITION', 'CLEAR']:
            if len(argument) != 2 or argument[1] not in list_hwnd:
                result = 0
        elif name == 'GET_DESKTOP_SIZE':
            if len(argument) != 1:
                result = 0
        elif name == 'NOTIFY':
            if len(argument) < 3 or len(argument) > 8 or \
               argument[1] not in list_hwnd:
                result = 0
        return result

    def request(self, req): ## FIXME
        req_type, argument = self.evaluate_request(req)

        if not req_type:
            result = self.RESPONSE[400]
        elif req_type == 'GET Version':
            result = self.RESPONSE[204]
        elif req_type == 'EXECUTE':
            if not argument:
                result = self.RESPONSE[400]
            elif not self.__check_argument(argument):
                result = self.RESPONSE[400]
            else:
                name = argument[0]
                if name == 'GET_POSITION':
                    if argument[1] == self.sakura_name: ## FIXME: HWND
                        side = 0
                    elif argument[1] == self.kero_name: ## FIXME: HWND
                        side = 1
                    else:
                        return self.RESPONSE[400]
                    try:
                        x, y = self.__sakura.get_surface_position(side)
                        w, h = self.__sakura.get_surface_size(side)
                        result = 'SAORI/1.0 200 OK\r\n' \
                            'Result: %d\r\n' \
                            'Value0: %d\r\n' \
                            'Value1: %d\r\n' \
                            'Value2: %d\r\n\r\n' % (x, x, x + w / 2, x + w)
                    except:
                        result = self.RESPONSE[500]
                elif name == 'GET_DESKTOP_SIZE':
	            try:
                        left, top, scrn_w, scrn_h = ninix.pix.get_workarea()
                        result = 'SAORI/1.0 200 OK\r\n' \
                            'Result: %d\r\n' \
                            'Value0: %d\r\n' \
                            'Value1: %d\r\n\r\n' % (scrn_w, scrn_w, scrn_h)
	            except:
                        result = self.RESPONSE[500]
                else:
                    self.enqueue_commands(name, argument[1:])
                    if self.timeout_id is None:
                        self.do_idle_tasks()
                    result = self.RESPONSE[204]
        else:
            result = self.RESPONSE[400]
        return result

    def enqueue_commands(self, command, args):
        #assert command in ['MOVE', 'MOVE_INSIDE', 'MOVETO', 'MOVETO_INSIDE',
        #                   'ZMOVE', 'WAIT', 'NOTIFY',
        #                   'STANDBY', 'STANDBY_INSIDE',
        #                   'CLEAR']
        if args[0] == self.sakura_name: ## FIXME: HWND
            side = 0
        elif args[0] == self.kero_name: ## FIXME: HWND
            side = 1
        else:
            return # XXX
	if command == 'CLEAR':
            self.commands[side] = []
        else:
            if command in ['STANDBY', 'STANDBY_INSIDE']:
                self.commands[0] = []
                self.commands[1] = []
            self.commands[side].append([command, args[1:]])

    def do_idle_tasks(self):
	for side in [0, 1]:
            if self.commands[side]:
	        command, args = self.commands[side].pop(0)
	        if command in ['MOVE', 'MOVE_INSIDE']:
                    x, y = self.__sakura.get_surface_position(side)
	            vx = int(args[0])
	            speed = int(args[1])
	            if command == 'MOVE_INSIDE':
                        w, h = self.__sakura.get_surface_size(side)
                        left, top, scrn_w, scrn_h = ninix.pix.get_workarea()
	                if vx < 0 and x + vx <0:
	                    vx = min(-x, 0)
	                elif vx > 0 and x + vx + w > left + scrn_w:
	                    vx = max(left + scrn_w - w - x, 0)
	            if abs(vx) > speed:
	                if vx > 0:
	                    self.__sakura.set_surface_position(
                                side, x + speed, y)
	                    self.commands[side].insert(
                                0, [command, [str(vx - speed), args[1]]])
	                elif vx < 0:
	                    self.__sakura.set_surface_position(
                                side, x - speed, y)
	                    self.commands[side].insert(
                                0, [command, [str(vx + speed), args[1]]])
	            else:
	                self.__sakura.set_surface_position(side, x + vx, y)
	        elif command in ['MOVETO', 'MOVETO_INSIDE']:
                    x, y = self.__sakura.get_surface_position(side)
	            to = int(args[0])
	            speed = int(args[1])
	            if command == 'MOVETO_INSIDE':
                        w, h = self.__sakura.get_surface_size(side)
                        left, top, scrn_w, scrn_h = ninix.pix.get_workarea()
	                if to < 0:
	                    to = 0
	                elif to > left + scrn_w - w:
	                    to = left + scrn_w - w
	            if abs(to - x) > speed:
	                if to - x > 0:
	                    self.__sakura.set_surface_position(
                                side, x + speed, y)
	                    self.commands[side].insert(0, [command, args])
	                elif to - x < 0:
	                    self.__sakura.set_surface_position(
                                side, x - speed, y)
	                    self.commands[side].insert(0, [command, args])
	            else:
	                self.__sakura.set_surface_position(side, to, y)
	        elif command in ['STANDBY', 'STANDBY_INSIDE']:
	            pass ## FIXME
	        elif command == 'ZMOVE':
	            if args[0] == '1':
	                self.__sakura.raise_surface(side)
	            elif args[0] == '2':
	                self.__sakura.lower_surface(side)
	            else:
	                pass
	        elif command == 'WAIT':
	            try:
	                wait = int(args[0]) # ms
	            except:
	                wait = 0
                    if wait < 25:
	                pass
	            else:
	                self.commands[side].insert(0, ['WAIT', str(wait - 20)])
	        elif command == 'NOTIFY':
                    self.__sakura.notify_event(*args)
        if not self.commands[0] and not self.commands[1]:
	    if self.timeout_id is not None:
                glib.source_remove(self.timeout_id)
                self.timeout_id = None
        else:
	    if self.timeout_id is None:
                self.timeout_id = glib.timeout_add(20, self.do_idle_tasks)
