/* Graph actions.
 */

/* A strict action on the graph.
 */
typedef void (*ActionFn)( Reduce *, 
	int, const char *, HeapNode **, PElement *, void * );

/* A sort of reducer (eg. lazy or strict, or hyperstrict)
 */
typedef void (*ReduceFunction)( Reduce *, PElement * );

#define OPERATOR_NAME( OP ) ( \
	(int) (OP) < noperator_table ? \
		operator_table[(int) (OP)] : "<unknown>" \
)

extern const char *operator_table[];
extern const int noperator_table;

void action_boperror( Reduce *rc, const char *str, 
	int op, const char *name, PElement *a, PElement *b );
void action_proc_dot( Reduce *rc, 
	int op, const char *name, HeapNode **arg, PElement *out );
void action_proc_uop( Reduce *rc, 
	int op, const char *name, HeapNode **arg, PElement *out );
void action_proc_construct( Reduce *rc, 
	Compile *compile, HeapNode **arg, PElement *out );

void action_proc_bop( Reduce *rc, BinOp bop, HeapNode **arg );

void action_dispatch( Reduce *rc, ReduceFunction rfn, 
	int op, const char *name, gboolean override,
	ActionFn afn, int nargs, HeapNode **arg, void *user );
