/* run the display for an image in a workspace 
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG
 */

#define DISPLAY_THUMBNAIL (watch_int_get( "DISPLAY_THUMBNAIL", 64 ))

#include "ip.h"

static ViewClass *parent_class = NULL;

static void
colourview_destroy( GtkObject *object )
{
	Colourview *colourview;

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_COLOURVIEW( object ) );

	colourview = COLOURVIEW( object );

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

static void
colourview_link( View *view, Model *model, View *parent )
{
	Colourview *colourview = COLOURVIEW( view );
	Rowview *rview = ROWVIEW( parent->parent );

	VIEW_CLASS( parent_class )->link( view, model, parent );

	colourview->popup_sid = rowview_menu_attach( rview,
		GTK_WIDGET( colourview->colourdisplay ) );
}

static void 
colourview_refresh( View *view )
{
	Colourview *colourview = COLOURVIEW( view );
	Colourdisplay *colourdisplay = colourview->colourdisplay;
	Imagedisplay *id = IMAGEDISPLAY( colourdisplay );
	Colour *colour = COLOUR( view->model );

#ifdef DEBUG
	printf( "colourview_refresh\n" );
#endif /*DEBUG*/

	conversion_set_image( colourview->conv, colour->ii );
	imagedisplay_set_size( id,
		IM_MAX( id->screen.width, DISPLAY_THUMBNAIL ),
		DISPLAY_THUMBNAIL );
	set_glabel( colourview->label, "%s", buf_all( &colour->caption ) );

	VIEW_CLASS( parent_class )->refresh( view );
}

static void
colourview_class_init( ColourviewClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;
	ViewClass *view_class = (ViewClass *) klass;

	parent_class = gtk_type_class( TYPE_VIEW );

	object_class->destroy = colourview_destroy;

	/* Create signals.
	 */

	/* Init methods.
	 */
	view_class->link = colourview_link;
	view_class->refresh = colourview_refresh;
}

static void
colourview_single_cb( GtkWidget *wid, Colourview *colourview, guint state )
{
	Heapmodel *heapmodel = HEAPMODEL( VIEW( colourview )->model );
	Row *row = heapmodel->row;

	row_select_modifier( row, state );
}

static void
colourview_init( Colourview *colourview )
{
	GtkWidget *eb;

#ifdef DEBUG
	printf( "colourview_init\n" );
#endif /*DEBUG*/

        colourview->popup_sid = 0; 

        colourview->colourdisplay = colourdisplay_new( NULL );
	colourview->conv = IMAGEDISPLAY( colourview->colourdisplay )->conv;
        gtk_box_pack_start( GTK_BOX( colourview ), 
		GTK_WIDGET( colourview->colourdisplay ), FALSE, FALSE, 0 );

        eb = gtk_event_box_new();
        gtk_box_pack_start( GTK_BOX( colourview ), eb, FALSE, FALSE, 0 );
	colourview->label = gtk_label_new( "" );
        gtk_misc_set_alignment( GTK_MISC( colourview->label ), 0, 0.5 );
        gtk_misc_set_padding( GTK_MISC( colourview->label ), 2, 0 );
        gtk_container_add( GTK_CONTAINER( eb ), colourview->label );
	set_name( eb, "caption_widget" );

        doubleclick_add( GTK_WIDGET( colourview->colourdisplay ), FALSE,
                colourview_single_cb, colourview, 
		NULL, NULL );

        gtk_widget_show_all( GTK_WIDGET( colourview ) );
}

GtkType
colourview_get_type( void )
{
	static GtkType colourview_type = 0;

	if( !colourview_type ) {
		static const GtkTypeInfo info = {
			"Colourview",
			sizeof( Colourview ),
			sizeof( ColourviewClass ),
			(GtkClassInitFunc) colourview_class_init,
			(GtkObjectInitFunc) colourview_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		colourview_type = gtk_type_unique( TYPE_VIEW, &info );
	}

	return( colourview_type );
}

View *
colourview_new( void )
{
	Colourview *colourview = gtk_type_new( TYPE_COLOURVIEW );

	return( VIEW( colourview ) );
}
