/* Perform immediate mode commands.
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

*/

#include "ip.h"

/* Load a set of command line args as definitions. Make an argv column for
 * them.
 */
gboolean
load_arg_list( char **argv, int n )
{	
	int i;

	/* Loop for each arg.
	 */
	for( i = 0; i < n; i++ ) {
		char txt[MAX_STRSIZE];
		BufInfo buf;

		buf_init_static( &buf, txt, MAX_STRSIZE );
		buf_appendf( &buf, "arg%d = %s;", i+1, argv[i] );
		attach_input_string( buf_all( &buf ) );
		if( parse_onedef( NULL, -1 ) ) 
			return( FALSE );
	}

	return( TRUE );
}
