/* display an image in a window ... watching an Image model.
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG
 */

#include "ip.h"

static GtkEventBoxClass *parent_class = NULL;

static void
conversionview_destroy( GtkObject *object )
{
	Conversionview *cv;

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_CONVERSIONVIEW( object ) );

	cv = CONVERSIONVIEW( object );

	/* My instance destroy stuff.
	 */
	FREESID( cv->changed_sid, cv->conv );
	FREESID( cv->destroy_sid, cv->conv );

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

/* Find max and min of visible area of image.
 */
static gboolean
conversionview_findmaxmin( Conversion *conv, double *min, double *max )
{
	int x1, y1;
	int x2, y2;
	Rect a, b;

	/* Turn display to image.
	 */
	conversion_disp_to_im( conv, 
		conv->visible.left, conv->visible.top, &x1, &y1 );
	conversion_disp_to_im( conv, 
		IM_RECT_RIGHT( &conv->visible ), 
		IM_RECT_BOTTOM( &conv->visible ), &x2, &y2 );

	/* Clip against image.
	 */
	a.left = x1;
	a.top = y1;
	a.width = x2 - x1;
	a.height = y2 - y1;
	im_rect_intersectrect( &a, &conv->image, &b );
	if( findmaxmin( imageinfo_get( FALSE, conv->ii ), 
		a.left, a.top, a.width, a.height, min, max ) ) {
		verrors( "unable to find max/min" );
		return( FALSE );
	}

	return( TRUE );
}

static void
conversionview_scale_cb( GtkWidget *wid, Conversionview *cv )
{
	double min, max;

	set_hourglass();
	if( !conversionview_findmaxmin( cv->conv, &min, &max ) ) {
		set_pointer();
		box_alert( wid );
		return;
	}
	set_pointer();

	cv->conv->scale = 255.0 / (max - min);
	cv->conv->offset = -(min * cv->conv->scale);
	conversion_refresh( cv->conv );
}

static void
conversionview_falsecolour_cb( GtkWidget *wid, Conversionview *cv )
{
	GtkCheckMenuItem *item = GTK_CHECK_MENU_ITEM( wid );

	cv->conv->falsecolour = item->active;
	conversion_refresh( cv->conv );
}

static void
conversionview_interpret_cb( GtkWidget *wid, Conversionview *cv )
{
	GtkCheckMenuItem *item = GTK_CHECK_MENU_ITEM( wid );

	cv->conv->type = item->active;
	conversion_refresh( cv->conv );
}

static void
conversionview_reset_cb( GtkWidget *wid, Conversionview *cv )
{
	cv->conv->scale = 1.0;
	cv->conv->offset = 0.0;
	cv->conv->falsecolour = FALSE;
	cv->conv->type = TRUE;
	conversion_refresh( cv->conv );
}

static void
conversionview_hide_cb( GtkWidget *wid, Conversionview *cv )
{
	cv->conv->enabled = FALSE;
	conversion_refresh( cv->conv );
}

static void
conversionview_class_init( ConversionviewClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;

	parent_class = gtk_type_class( GTK_TYPE_FRAME );

	object_class->destroy = conversionview_destroy;

	/* Create signals.
	 */

	/* Init methods.
	 */

}

/* Value changed in scale adjustment.
 */
static void
conversionview_scale_change_cb( Tslider *tslider, Conversionview *cv )
{
	if( cv->conv->scale != tslider->value ) { 
		cv->conv->scale = tslider->value; 
		conversion_refresh( cv->conv );
	}
}

/* Value changed in offset adjustment.
 */
static void
conversionview_offset_change_cb( Tslider *tslider, Conversionview *cv )
{
	if( cv->conv->offset != tslider->value ) { 
		cv->conv->offset = tslider->value; 
		conversion_refresh( cv->conv );
	}
}

static void
conversionview_init( Conversionview *cv )
{
	GtkWidget *but;
	GtkWidget *arrow;
	GtkWidget *hb;
	GtkWidget *sep;
	GtkWidget *mb;

	GtkWidget *pane;

	cv->conv = NULL;

	cv->changed_sid = 0;
	cv->destroy_sid = 0;

        gtk_frame_set_shadow_type( GTK_FRAME( cv ), GTK_SHADOW_OUT );

	hb = gtk_hbox_new( FALSE, 2 );
        gtk_container_set_border_width( GTK_CONTAINER( hb ), 2 );
        gtk_container_add( GTK_CONTAINER( cv ), hb );

        /* Build menu. One for each window, as we need to track falsecolour
	 * etc. toggles. Could just have one, and modify pre-popup, but this
	 * is easier.
         */
	pane = menu_build( "Convert menu" );
	menu_add_but( pane, "Scale", conversionview_scale_cb, cv );
	cv->falsecolour = menu_add_tog( pane, 
		"False colour", conversionview_falsecolour_cb, cv );
	cv->type = menu_add_tog( pane, 
		"Interpret", conversionview_interpret_cb, cv );
	menu_add_but( pane, "Reset", conversionview_reset_cb, cv );
	menu_add_sep( pane );
	menu_add_but( pane, "Hide", conversionview_hide_cb, cv );

        arrow = gtk_arrow_new( GTK_ARROW_RIGHT, GTK_SHADOW_OUT );
	but = gtk_menu_item_new();
        gtk_container_add( GTK_CONTAINER( but ), arrow );
	gtk_menu_item_set_submenu( GTK_MENU_ITEM( but ), pane );
	mb = gtk_menu_bar_new();
	gtk_menu_bar_set_shadow_type( GTK_MENU_BAR( mb ), GTK_SHADOW_NONE );
	gtk_menu_bar_append( GTK_MENU_BAR( mb ), but );
        gtk_box_pack_start( GTK_BOX( hb ), mb, FALSE, FALSE, 0 );

	cv->scale = tslider_new();
	tslider_set_conversions( cv->scale, 
		tslider_log_value_to_slider, tslider_log_slider_to_value );
	cv->scale->from = 0.001;
	cv->scale->to = 255.0;
	cv->scale->value = 1.0;
	cv->scale->svalue = 128;
	cv->scale->digits = 5;
	tslider_changed( cv->scale );
        gtk_box_pack_start( GTK_BOX( hb ), 
		GTK_WIDGET( cv->scale ), TRUE, TRUE, 0 );
        gtk_signal_connect( GTK_OBJECT( cv->scale ), "changed", 
		GTK_SIGNAL_FUNC( conversionview_scale_change_cb ), cv );

	sep = gtk_vseparator_new();
        gtk_box_pack_start( GTK_BOX( hb ), sep, FALSE, FALSE, 0 );

	cv->offset = tslider_new();
	cv->offset->from = -128;
	cv->offset->to = 128;
	cv->offset->value = 0;
	cv->offset->svalue = 0;
	cv->offset->digits = 1;
	tslider_changed( cv->offset );
        gtk_box_pack_start( GTK_BOX( hb ), 
		GTK_WIDGET( cv->offset ), TRUE, TRUE, 0 );
        gtk_signal_connect( GTK_OBJECT( cv->offset ), "changed", 
		GTK_SIGNAL_FUNC( conversionview_offset_change_cb ), cv );

	gtk_widget_show_all( hb );
}

GtkType
conversionview_get_type( void )
{
	static GtkType conversionview_type = 0;

	if( !conversionview_type ) {
		static const GtkTypeInfo sinfo = {
			"Conversionview",
			sizeof( Conversionview ),
			sizeof( ConversionviewClass ),
			(GtkClassInitFunc) conversionview_class_init,
			(GtkObjectInitFunc) conversionview_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		conversionview_type = 
			gtk_type_unique( GTK_TYPE_FRAME, &sinfo );
	}

	return( conversionview_type );
}

/* Our conversion has changed ... update.
 */
static void
conversionview_changed_cb( Conversion *conv, Conversionview *cv )
{
	GtkCheckMenuItem *item;

	if( cv->scale->value != cv->conv->scale ) {
		cv->scale->value = cv->conv->scale;
		tslider_changed( cv->scale );
	}

	if( cv->offset->value != cv->conv->offset ) {
		cv->offset->value = cv->conv->offset;
		tslider_changed( cv->offset );
	}

	item = GTK_CHECK_MENU_ITEM( cv->falsecolour );
	if( item->active != conv->falsecolour ) 
		gtk_check_menu_item_set_active( item, conv->falsecolour );

	item = GTK_CHECK_MENU_ITEM( cv->type );
	if( item->active != conv->type ) 
		gtk_check_menu_item_set_active( item, conv->type );

	widget_visible( GTK_WIDGET( cv ), conv->enabled );
}

/* Our conversion has been destroyed ... destroy us in turn.
 */
static void
conversionview_destroy_cb( Conversion *conv, Conversionview *cv )
{
	gtk_widget_destroy( GTK_WIDGET( cv ) );
}

static void
conversionview_link( Conversionview *cv, Conversion *conv )
{
	assert( !cv->conv );

	cv->conv = conv;

	cv->changed_sid = gtk_signal_connect( GTK_OBJECT( cv->conv ), 
		"changed", GTK_SIGNAL_FUNC( conversionview_changed_cb ), cv );
	cv->destroy_sid = gtk_signal_connect( GTK_OBJECT( cv->conv ), 
		"destroy", GTK_SIGNAL_FUNC( conversionview_destroy_cb ), cv );
}

Conversionview *
conversionview_new( Conversion *conv )
{
	Conversionview *cv = gtk_type_new( TYPE_CONVERSIONVIEW );

	conversionview_link( cv, conv );

	return( cv );
}
