/* a ip image class in a workspace
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/* Default image file type.
 */
#define IMAGE_FILE_TYPE (watch_int_get( "IMAGE_FILE_TYPE", 0 ))

#define TYPE_IIMAGE (iimage_get_type())
#define IIMAGE( obj ) (GTK_CHECK_CAST( (obj), TYPE_IIMAGE, Iimage ))
#define IIMAGE_CLASS( klass ) \
	(GTK_CHECK_CLASS_CAST( (klass), TYPE_IIMAGE, IimageClass ))
#define IS_IIMAGE( obj ) (GTK_CHECK_TYPE( (obj), TYPE_IIMAGE ))
#define IS_IIMAGE_CLASS( klass ) \
	(GTK_CHECK_CLASS_TYPE( (klass), TYPE_IIMAGE ))

/* Our instance vars ... packaged up for code sharing.
 */
typedef struct {
        Imageinfo *image;
} IimageInstance;

struct _Iimage {
	Classmodel parent_class;

	/* Class fields.
	 */
	IimageInstance instance;

	/* Build view caption here.
	 */
	BufInfo caption;

	/* List of classmodel which have displays on us.
	 */
	GSList *classmodels;	

	/* List of popup imageview windows we've made. 
	 */
	GSList *views;

	/* Track display pos/size/etc. here.
	 */
	int window_x, window_y;		/* Last window position at quit */
	int window_width, window_height;
	int image_left, image_top;	/* Scroll position */
	int image_mag;			/* Scale */

	/* View attachments.
	 */
	gboolean show_status;
	gboolean show_paintbox;
	gboolean show_convert;
	gboolean show_rulers;	
	
	/* Bar settings.
	 */
	double scale, offset;
};

typedef struct _IimageClass {
	ClassmodelClass parent_class;

	/* My methods.
	 */
} IimageClass;

GtkType iimage_get_type( void );
gboolean iimage_replace( Iimage *iimage, const char *filename );
Classmodel *iimage_new( Rhs *rhs );
