/* run the display for an image in a workspace 
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG
 */

#define DISPLAY_THUMBNAIL (watch_int_get( "DISPLAY_THUMBNAIL", 64 ))

#include "ip.h"

static ViewClass *parent_class = NULL;

static void
iimageview_destroy( GtkObject *object )
{
	Iimageview *iimageview;

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_IIMAGEVIEW( object ) );

	iimageview = IIMAGEVIEW( object );

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

/* Not the same as model->edit :-( if this is a region, don't pop the region
 * edit box, pop a viewer on the image.
 */
static void
iimageview_edit( GtkWidget *parent, Iimageview *iimageview )
{
	Iimage *iimage = IIMAGE( VIEW( iimageview )->model );

	if( IS_IREGION( iimage ) && iimage->instance.image ) {
		Imageview *iv;

		iv = imageview_new( iimage );
		gtk_widget_show( GTK_WIDGET( iv ) );
	}
	else
		model_edit( parent, MODEL( iimage ) );
}

static void
iimageview_link( View *view, Model *model, View *parent )
{
	Iimageview *iimageview = IIMAGEVIEW( view );
	Rowview *rview = ROWVIEW( parent->parent );
	Row *row = ROW( VIEW( rview )->model );

	VIEW_CLASS( parent_class )->link( view, model, parent );

	iimageview->popup_sid = rowview_menu_attach( rview,
		GTK_WIDGET( iimageview->id ) );
	
	if( row->popup && row->top_row == row ) {
		row->popup = FALSE;
		iimageview_edit( GTK_WIDGET( view ), iimageview );
	}
}

static void 
iimageview_refresh( View *view )
{
	Iimageview *iimageview = IIMAGEVIEW( view );
	Iimage *iimage = IIMAGE( view->model );

#ifdef DEBUG
	printf( "iimageview_refresh\n" );
#endif /*DEBUG*/

	conversion_set_image( iimageview->conv, iimage->instance.image );
	imagedisplay_set_size( iimageview->id, 
		IM_MAX( iimageview->id->screen.width, DISPLAY_THUMBNAIL ),
		DISPLAY_THUMBNAIL );
	imagedisplay_repaint_all( iimageview->id );

	set_glabel( iimageview->label, "%s", buf_all( &iimage->caption ) );

	VIEW_CLASS( parent_class )->refresh( view );
}

static void
iimageview_class_init( IimageviewClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;
	ViewClass *view_class = (ViewClass *) klass;

	parent_class = gtk_type_class( TYPE_VIEW );

	object_class->destroy = iimageview_destroy;

	/* Create signals.
	 */

	/* Init methods.
	 */
	view_class->link = iimageview_link;
	view_class->refresh = iimageview_refresh;
}

static void
iimageview_single_cb( GtkWidget *wid, Iimageview *iimageview, guint state )
{
	Heapmodel *heapmodel = HEAPMODEL( VIEW( iimageview )->model );
	Row *row = heapmodel->row;

	row_select_modifier( row, state );
}

static void
iimageview_double_cb( GtkWidget *wid, Iimageview *iimageview, guint state )
{
	iimageview_edit( wid, iimageview );
}

static gint
iimageview_configure( GtkWidget *widget, GdkEventConfigure *event, 
	Iimageview *iimageview )
{
	/* Recalculate shrink-to-fit for thumbnail.
	 */
	imagedisplay_set_mag( iimageview->id, 0 );

	return( TRUE );
}

static gboolean
iimageview_filedrop( Iimageview *iimageview, const char *file )
{
	Iimage *iimage = IIMAGE( VIEW( iimageview )->model );
	gboolean result;

	result = iimage_replace( iimage, file );
	if( result )
		symbol_recalculate_all();

	return( result );
}

static void
iimageview_init( Iimageview *iimageview )
{
	GtkWidget *eb;

#ifdef DEBUG
	printf( "iimageview_init\n" );
#endif /*DEBUG*/

        iimageview->popup_sid = 0; 

	iimageview->conv = conversion_new( NULL );
        iimageview->id = imagedisplay_new( iimageview->conv, NULL, NULL );
        gtk_signal_connect_after( GTK_OBJECT( iimageview->id ), 
		"configure_event",
                GTK_SIGNAL_FUNC( iimageview_configure ), iimageview );
        iimageview->id->sheight = 1;
	GTK_WIDGET_UNSET_FLAGS( GTK_WIDGET( iimageview->id ), GTK_CAN_FOCUS );
        gtk_box_pack_start( GTK_BOX( iimageview ), 
		GTK_WIDGET( iimageview->id ), FALSE, FALSE, 0 );
        set_tooltip( GTK_WIDGET( iimageview->id ), 
		"Double-click to open a viewer on this thumbnail" );

        eb = gtk_event_box_new();
        gtk_box_pack_start( GTK_BOX( iimageview ), eb, FALSE, FALSE, 0 );
	iimageview->label = gtk_label_new( "" );
        gtk_misc_set_alignment( GTK_MISC( iimageview->label ), 0, 0.5 );
        gtk_misc_set_padding( GTK_MISC( iimageview->label ), 2, 0 );
        gtk_container_add( GTK_CONTAINER( eb ), iimageview->label );
	set_name( eb, "caption_widget" );

        doubleclick_add( GTK_WIDGET( iimageview->id ), FALSE,
                iimageview_single_cb, iimageview, 
		iimageview_double_cb, iimageview );

	/* Set as file drop destination 
	 */
	filedrop_register( GTK_WIDGET( iimageview ), 
		(FiledropFunc) iimageview_filedrop, iimageview );

        gtk_widget_show_all( GTK_WIDGET( iimageview ) );
}

GtkType
iimageview_get_type( void )
{
	static GtkType iimageview_type = 0;

	if( !iimageview_type ) {
		static const GtkTypeInfo info = {
			"Iimageview",
			sizeof( Iimageview ),
			sizeof( IimageviewClass ),
			(GtkClassInitFunc) iimageview_class_init,
			(GtkObjectInitFunc) iimageview_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		iimageview_type = gtk_type_unique( TYPE_VIEW, &info );
	}

	return( iimageview_type );
}

View *
iimageview_new( void )
{
	Iimageview *iimageview = gtk_type_new( TYPE_IIMAGEVIEW );

	return( VIEW( iimageview ) );
}
