/* base model for a client regions on an imageview
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG
 */

#include "ip.h"

static ClassmodelClass *parent_class = NULL;

static void
iregiongroup_destroy( GtkObject *object )
{
	Iregiongroup *iregiongroup;

#ifdef DEBUG
	printf( "iregiongroup_destroy\n" );
#endif /*DEBUG*/

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_IREGIONGROUP( object ) );

	iregiongroup = IREGIONGROUP( object );

	/* My instance destroy stuff.
	 */

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

static void *
iregiongroup_update_model( Heapmodel *heapmodel )
{
#ifdef DEBUG
	printf( "iregiongroup_update_model: " );
	row_name_print( heapmodel->row );
	printf( "\n" );
#endif /*DEBUG*/

	if( HEAPMODEL_CLASS( parent_class )->update_model( heapmodel ) )
		return( heapmodel );

	/* Only display most-derived classes. Don't display "this".
	 */
	if( heapmodel->row->sym )
		model_set_display( MODEL( heapmodel ),
			!is_super( heapmodel->row->sym ) &&
			!is_this( heapmodel->row->sym ) );

	return( NULL );
}

static void
iregiongroup_class_init( IregiongroupClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;
	ModelClass *model_class = (ModelClass *) klass;
	HeapmodelClass *heapmodel_class = (HeapmodelClass *) klass;

	parent_class = gtk_type_class( TYPE_CLASSMODEL );

	/* Create signals.
	 */

	/* Init methods.
	 */
	object_class->destroy = iregiongroup_destroy;

	heapmodel_class->update_model = iregiongroup_update_model;

	model_class->view_new = iregiongroupview_new;
}

static void
iregiongroup_init( Iregiongroup *iregiongroup )
{
	/* Display turned on in _update_model() above.
	 */
	MODEL( iregiongroup )->display = FALSE;
}

GtkType
iregiongroup_get_type( void )
{
	static GtkType iregiongroup_type = 0;

	if( !iregiongroup_type ) {
		static const GtkTypeInfo info = {
			"Iregiongroup",
			sizeof( Iregiongroup ),
			sizeof( IregiongroupClass ),
			(GtkClassInitFunc) iregiongroup_class_init,
			(GtkObjectInitFunc) iregiongroup_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		iregiongroup_type = gtk_type_unique( TYPE_CLASSMODEL, &info );
	}

	return( iregiongroup_type );
}

Iregiongroup *
iregiongroup_new( Classmodel *classmodel )
{
	Iregiongroup *iregiongroup = gtk_type_new( TYPE_IREGIONGROUP );

	model_child_add( MODEL( classmodel ), MODEL( iregiongroup ), -1 );

#ifdef DEBUG
	printf( "iregiongroup_new: " );
	row_name_print( HEAPMODEL( classmodel )->row );
	printf( "\n" );
#endif /*DEBUG*/

	return( iregiongroup );
}
