/* a view of a text thingy
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/* 
#define DEBUG
 */

#include "ip.h"

static ViewClass *parent_class = NULL;

static void
itextview_destroy( GtkObject *object )
{
	iTextview *itextview;
	iText *text;
	Row *row;

#ifdef DEBUG
	printf( "itextview_destroy\n" );
#endif /*DEBUG*/

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_ITEXTVIEW( object ) );

	/* My instance destroy stuff.
	 */
	itextview = ITEXTVIEW( object );
	text = ITEXT( VIEW( itextview )->model );
	row = HEAPMODEL( text )->row;

	FREESID( itextview->reset_sid, row->top_col );

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

/* Detect cancel in a text field.
 */
static gboolean
itextview_event_cb( GtkWidget *widget, GdkEvent *ev, iTextview *itextview )
{
        View *view = VIEW( itextview );
	iText *text = ITEXT( view->model );

        if( ev->key.keyval != GDK_Escape )
                return( FALSE );

        set_gentry( itextview->wtext, "%s", text->formula );
        view_reset( view );

        return( TRUE );
}

static void
itextview_scan_sub( iTextview *itextview )
{
	iText *itext = ITEXT( VIEW( itextview )->model );

	char *str;

	/* Should be in edit mode.
	 */
	if( !itextview->edit || !itextview->wtext ) 
		return;

	/* Should be displaying edit.
	 */
	if( !GTK_WIDGET_VISIBLE( itextview->wtext ) )
		return;

	/* There should be some edited text.
	 */
	str = gtk_entry_get_text( GTK_ENTRY( itextview->wtext ) );
	if( !str || strspn( str, " \t\b\n" ) == strlen( str ) ) 
		/* Just whitespace ... ignore it.
		 */
		return;

	/* Attach to the model, and mark for update.
	 */
	itext_set_formula( itext, str );

	/* No longer a default value ... mark for save.
	 */
	itext_set_edited( itext, TRUE );
}

/* Re-read the text in a tally entry. 
 */
static void *
itextview_scan( View *view )
{
	iTextview *itextview = ITEXTVIEW( view );

#ifdef DEBUG
	iText *text = ITEXT( view->model );
	Row *row = HEAPMODEL( text )->row;

	printf( "itextview_scan: " );
	row_name_print( row );
	printf( "\n" );
#endif /*DEBUG*/

	itextview_scan_sub( itextview );

	return( VIEW_CLASS( parent_class )->scan( view ) );
}

void
itextview_activate_cb( GtkWidget *wid, iTextview *itextview )
{
	iText *text = ITEXT( VIEW( itextview )->model );
	Row *row = HEAPMODEL( text )->row;

	/* Reset edits on this row and all children.
	 */
	(void) model_map_all( MODEL( row ),
		(model_map_fn) heapmodel_clear_edited, NULL );

	/* Make sure we scan this text, even if it's not been edited.
	 */
	view_scannable_register( VIEW( itextview ) );

	workspace_set_modified( row->sym );

	symbol_recalculate_all();
}

/* Add an edit box.
 */
static void
itextview_add_edit( iTextview *itextview )
{
        if( itextview->wtext )
                return;

        itextview->wtext = gtk_entry_new();
	gtk_table_attach_defaults( GTK_TABLE( itextview->wtable ), 
		itextview->wtext, 1, 2, 0, 1 );
        set_tooltip( itextview->wtext, "Press Escape to cancel edit, "
                "press Return to accept edit and recalculate" );
        gtk_signal_connect_object( GTK_OBJECT( itextview->wtext ), "changed",
                GTK_SIGNAL_FUNC( view_changed_cb ), GTK_OBJECT( itextview ) );
        gtk_signal_connect( GTK_OBJECT( itextview->wtext ), "activate",
                GTK_SIGNAL_FUNC( itextview_activate_cb ), itextview );
        gtk_signal_connect( GTK_OBJECT( itextview->wtext ), "event",
                GTK_SIGNAL_FUNC( itextview_event_cb ), itextview );
}

static void 
itextview_refresh( View *view )
{
	iTextview *itextview = ITEXTVIEW( view );
	iText *text = ITEXT( view->model );
	Row *row = HEAPMODEL( text )->row;

#ifdef DEBUG
	printf( "itextview_refresh: " );
	row_name_print( row );
	printf( " (0x%x)\n", (unsigned int) view );
#endif /*DEBUG*/

	/* Set edit mode.
	 */
	if( itextview->edit ) {
		itextview_add_edit( itextview );
                gtk_widget_show( itextview->wtext );
                gtk_widget_hide( itextview->wlframe );
	}
	else {
                gtk_widget_show( itextview->wlframe );
                FREEF( gtk_widget_destroy, itextview->wtext );
	}

	if( itextview->wtext ) {
		/* Make sure we don't trigger "changed" when we zap in next
		 * text.
		 */
		gtk_signal_handler_block_by_data( 
			GTK_OBJECT( itextview->wtext ), itextview );
		set_gentry( itextview->wtext, "%s", text->formula );
		gtk_signal_handler_unblock_by_data( 
			GTK_OBJECT( itextview->wtext ), itextview );
	}

	if( !row->err ) {
		/* Can come here without text during load.
		 */
		if( text->value.base )
			set_glabel( itextview->wlabel, 
				"%s", buf_all( &text->value ) );
	}
	else {
		char buf[256];

		extract_first_line( buf, row->expr->errstr, 256 );
		set_glabel( itextview->wlabel, "%s", buf );
	}

	VIEW_CLASS( parent_class )->refresh( view );
}

/* Change edit mode.
 */
static void 
itextview_set_edit( iTextview *itextview, gboolean state )
{
	iText *text = ITEXT( VIEW( itextview )->model );

	if( itextview->edit != state ) {
		itextview->edit = state;

		if( state ) {
			view_resettable_register( VIEW( itextview ) );

			/* Make sure we have a formula in the text.
			 */
			if( !text->formula )
				heapmodel_update_model( HEAPMODEL( text ) );
		}
	}

	view_refresh( VIEW( itextview ) );
}

/* Reset edit mode ... go back to whatever is set for this column.
 */
static void 
itextview_reset( View *view )
{
	iText *text = ITEXT( view->model );
	Row *row = HEAPMODEL( text )->row;
	Column *col = row->top_col;

	itextview_set_edit( ITEXTVIEW( view ), col->sform );
}

/* Event in a tally label.
 */     
static gboolean
itextview_event( View *view, GdkEvent *ev )
{
	iTextview *itextview = ITEXTVIEW( view );

        if( ev->type != GDK_BUTTON_PRESS || ev->button.button != 1 )
                return( FALSE );
	if( itextview->edit == TRUE )
		return( FALSE );

        /* Pop to edit mode.
         */
        itextview_set_edit( itextview, TRUE );

	/* Grab the focus, select the text.
	 */
        if( itextview->wtext ) {
                gtk_editable_select_region( 
			GTK_EDITABLE( itextview->wtext ), 0, -1 );
                gtk_widget_grab_focus( itextview->wtext );
        }

	return( TRUE );
}       

static void
itextview_link( View *view, Model *model, View *parent )
{
	iTextview *itextview = ITEXTVIEW( view );
	iText *text = ITEXT( model );
	Row *row = HEAPMODEL( text )->row;

#ifdef DEBUG
	printf( "itextview_link: " );
	row_name_print( row );
	printf( "\n" );
#endif /*DEBUG*/

        itextview->reset_sid = gtk_signal_connect_object( 
		GTK_OBJECT( row->top_col ), "reset",
                GTK_SIGNAL_FUNC( view_reset ), GTK_OBJECT( itextview ) );

	VIEW_CLASS( parent_class )->link( view, model, parent );

	/* Edit mode defaults to edit mode for column.
	 */
        itextview_set_edit( itextview, row->top_col->sform );
}

static void
itextview_class_init( iTextviewClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;
	ViewClass *view_class = (ViewClass *) klass;

	parent_class = gtk_type_class( TYPE_VIEW );

	object_class->destroy = itextview_destroy;

	/* Create signals.
	 */

	/* Init methods.
	 */
	view_class->reset = itextview_reset;
	view_class->scan = itextview_scan;
	view_class->refresh = itextview_refresh;
	view_class->event = itextview_event;
	view_class->link = itextview_link;
}

static void
itextview_init( iTextview *itextview )
{
	itextview->wtext = NULL;
	itextview->wlabel = NULL;
	itextview->edit = FALSE;
	itextview->reset_sid = 0;

        itextview->wlabel = gtk_label_new( "" );
	gtk_label_set_justify( GTK_LABEL( itextview->wlabel ), 
		GTK_JUSTIFY_LEFT );
        gtk_misc_set_alignment( GTK_MISC( itextview->wlabel ), 0, 0.5 );
        gtk_misc_set_padding( GTK_MISC( itextview->wlabel ), 1, 0 );

        itextview->wlframe = gtk_frame_new( NULL );
        gtk_frame_set_shadow_type( GTK_FRAME( itextview->wlframe ), 
		GTK_SHADOW_NONE );
        gtk_container_set_border_width( GTK_CONTAINER( itextview->wlframe ), 
		1 );
        set_tooltip( itextview->wlabel, "Value display\n"
                "Left-click to edit expression" );

        gtk_container_add( GTK_CONTAINER( itextview->wlframe ), 
		itextview->wlabel );

	itextview->wtable = gtk_table_new( 2, 1, FALSE );
	gtk_table_attach_defaults( GTK_TABLE( itextview->wtable ), 
		itextview->wlframe, 1, 2, 0, 1 );
        gtk_box_pack_start( GTK_BOX( itextview ), 
		itextview->wtable, TRUE, FALSE, 0 );

        gtk_widget_show_all( GTK_WIDGET( itextview->wtable ) );
}

GtkType
itextview_get_type( void )
{
	static GtkType itextview_type = 0;

	if( !itextview_type ) {
		static const GtkTypeInfo itextview_info = {
			"iTextview",
			sizeof( iTextview ),
			sizeof( iTextviewClass ),
			(GtkClassInitFunc) itextview_class_init,
			(GtkObjectInitFunc) itextview_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		itextview_type = gtk_type_unique( TYPE_VIEW, &itextview_info );
	}

	return( itextview_type );
}

View *
itextview_new( void )
{
	iTextview *itextview = gtk_type_new( TYPE_ITEXTVIEW );

	return( VIEW( itextview ) );
}
