/* an image class object in a workspace
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG
 */

#include "ip.h"

static ClassmodelClass *parent_class = NULL;

static void
real_destroy( GtkObject *object )
{
	Real *real;

#ifdef DEBUG
	printf( "real_destroy\n" );
#endif /*DEBUG*/

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_REAL( object ) );

	real = REAL( object );

	/* My instance destroy stuff.
	 */
	buf_destroy( &real->caption );

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

/* Refresh the caption.
 */
static void
real_refresh( Real *real )
{
	buf_rewind( &real->caption );
	buf_appendf( &real->caption, CLASS_REAL " %g", real->value );
}

/* Update Real from heap.
 */
static gboolean
real_class_get( Classmodel *classmodel, PElement *root )
{
        Real *real = REAL( classmodel );
	double value;

#ifdef DEBUG
	printf( "real_class_get: " );
	row_name_print( HEAPMODEL( real )->row );
	printf( "\n" );
#endif /*DEBUG*/

	if( !class_get_member_real( root, MEMBER_VALUE, &value ) )
		return( FALSE );
	real->value = value;

	real_refresh( real );

	return( CLASSMODEL_CLASS( parent_class )->class_get( 
		classmodel, root ) );
}

/* Make a new "fn value" application.
 */
static gboolean
real_class_new( Classmodel *classmodel, PElement *fn, PElement *out )
{
	Heap *hi = reduce_context->hi;
	Real *real = REAL( classmodel );
	PElement rhs;

#ifdef DEBUG
	printf( "real_class_new: " );
	row_name_print( HEAPMODEL( real )->row );
	printf( "\n" );
#endif /*DEBUG*/

	/* Make application nodes.
	 */
	heap_appl_init( out, fn );
	if( !heap_appl_add( hi, out, &rhs ) ||
		!heap_real_new( hi, real->value, &rhs ) )
		return( FALSE );

	return( TRUE );
}

static void
real_class_init( RealClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;
	ModelClass *model_class = (ModelClass *) klass;
	ClassmodelClass *classmodel_class = (ClassmodelClass *) klass;

	parent_class = gtk_type_class( TYPE_CLASSMODEL );

	object_class->destroy = real_destroy;

	/* Create signals.
	 */

	/* Init methods.
	 */
	model_class->view_new = realview_new;

	classmodel_class->class_get = real_class_get;
	classmodel_class->class_new = real_class_new;

	/* Static init.
	 */
	model_register_loadable( MODEL_CLASS( klass ) );
}

static void
real_init( Real *real )
{
	real->value = 0.0;
	buf_init_dynamic( &real->caption, MAX_LINELENGTH );

	model_set( MODEL( real ), CLASS_REAL, NULL );
}

GtkType
real_get_type( void )
{
	static GtkType real_type = 0;

	if( !real_type ) {
		static const GtkTypeInfo info = {
			"Real",
			sizeof( Real ),
			sizeof( RealClass ),
			(GtkClassInitFunc) real_class_init,
			(GtkObjectInitFunc) real_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		real_type = gtk_type_unique( TYPE_CLASSMODEL, &info );
	}

	return( real_type );
}

Classmodel *
real_new( Rhs *rhs )
{
	Real *real = gtk_type_new( TYPE_REAL );

	model_child_add( MODEL( rhs ), MODEL( real ), -1 );

	return( CLASSMODEL( real ) );
}
