/* the rhs of a tallyrow ... group together everything to the right of the
 * button
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#include "ip.h"

/* 
#define DEBUG
 */

static HeapmodelClass *parent_class = NULL;

static void
rhs_destroy( GtkObject *object )
{
	Rhs *rhs;

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_RHS( object ) );

	rhs = RHS( object );

	/* My instance destroy stuff.
	 */

#ifdef DEBUG
	printf( "rhs_destroy: " );
	row_name_print( HEAPMODEL( rhs )->row );
	printf( " (0x%x)\n", (unsigned int) rhs );
#endif /*DEBUG*/

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

/* child is about to be added ... update our graphic/scol/text shortcuts.
 */
static void
rhs_child_add( Model *parent, Model *child, int pos )
{
	Rhs *rhs = RHS( parent );

	if( IS_SUBCOLUMN( child ) ) {
		FREEO( rhs->scol );
		rhs->scol = child;
	}
	else if( IS_ITEXT( child ) ) {
		FREEO( rhs->itext );
		rhs->itext = child;
	}
	else {
		FREEO( rhs->graphic );
		rhs->graphic = child;
	}

	MODEL_CLASS( parent_class )->child_add( parent, child, pos );
}

static void
rhs_parent_add( Model *child, Model *parent )
{
	assert( IS_ROW( parent ) );

	MODEL_CLASS( parent_class )->parent_add( child, parent );
}

static gboolean
rhs_load( Model *model, 
	ModelLoadState *state, Model *parent, xmlNode *xnode )
{
	Rhs *rhs = RHS( model );

	if( !IS_ROW( parent ) ) {
		ierrors( "rhs_load: can only add a rhs to a row" );
		return( FALSE );
	}

	/* Hmm. Is this guaranteed?
	 */
	assert( sizeof( RhsFlags ) == sizeof( int ) );

	if( !get_iprop( xnode, "vislevel", &rhs->vislevel ) ||
		!get_iprop( xnode, "flags", (int *) &rhs->flags ) )
		return( FALSE );

	if( !MODEL_CLASS( parent_class )->load( model, state, parent, xnode ) )
		return( FALSE );

	return( TRUE );
}

static xmlNode *
rhs_save( Model *model, xmlNode *xnode )
{
	Rhs *rhs = RHS( model );

	xmlNode *xthis;

	if( !(xthis = MODEL_CLASS( parent_class )->save( model, xnode )) )
		return( NULL );

	if( !set_prop( xthis, "vislevel", "%d", rhs->vislevel ) ||
		!set_prop( xthis, "flags", "%d", rhs->flags ) )
		return( NULL );

	return( xthis );
}

/* How to spot and make a graphic display.
 */
typedef struct {
	const char *name;
	GtkType (*type)( void );
	Classmodel *(*build)( Rhs * );
} RhsGraphic;

/* All our graphicdisplay widgets. Order is important! Most derived classes
 * first.
 */
static RhsGraphic rhs_graphic[] = {
	{ CLASS_FILENAME, filename_get_type, filename_new },
	{ CLASS_TOGGLE, toggle_get_type, toggle_new },
	{ CLASS_SLIDER, slider_get_type, slider_new },
	{ CLASS_COLOUR, colour_get_type, colour_new },
	{ CLASS_OPTION, option_get_type, option_new },
	{ CLASS_MATRIX, matrix_get_type, matrix_new },
	{ CLASS_ARROW, iarrow_get_type, iarrow_new },
	{ CLASS_REGION, iregion_get_type, iregion_new },
	{ CLASS_IMAGE, iimage_get_type, iimage_new },
	{ CLASS_REAL, real_get_type, real_new }
};

/* Create/destroy the graphic display.
 */
static void
rhs_refresh_graphic( Rhs *rhs, PElement *root )
{
	gboolean result;
	Row *row = HEAPMODEL( rhs )->row;
	int i;

	/* Only for non-parameter class objects.
	 */
	if( heap_isclass( root, &result ) && result && 
		row->sym->type != SYM_PARAM )
		for( i = 0; i < IM_NUMBER( rhs_graphic ); i++ ) {
			const char *name = rhs_graphic[i].name;

			if( !heap_isinstanceof( name, root, &result ) ) 
				return;
			if( result ) {
				GtkType type = rhs_graphic[i].type();

				if( !rhs->graphic || 
					!TYPE_EXACT( rhs->graphic, type )) 
					rhs_graphic[i].build( rhs );

				return;
			}
		}

	/* Should be no graphic display.
	 */
	FREEO( rhs->graphic );
}

static void *
rhs_new_heap( Heapmodel *heapmodel, PElement *root )
{
	gboolean result;
	Rhs *rhs = RHS( heapmodel );
	Row *row = HEAPMODEL( rhs )->row;

#ifdef DEBUG
	printf( "rhs_new_heap: " );
	row_name_print( HEAPMODEL( rhs )->row );
	printf( "\n" );
#endif /*DEBUG*/

	/* Create/reuse/destroy the graphic display.
	 */
	rhs_refresh_graphic( rhs, root );

	/* Create/reuse/destroy class display. Only for non-param symbols.
	 */
	if( !heap_isclass( root, &result ) ) 
		return( rhs );
	if( result && row->sym->type != SYM_PARAM ) {
		if( !rhs->scol || !IS_SUBCOLUMN( rhs->scol ) ) 
			subcolumn_new( rhs, NULL );
	}
	else {
		/* Should be no klass display.
		 */
		FREEO( rhs->scol );
	}

	/* Create/reuse/destroy text display.
	 */
	if( !rhs->itext )
		itext_new( rhs );

	/* Recurse for children.
	 */
	if( rhs->graphic )
		if( heapmodel_new_heap( HEAPMODEL( rhs->graphic ), root ) )
			return( rhs );

	if( rhs->scol )
		if( heapmodel_new_heap( HEAPMODEL( rhs->scol ), root ) )
			return( rhs );

	if( rhs->itext )
		if( heapmodel_new_heap( HEAPMODEL( rhs->itext ), root ) )
			return( rhs );

	return( HEAPMODEL_CLASS( parent_class )->new_heap( heapmodel, root ) );
}

/* Rethink child visibility.
 */
void
rhs_set_vislevel( Rhs *rhs, int vislevel )
{
	vislevel = IM_MAX( 0, vislevel );

#ifdef DEBUG
	printf( "rhs_set_vislevel: %d ...\n", vislevel );
#endif /*DEBUG*/

	if( rhs->scol ) {
		Subcolumn *scol = SUBCOLUMN( rhs->scol );

		if( rhs->graphic ) {
			switch( vislevel ) {
			case 0:
				rhs->flags = RHS_ITEXT;
				break;

			case 1:
				rhs->flags = RHS_GRAPHIC;
				break;

			case 2:
				rhs->flags = RHS_ITEXT | RHS_GRAPHIC;
				break;

			default:
				rhs->flags = RHS_ITEXT | RHS_GRAPHIC | RHS_SCOL;
			}

			subcolumn_set_vislevel( scol, vislevel - 2 );
			if( vislevel < 3 )
				rhs->vislevel = vislevel;
			else
				rhs->vislevel = scol->vislevel + 2;
		}
		else {
			vislevel = IM_MAX( 1, vislevel );

			if( vislevel == 1 )
				rhs->flags = RHS_ITEXT;
			else
				rhs->flags = RHS_ITEXT | RHS_SCOL;

			subcolumn_set_vislevel( scol, vislevel - 1 );
			rhs->vislevel = scol->vislevel + 1;
		}
	}
	else {
		rhs->flags = RHS_ITEXT;
		rhs->vislevel = vislevel;
	}

#ifdef DEBUG
	printf( "... set to: %d\n", rhs->vislevel );
#endif /*DEBUG*/

	model_changed( MODEL( rhs ) );
}

void
rhs_vislevel_up( Rhs *rhs )
{
	rhs_set_vislevel( rhs, rhs->vislevel + 1 );
}

void
rhs_vislevel_down( Rhs *rhs )
{
	rhs_set_vislevel( rhs, rhs->vislevel - 1 );
}

static void *
rhs_update_model( Heapmodel *heapmodel )
{
	Rhs *rhs = RHS( heapmodel );

	/* Update visibility.
	 */
	rhs_set_vislevel( rhs, rhs->vislevel );

	return( HEAPMODEL_CLASS( parent_class )->update_model( heapmodel ) );
}

static void
rhs_class_init( RhsClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;
	ModelClass *model_class = (ModelClass *) klass;
	HeapmodelClass *heapmodel_class = (HeapmodelClass *) klass;

	parent_class = gtk_type_class( TYPE_HEAPMODEL );

	/* Create signals.
	 */

	/* Init methods.
	 */
	object_class->destroy = rhs_destroy;

	model_class->view_new = rhsview_new;
	model_class->child_add = rhs_child_add;
	model_class->parent_add = rhs_parent_add;
	model_class->load = rhs_load;
	model_class->save = rhs_save;

	heapmodel_class->new_heap = rhs_new_heap;
	heapmodel_class->update_model = rhs_update_model;

	/* Static init.
	 */
	model_register_loadable( MODEL_CLASS( klass ) );
}

static void
rhs_init( Rhs *rhs )
{
#ifdef DEBUG
	printf( "rhs_init\n" );
#endif /*DEBUG*/

	/* -1 means not set yet ... default vislevel set by row_new_heap()
	 * when the class members become available.
	 */
        rhs->vislevel = -1;

        rhs->graphic = NULL;
        rhs->scol = NULL;
        rhs->itext = NULL;
}

GtkType
rhs_get_type( void )
{
	static GtkType rhs_type = 0;

	if( !rhs_type ) {
		static const GtkTypeInfo info = {
			"Rhs",
			sizeof( Rhs ),
			sizeof( RhsClass ),
			(GtkClassInitFunc) rhs_class_init,
			(GtkObjectInitFunc) rhs_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		rhs_type = gtk_type_unique( TYPE_HEAPMODEL, &info );
	}

	return( rhs_type );
}

Rhs *
rhs_new( Row *row )
{
	Rhs *rhs = gtk_type_new( TYPE_RHS );

	model_child_add( MODEL( row ), MODEL( rhs ), -1 );

#ifdef DEBUG
	printf( "rhs_new: %s (0x%x)\n", 
		MODEL( row )->name, (unsigned int) rhs );
#endif /*DEBUG*/

	return( rhs );
}

static void *
rhs_child_edited_sub( Model *model )
{
	Row *row = ROW( model );

	if( row->child_rhs && rhs_child_edited( row->child_rhs ) )
		return( row );

	return( NULL );
}

/* Does this RHS have any edited children? text, graphic, or recursive.
 */
gboolean
rhs_child_edited( Rhs *rhs )
{
	if( rhs->itext && ITEXT( rhs->itext )->edited )
		return( TRUE );
	else if( rhs->graphic && CLASSMODEL( rhs->graphic )->edited )
		return( TRUE );
	else if( rhs->scol ) 
		return( model_map( rhs->scol,
			(model_map_fn) rhs_child_edited_sub, NULL, NULL ) !=
			NULL );
	else
		return( FALSE );
}
