/* Tools ... mostly a menu item.
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#define TYPE_TOOL (tool_get_type())
#define TOOL( obj ) (GTK_CHECK_CAST( (obj), TYPE_TOOL, Tool ))
#define TOOL_CLASS( klass ) \
	(GTK_CHECK_CLASS_CAST( (klass), TYPE_TOOL, ToolClass ))
#define IS_TOOL( obj ) (GTK_CHECK_TYPE( (obj), TYPE_TOOL ))
#define IS_TOOL_CLASS( klass ) \
	(GTK_CHECK_CLASS_TYPE( (klass), TYPE_TOOL ))

/* Tool types: a def (sym points to symbol for this def), a dialog (keep
 * filename and prompt name), or a separator.
 */
typedef enum {
	TOOL_SYM,
	TOOL_DIA,
	TOOL_SEP
} ToolType;

/* What we hold for each tool. If sym is NULL, this is a separator.
 */
struct _Tool {
	Filemodel parent_class;

	ToolType type;		
	Symbol *sym;		/* For SYM tools: symbol this tool represents */

	Toolkit *kit; 		/* Link back to toolkit */
};

typedef struct _ToolClass {
	FilemodelClass parent_class;

	/* My methods.
	 */
} ToolClass;

GtkType tool_get_type( void );

Tool *tool_new_sym( Toolkit *kit, int pos, Symbol *sym );
Tool *tool_new_sep( Toolkit *kit, int pos );
Tool *tool_new_dia( Toolkit *kit, int pos, 
	const char *filename, const char *name );
int tool_get_menu_pos( Tool *tool );
