/* Group toolkitgroup files together.
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

*/

/*
#define DEBUG
 */

#include "ip.h"

static ModelClass *parent_class = NULL;

static void
toolkitgroup_destroy( GtkObject *object )
{
	Toolkitgroup *kitg;

#ifdef DEBUG
	printf( "toolkitgroup_destroy\n" );
#endif /*DEBUG*/

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_TOOLKITGROUP( object ) );

	kitg = TOOLKITGROUP( object );

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

static void
toolkitgroup_class_init( ToolkitgroupClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;
	ModelClass *model_class = (ModelClass *) klass;

	parent_class = gtk_type_class( TYPE_MODEL );

	object_class->destroy = toolkitgroup_destroy;

	/* Create signals.
	 */

	/* Init methods.
	 */
	model_class->view_new = toolkitgroupview_new;
}

static void
toolkitgroup_init( Toolkitgroup *kitg )
{
}

GtkType
toolkitgroup_get_type( void )
{
	static GtkType toolkitgroup_type = 0;

	if( !toolkitgroup_type ) {
		static const GtkTypeInfo info = {
			"Toolkitgroup",
			sizeof( Toolkitgroup ),
			sizeof( ToolkitgroupClass ),
			(GtkClassInitFunc) toolkitgroup_class_init,
			(GtkObjectInitFunc) toolkitgroup_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		toolkitgroup_type = gtk_type_unique( TYPE_MODEL, &info );
	}

	return( toolkitgroup_type );
}

static void
toolkitgroup_link( Toolkitgroup *kitg )
{
	model_set( MODEL( kitg ), "all_toolkits", NULL );
	model_child_add( model_base, MODEL( kitg ), -1 );
}

Toolkitgroup *
toolkitgroup_new( void )
{
	Toolkitgroup *kitg = gtk_type_new( TYPE_TOOLKITGROUP );

	toolkitgroup_link( kitg );

	return( kitg );
}

/* Need a special sort function ... put kits not being displayed at the end so
 * they don't mess up the numbering of the visible kits.
 */
static gint
toolkitgroup_sort_compare( Model *a, Model *b )
{
	if( !a->display )
		return( 1 );
	if( !b->display )
		return( -1 );

        return( strcasecmp( a->name, b->name ) );
}

void
toolkitgroup_sort( Toolkitgroup *kitg )
{
	Model *model = MODEL( kitg );

        model->children = g_slist_sort( model->children, 
		(GCompareFunc) toolkitgroup_sort_compare );
	model_pos_renumber( model );
	model_changed( model );
}
