/* Manage toolkitviews and their display.
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG
 */

#include "ip.h"

static ViewClass *parent_class = NULL;

static void 
toolkitview_destroy( GtkObject *object )
{	
	Toolkitview *kview;

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_TOOLKITVIEW( object ) );

	kview = TOOLKITVIEW( object );

#ifdef DEBUG
	printf( "toolkitview_destroy %s\n", VIEW( kview )->model->name );
#endif /*DEBUG*/

	FREEW( kview->pane );
	FREEW( kview->cascade );

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

static void
toolkitview_refresh( View *view )
{
	Toolkitview *kview = TOOLKITVIEW( view );
	Toolkit *kit = TOOLKIT( VIEW( kview )->model );
	Toolkitgroupview *kitgview = kview->kitgview;
	GtkWidget *menubar = kitgview->menubar;

#ifdef DEBUG
	printf( "toolkitview_refresh %s\n", MODEL( kit )->name );
#endif /*DEBUG*/

	/* Make a button ready for the sub-menu. 
	 */
	if( !kview->cascade ) {
                kview->cascade = gtk_menu_item_new_with_label( 
			MODEL( kit )->name );
                gtk_menu_bar2_insert( GTK_MENU_BAR2( menubar ),
			kview->cascade, MODEL( kit )->pos );
                gtk_widget_show( kview->cascade );

		/* gtk_menu_bar2_insert() does not go through container_add,
		 * so there's no resize :-( force one ourselves.
		 */
		gtk_widget_queue_resize( mainw_window );
	}
	if( !kview->pane ) 
		kview->pane = gtk_menu_new();

	gtk_menu_item_set_submenu( GTK_MENU_ITEM( kview->cascade ), 
		kview->pane );

	widget_visible( kview->cascade, MODEL( kit )->children != NULL );

	VIEW_CLASS( parent_class )->refresh( view );
}

static void
toolkitview_link( View *view, Model *model, View *parent )
{
	Toolkitview *kview = TOOLKITVIEW( view );
	Toolkitgroupview *kitgview = TOOLKITGROUPVIEW( parent );

	kview->kitgview = kitgview;

	VIEW_CLASS( parent_class )->link( view, model, parent );
}

static void
toolkitview_class_init( ToolkitviewClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass*) klass;
	ViewClass *view_class = (ViewClass *) klass;

	parent_class = gtk_type_class( TYPE_VIEW );

	object_class->destroy = toolkitview_destroy;

	/* Create signals.
	 */

	/* Init methods.
	 */
	view_class->refresh = toolkitview_refresh;
	view_class->link = toolkitview_link;
}

static void
toolkitview_init( Toolkitview *kview )
{
        kview->cascade = NULL;
        kview->pane = NULL;
}

GtkType
toolkitview_get_type( void )
{
	static GtkType kview_type = 0;

	if( !kview_type ) {
		static const GtkTypeInfo kview_info = {
			"Toolkitview",
			sizeof( Toolkitview ),
			sizeof( ToolkitviewClass ),
			(GtkClassInitFunc) toolkitview_class_init,
			(GtkObjectInitFunc) toolkitview_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		kview_type = gtk_type_unique( TYPE_VIEW, &kview_info );
	}

	return( kview_type );
}

View *
toolkitview_new( void )
{
	Toolkitview *kview = gtk_type_new( TYPE_TOOLKITVIEW );

	return( VIEW( kview ) );
}

