/* Manage toolviewkits and their display.
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG
 */

/* Print out all menus and tooltips.
#define DEBUG_MENUS
 */

#include "ip.h"

static ViewClass *parent_class = NULL;

static void 
toolview_destroy( GtkObject *object )
{	
	Toolview *tview;

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_TOOLVIEW( object ) );

	tview = TOOLVIEW( object );

#ifdef DEBUG
	printf( "toolview_destroy %s\n", VIEW( tview )->model->name );
#endif /*DEBUG*/

	FREEW( tview->item );

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

static void
toolview_activate_sym_cb( gpointer *stuff, GtkWidget *widget )
{
	Symbol *sym = SYMBOL( stuff );

	workspace_symbol_action( main_workspacegroup->current, sym );
}

/* Flash help for a toolview.
 */
static void 
toolview_help_cb( gpointer *stuff, GtkWidget *widget )
{
	Symbol *sym = SYMBOL( stuff );
	BufInfo buf;
	char txt[80];

	if( !sym || !mainw_message )
		return;

	buf_init_static( &buf, txt, 80 );
	symbol_help( sym, &buf );
	set_glabel( mainw_message, "%s", buf_all( &buf ) );
}

/* Sub fn of below ... build a class sub-menu.
 */
static Symbol *
toolview_refresh_sub( Symbol *sym, GtkWidget *pane, Toolview *tview )
{
	GtkWidget *item;
	BufInfo buf;
	char txt[100];

	/* Hidden item?
	 *
	 * We also hide all supers ... could maybe be useful to display
	 * non-ELIST supers, but we'd have to look at the value for that, and
	 * at the moment, tool/toolkit stuff is just done from static
	 * analysis.
	 */
	if( !is_menuable( sym ) )
		return( NULL );

	if( is_separator( sym ) ) {
		/* Make a separator?
		 */
		item = gtk_menu_item_new();

#ifdef DEBUG_MENUS
		printf( "-------\n" );
#endif /*DEBUG_MENUS*/
	}
	else {
		buf_init_static( &buf, txt, 100 );
		symbol_help( sym, &buf );

#ifdef DEBUG_MENUS
{
		static char *last_filename = NULL;

		if( sym->tool && 
			FILEMODEL( sym->tool->kit )->filename != 
				last_filename ) {
			last_filename = FILEMODEL( sym->tool->kit )->filename;
			printf( "\n%s\n=======\n", 
				im__skip_dir( last_filename ) );
		}

		printf( "%s\n", buf_all( &buf ) );
}
#endif /*DEBUG_MENUS*/

		/* A full menu item.
		 */
		item = gtk_menu_item_new_with_label( MODEL( sym )->name );

		/* Is this the first item for this sub menu? Note it.
		 */
		if( !tview->item )
			tview->item = item;

		if( is_value( sym ) && is_class( sym->expr->compile ) && 
			!sym->expr->compile->has_super &&
			sym->expr->compile->nparam == 0 ) {
			GtkWidget *subpane = gtk_menu_new();
			GtkWidget *item2;

			item2 = gtk_tearoff_menu_item_new();
			gtk_menu_append( GTK_MENU( subpane ), item2 );
			gtk_widget_show( item2 );

			(void) stable_map( sym->expr->compile->locals,
				(symbol_map_fn) toolview_refresh_sub, 
				subpane, tview, NULL );
			gtk_menu_item_set_submenu( GTK_MENU_ITEM( item ), 
				subpane );
		}
		else {
			gtk_signal_connect_object( GTK_OBJECT( item ),
				"activate", 
				GTK_SIGNAL_FUNC( toolview_activate_sym_cb ),
				(gpointer) sym );
		}

		gtk_signal_connect_object( GTK_OBJECT( item ), "select", 
			GTK_SIGNAL_FUNC( toolview_help_cb ), (gpointer) sym );
		set_tooltip( GTK_WIDGET( item ), "%s", buf_all( &buf ) );
	}

	if( sym->tool ) {
		gtk_menu_insert( GTK_MENU( pane ), 
			item, tool_get_menu_pos( sym->tool ) );
#ifdef DEBUG
		printf( "gtk_menu_insert: pos = %d\n", 
			tool_get_menu_pos( sym->tool ) );
#endif /*DEBUG*/
	}
	else {
		gtk_menu_append( GTK_MENU( pane ), item );
#ifdef DEBUG
		printf( "gtk_menu_append\n" );
#endif /*DEBUG*/
	}
	gtk_widget_show( item );

	return( NULL );
}

/* Toolview activate callback, pass a toolview.
 */
static void
toolview_activate_cb( gpointer *stuff, GtkWidget *widget )
{
	Toolview *tview = TOOLVIEW( stuff );
	Tool *tool = TOOL( VIEW( tview )->model );
	Workspace *ws = main_workspacegroup->current;

	switch( tool->type ) {
	case TOOL_SYM:
		workspace_symbol_action( ws, tool->sym );
		break;

	case TOOL_DIA:
		if( !workspace_merge_file( ws, FILEMODEL( tool )->filename ) )
			box_alert( NULL );
		symbol_recalculate_all();
		break;

	default:
		assert( FALSE );
	}
}

/* Our widget has been destroyed. NULL out or pointer to it, to stop us
 * destroying it again later.
 */
void
toolview_destroy_cb( GtkWidget *widget, Toolview *tview )
{
	assert( tview->item == widget );

	tview->item = NULL;
}

/* Update toolview display.
 */
static void
toolview_refresh( View *view )
{
	Toolview *tview = TOOLVIEW( view );
	Tool *tool = TOOL( VIEW( tview )->model );
	Toolkitview *kview = tview->kview;
	char *str;

#ifdef DEBUG
	printf( "toolview_refresh %s\n", VIEW( tview )->model->name );
#endif /*DEBUG*/

	FREEW( tview->item );

	switch( tool->type ) {
	case TOOL_SYM:
		(void) toolview_refresh_sub( tool->sym, kview->pane, tview );
		break;

	case TOOL_DIA:
		str = g_strdup_printf( "%s ...", MODEL( tool )->name );
		tview->item = gtk_menu_item_new_with_label( str );
		g_free( str );
                gtk_signal_connect_object( GTK_OBJECT( tview->item ),
                         "activate", GTK_SIGNAL_FUNC( toolview_activate_cb ),
                         (gpointer) tview );

		gtk_menu_insert( GTK_MENU( kview->pane ), 
			tview->item, MODEL( tool )->pos );
#ifdef DEBUG
		printf( "gtk_menu_insert: pos = %d\n", MODEL( tool )->pos );
#endif /*DEBUG*/
                gtk_widget_show( tview->item );
		break;

	case TOOL_SEP:
		tview->item = gtk_menu_item_new();

                gtk_menu_insert( GTK_MENU( kview->pane ), 
			tview->item, tool_get_menu_pos( tool ) );
#ifdef DEBUG
		printf( "gtk_menu_insert: pos = %d\n", 
			tool_get_menu_pos( tool ) );
#endif /*DEBUG*/
                gtk_widget_show( tview->item );

#ifdef DEBUG_MENUS
		printf( "-------\n" );
#endif /*DEBUG_MENUS*/
		break;

	default:
		assert( FALSE );
	}

	if( tview->item ) 
		gtk_signal_connect( GTK_OBJECT( tview->item ), "destroy",
			GTK_SIGNAL_FUNC( toolview_destroy_cb ), tview );

	VIEW_CLASS( parent_class )->refresh( view );
}

static void
toolview_link( View *view, Model *model, View *parent )
{
	Toolview *tview = TOOLVIEW( view );
	Toolkitview *kview = TOOLKITVIEW( parent );

	VIEW_CLASS( parent_class )->link( view, model, parent );

	tview->kview = kview;
}

static void
toolview_class_init( ToolviewClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass*) klass;
	ViewClass *view_class = (ViewClass *) klass;

	parent_class = gtk_type_class( TYPE_VIEW );

	object_class->destroy = toolview_destroy;

	/* Create signals.
	 */

	/* Init methods.
	 */
	view_class->refresh = toolview_refresh;
	view_class->link = toolview_link;
}

static void
toolview_init( Toolview *toolview )
{
        toolview->item = NULL;
}

GtkType
toolview_get_type( void )
{
	static GtkType toolview_type = 0;

	if( !toolview_type ) {
		static const GtkTypeInfo toolview_info = {
			"Toolview",
			sizeof( Toolview ),
			sizeof( ToolviewClass ),
			(GtkClassInitFunc) toolview_class_init,
			(GtkObjectInitFunc) toolview_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		toolview_type = gtk_type_unique( TYPE_VIEW, &toolview_info );
	}

	return( toolview_type );
}

View *
toolview_new( void )
{
	Toolview *tview = gtk_type_new( TYPE_TOOLVIEW );

	return( VIEW( tview ) );
}
