/* a workspacegroupview button in a workspacegroup
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

*/

/* 
#define DEBUG
 */

#include "ip.h"

static ViewClass *parent_class = NULL;

static void
workspacegroupview_destroy( GtkObject *object )
{
	Workspacegroupview *wgview;

#ifdef DEBUG
	printf( "workspacegroupview_destroy\n" );
#endif /*DEBUG*/

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_WORKSPACEGROUPVIEW( object ) );

	wgview = WORKSPACEGROUPVIEW( object );

	/* Instance destroy.
	 */

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

static void *
workspacegroupview_refresh_sub( View *view, Workspacegroupview *wgview )
{
	Workspaceview *wview = WORKSPACEVIEW( view );
	Workspace *ws = WORKSPACE( VIEW( wview )->model );

	/* Fortunately, this only moves pages if it has to.
	 */
	gtk_notebook_reorder_child( GTK_NOTEBOOK( wgview->notebook ), 
		wview->frame, MODEL( ws )->pos );

	return( NULL );
}

static void 
workspacegroupview_refresh( View *view )
{
	Workspacegroupview *wgview = WORKSPACEGROUPVIEW( view );

#ifdef DEBUG
	printf( "workspacegroupview_refresh\n" );
#endif /*DEBUG*/

	/* Update positions of all children.
	 */
	(void) view_map( view,
		(view_map_fn) workspacegroupview_refresh_sub, wgview, NULL );

	VIEW_CLASS( parent_class )->refresh( view );
}

static void
workspacegroupview_class_init( WorkspacegroupviewClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;
	ViewClass *view_class = (ViewClass *) klass;

	parent_class = gtk_type_class( TYPE_VIEW );

	object_class->destroy = workspacegroupview_destroy;

	/* Create signals.
	 */

	/* Set methods.
	 */
	view_class->refresh = workspacegroupview_refresh;
}

static void
workspacegroupview_switch_page_cb( GtkWidget *widget, 
	GtkNotebookPage *page, gint page_num )
{
	GtkWidget *frame;
	Workspaceview *wview;

	frame = gtk_notebook_get_nth_page( GTK_NOTEBOOK( widget ), page_num );
	wview = WORKSPACEVIEW( gtk_object_get_data_by_id( 
		GTK_OBJECT( frame ), workspaceview_quark ) );

	if( view_hasmodel( VIEW( wview ) ) ) {
		Workspace *ws = WORKSPACE( VIEW( wview )->model );

		if( !ws->ontop ) {
			Workspacegroup *wsg = 
				workspace_get_workspacegroup( ws );

			workspacegroup_set_current( wsg, ws );
		}
	}
}

static gboolean
workspacegroupview_filedrop( Workspacegroupview *wgview, const char *file )
{
	gboolean result;

	result = main_load( file );
	if( result )
		symbol_recalculate_all();

	return( result );
}

static void
workspacegroupview_init( Workspacegroupview *wgview )
{
	wgview->notebook = gtk_notebook_new();
	gtk_notebook_set_tab_pos( GTK_NOTEBOOK( wgview->notebook ), 
		GTK_POS_BOTTOM );
	gtk_notebook_set_scrollable( GTK_NOTEBOOK( wgview->notebook ), TRUE );
        gtk_box_pack_start( GTK_BOX( wgview ), 
		wgview->notebook, TRUE, TRUE, 0 );
	gtk_signal_connect( GTK_OBJECT( wgview->notebook ), "switch_page",
		GTK_SIGNAL_FUNC( workspacegroupview_switch_page_cb ), wgview );

	/* Set workspacegroupview as file drop destination 
	 */
	filedrop_register( GTK_WIDGET( wgview ),
		(FiledropFunc) workspacegroupview_filedrop, wgview );

	gtk_widget_show( wgview->notebook );
}

GtkType
workspacegroupview_get_type( void )
{
	static GtkType workspacegroupview_type = 0;

	if( !workspacegroupview_type ) {
		static const GtkTypeInfo wgviewt = {
			"Workspacegroupview",
			sizeof( Workspacegroupview ),
			sizeof( WorkspacegroupviewClass ),
			(GtkClassInitFunc) workspacegroupview_class_init,
			(GtkObjectInitFunc) workspacegroupview_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		workspacegroupview_type = 
			gtk_type_unique( TYPE_VIEW, &wgviewt );
	}

	return( workspacegroupview_type );
}

View *
workspacegroupview_new( void )
{
	Workspacegroupview *wgview = gtk_type_new( TYPE_WORKSPACEGROUPVIEW );

	return( VIEW( wgview ) );
}
