.TH MARK %manext1% 2021-05-01 "%nmhversion%"
.
.\" %nmhwarning%
.
.SH NAME
mark \- manipulate nmh message sequences
.SH SYNOPSIS
.HP 5
.na
.B mark
.RB [ \-help ]
.RB [ \-version ]
.RI [ +folder ]
.RI [ msgs ]
.RB [ \-sequence
.I name
.IR \&... ]
.RB [ \-add " | " \-delete " | " \-list ]
.RB [ \-public " | " \-nopublic ]
.RB [ \-zero " | " \-nozero ]
.RB [ \-empty " | " \-noempty ]
.RB [ \-range " | " \-norange ]
.ad
.SH DESCRIPTION
The
.B mark
command manipulates message sequences by adding or deleting
message numbers from folder-specific message sequences, or by listing
those sequences and messages.
.PP
A message sequence is a keyword, just like one of the \*(lqreserved\*(rq
message names, such as \*(lqfirst\*(rq or \*(lqnext\*(rq.  Unlike the
\*(lqreserved\*(rq message names, which have a fixed semantics on
a per-folder basis, the semantics of a message sequence may be
defined, modified, and removed by the user.  Message sequences are
folder-specific, e.g., the sequence name \*(lqseen\*(rq in the context
of folder
.RI \*(lq +inbox \*(rq
need not have any relation whatsoever to the
sequence of the same name in a folder of a different name.
.PP
Three action switches direct the operation of
.BR mark .
These switches
are mutually exclusive: the last occurrence of any of them overrides
any previous occurrence of the other two.
.PP
The
.B \-add
switch tells
.B mark
to add messages to sequences or to
create a new sequence.  For each sequence named via the
.B \-sequence
.I name
argument (which must occur at least once) the messages named via
.I msgs
(which defaults to \*(lqcur\*(rq if no
.I msgs
are given), are added to the
sequence.  The messages to be added need not be absent from the sequence.
If the
.B \-zero
switch is specified, the sequence will be emptied prior
to adding the messages.  Hence,
.B \-add
.B \-zero
means that each sequence
should be initialized to the indicated messages, while
.B \-add
.B \-nozero
means that each sequence should be appended to by the indicated messages.
The
.B \-empty
switch does not affect the operation of
.BR \-add .
.PP
The
.B \-delete
switch tells
.B mark
to delete messages from sequences, and is the dual of
.BR \-add .
For each of the named sequences, the
named messages are removed from the sequence.  These messages need
not be already present in the sequence.  If the
.B \-zero
switch is
specified, then all messages in the folder are added to the sequence
(first creating the sequence, if necessary) before removing the messages.
Hence,
.B \-delete
.B \-zero
means that each sequence should contain
all messages except those indicated, while
.B \-delete
.B \-nozero
means
that only the indicated messages should be removed from each sequence.
As expected, the command
.RB \*(lq mark
.B \-sequence
.I foo
.B \-delete
all\*(rq empties the sequence \*(lqfoo\*(rq, and therefore removes
that sequence from the current folder's list of sequences.
Sequence
.I foo
must exist or a \*(lqno such sequence\*(rq error results.
This can be avoided by adding
.BR \-zero :
\*(lqmark \-sequence
.I foo
\-delete \-zero all\*(rq ensures sequence
.I foo
no longer exists.
The
.B \-empty
switch does not affect the operation of
.BR \-delete .
.PP
When creating or modifying sequences, you can specify the switches
.B \-public
or
.B \-nopublic
to force the new or modified sequences to be
\*(lqpublic\*(rq or \*(lqprivate\*(rq.  The switch
.B \-public
indicates
that the sequences should be made \*(lqpublic\*(rq.  These sequences
will then be readable by all
.B nmh
users with permission to read the relevant folders.  In contrast, the
.B \-nopublic
switch indicates that the
sequences should be made \*(lqprivate\*(rq, and will only be accessible by
you.  If neither of these switches is specified, then existing sequences
will maintain their current status, and new sequences will default to
\*(lqpublic\*(rq if you have write permission for the relevant folder.
Check
.IR mh\-sequence (5)
for more details about the difference
between \*(lqpublic\*(rq and \*(lqprivate\*(rq sequences.
.PP
The
.B \-list
switch tells
.B mark
to list all sequences, and the messages associated with them.  The output
can be limited to just certain sequences (with
.B \-sequence
switches) and/or messages (with
.I msgs
arguments).  
Normally,
.B \-list
will show all
sequences associated with the folder, or all sequences given with
.BR \-sequence .
Using
.B \-noempty
will suppress any which would show as empty, whether
because they actually are empty, or because they don't include any
of the given
.IR msgs ,
or because they've been specified with
.B \-sequence
but don't exist.
.RB ( \-empty
is the default.)
With the default
.B \-range
switch,
.B mark
will compress consecutive runs of message numbers to save space.  That
is, "3\ 4\ 5\ 6" will be shown as the range "3-6".
With
.BR \-norange ,
lists will be fully enumerated.
The
.B \-zero
switch does not affect the operation of
.BR \-list .
.PP
The restrictions on sequences are:
.PP
.IP \(bu 2
The name used to denote a message sequence must consist of an alphabetic
character followed by zero or more alphanumeric characters, and cannot
be one of the (reserved) message names \*(lqnew\*(rq, \*(lqfirst\*(rq,
\*(lqlast\*(rq, \*(lqall\*(rq, \*(lqnext\*(rq, or \*(lqprev\*(rq.
.PP
.IP \(bu 2
Message ranges with user-defined sequence names are restricted to the
form \*(lqname:n\*(rq, \*(lqname:+n\*(rq, or \*(lqname:-n\*(rq, and refer
to the first or last `n' messages of the sequence `name'.
If `=' is substituted for `:', these forms will instead refer to single
messages positioned `n' away from one end or the other of the sequence.
Constructs of the form \*(lqname1\-name2\*(rq are forbidden for user
defined sequences.
.SH FILES
.TP 20
$HOME/.mh_profile
The user's profile.
.SH "PROFILE COMPONENTS"
.PD 0
.TP 20
Path:
To determine the user's nmh directory.
.TP
Current\-Folder:
To find the default current folder.
.PD
.SH "SEE ALSO"
.IR flist (1),
.IR pick (1),
.IR mh-sequence (5)
.SH DEFAULTS
.PD 0
.TP 20
+folder
The current folder.
.TP
\-add
If
.B \-sequence
is specified,
.B \-list
otherwise.
.TP
msgs
The current message, or
.B all
if
.B \-list
is specified.
.TP
\-nozero
.PD
.SH CONTEXT
If a folder is given, it will become the current folder.
.SH "HELPFUL HINTS"
Use
.B flist
to find folders with a given sequence, and
.RB \*(lq pick
.I sequence
.BR \-list \*(rq
to enumerate those messages in the sequence (such as for
use by a shell script).
