#!/bin/sh
# Copyright (c) 1995-2002 SuSE Linux AG Nuernberg, Germany.
#
# Author: Jeff Stratton jlstratton@hotmail.com ,
# adopted from Lenz Grimmer feedback@suse.de to originally
# start noip2 daemon
#
# /etc/init.d/noip2
#
# and its symbolic link
#
# /usr/sbin/rc.noip2
#
### BEGIN INIT INFO
# Provides: noip2
# Required-Start: $network $remote_fs
# Required-Stop:
# Default-Start: 2 3 5
# Default-Stop:
# Description: Start the NOIP Dynamic IP Name Service
### END INIT INFO

# Shell functions sourced from /etc/rc.status:
# rc_check check and set local and overall rc status
# rc_status check and set local and overall rc status
# rc_status -v ditto but be verbose in local rc status
# rc_status -v -r ditto and clear the local rc status
# rc_failed set local and overall rc status to failed
# rc_failed num set local and overall rc status to num
# rc_reset clear local rc status (overall remains)
# rc_exit exit appropriate to overall rc status
. /etc/rc.status

# First reset status of this service
rc_reset

# Return values acc. to LSB for all commands but status:
# 0 - success
# 1 - generic or unspecified error
# 2 - invalid or excess argument(s)
# 3 - unimplemented feature (e.g. "reload")
# 4 - insufficient privilege
# 5 - program is not installed
# 6 - program is not configured
# 7 - program is not running
#
# Note that starting an already running service, stopping
# or restarting a not-running service as well as the restart
# with force-reload (in case signalling is not supported) are
# considered a success.

# Test, if noip2d actually exist
unset NOIP2D
NOIP2D=/bin/noip2
test "$NOIP2D" || { echo "No /bin/noip2 exists"; rc_failed 5; rc_status -v; rc_exit; }

# The following section has been taken from
# the original MySQL init script
#basedir=/usr
pid_file=/var/run/noipd.pid

if test -z "$basedir"
then
	basedir=/usr
	bindir=/usr/bin
else
	bindir="$basedir/bin"
fi

mode=$1 # start or stop

parse_arguments() {
	for arg do
		case "$arg" in
		  --basedir=*) basedir=`echo "$arg" | sed -e 's/^[^=]*=//'` ;;
		  --datadir=*) datadir=`echo "$arg" | sed -e 's/^[^=]*=//'` ;;
		  --pid-file=*) pid_file=`echo "$arg" | sed -e 's/^[^=]*=//'` ;;
		  --socket=*) socket=`echo "$arg" | sed -e 's/^[^=]*=//'` ;;
		esac
	done
}

# Get arguments from the my.cnf file, groups [noip2d]

# Safeguard (relative paths, core dumps..)
cd $basedir

case "$1" in
  start)
	# exit gracefully, if we are already running
	checkproc $NOIP2D && echo -n "Starting service NOIP Name Service " && \
	rc_status -v && rc_exit
	echo -n "Starting service NOIP Name Service "
	/bin/noip2
	/sbin/pidof noip2 $pid_file
	echo "\t\t\t\t\tdone."
	;;

  stop)
	echo -n "Shutting down service NOIP Name Service "
	killproc -p $pid_file -TERM $NOIP2D

	# Remember status and be verbose
	rc_status -v
	;;

  try-restart)
	## Stop the service and if this succeeds (i.e. the
	## service was running before), start it again.
	## Note: try-restart is not (yet) part of LSB (as of 0.7.5)
	$0 status /dev/null && $0 restart

	# Remember status and be quiet
	rc_status
	;;

  restart|force-reload)
	echo "Restarting service NOIP Name Service "
	$0 stop
	$0 start

	rc_status
	;;

  reload)
	echo -n "Reloading service NOIP Name Service "
	killproc -p $pid_file -HUP $NOIP2D
	touch $pid_file
	rc_status -v
	;;

  check|status)
	echo -n "Checking for service NOIP Name Service: "
	## Check status with checkproc(8), if process is running
	## checkproc will return with exit status 0.

	# Status has a slightly different for the status command:
	# 0 - service running
	# 1 - service dead, but /var/run/ pid file exists
	# 2 - service dead, but /var/lock/ lock file exists
	# 3 - service not running

	# NOTE: checkproc returns LSB compliant status values.
	checkproc $NOIP2D
	rc_status -v
	;;

  *)
	echo "Usage: $0 {start|stop|status|reload|restart|try-restart|force-reload}"
	exit 1
	;;
esac

rc_exit
