var count = (function abs(Big) {
    var start = +new Date(),
        log,
        error,
        passed = 0,
        total = 0;

    if (typeof window === 'undefined') {
        log = console.log;
        error = console.error;
    } else {
        log = function (str) { document.body.innerHTML += str.replace('\n', '<br>') };
        error = function (str) { document.body.innerHTML += '<div style="color: red">' +
          str.replace('\n', '<br>') + '</div>' };
    }

    if (!Big && typeof require === 'function') Big = require('../big');

    function assert(expected, actual) {
        total++;
        if (expected !== actual) {
            error('\n Test number: ' + total + ' failed');
            error(' Expected: ' + expected);
            error(' Actual:   ' + actual);
            //process.exit();
        } else {
            passed++;
            //log('\n Expected and actual: ' + actual);
        }
    }

    function T(expected, value){
        assert(String(expected), new Big(String(value)).abs().toString());
    }

    log('\n Testing abs...');

    Big.DP = 20;
    Big.RM = 1;

    T(1, 1);
    T(1, -1);
    T(0.5, '0.5');
    T(0.5, '-0.5');
    T(0.1, 0.1);
    T(0.1, -0.1);
    T(1.1, 1.1);
    T(1.1, -1.1);
    T(1.5, '1.5');
    T(1.5, '-1.5');

    T(0.00001, '-1e-5');
    T(9000000000, '-9e9');
    T(123456.7891011, -123456.7891011);
    T(999.999, '-999.999');
    T(99, 99);
    T(1, new Big(-1));
    T(0.001, new Big(0.001));
    T(0.001, new Big('-0.001'));
    T(0, 0);
    T(0, -0);

    var minusZero = 1 / (-1 / 0);

    function isMinusZero(n) {
        return n.toString() === '0' && n.s == -1;
    }

    T(0, 0);
    T(0, -0);
    T(0, minusZero);

    assert(true, isMinusZero(new Big('-0')));
    assert(true, isMinusZero(new Big(minusZero)));
    assert(false, isMinusZero(new Big(-0).abs()));
    assert(false, isMinusZero(new Big(minusZero).abs()));
    assert(true, !isMinusZero(new Big('-0').abs()));
    assert(true, !isMinusZero(new Big(minusZero).abs()));

    T(Number.MIN_VALUE, Number.MIN_VALUE);
    T(Number.MIN_VALUE, -Number.MIN_VALUE);
    T(Number.MAX_VALUE, Number.MAX_VALUE);
    T(Number.MAX_VALUE, -Number.MAX_VALUE);

    var two_30 = 1 << 30;

    T(two_30, two_30);
    T(two_30, -two_30);

    T(two_30 + 1, two_30 + 1);
    T(two_30 + 1, -two_30 - 1);

    T(two_30 - 1, two_30 - 1);
    T(two_30 - 1, -two_30 + 1);

    var two_31 = 2 * two_30;

    T(two_31, two_31);
    T(two_31, -two_31);

    T(two_31 + 1, two_31 + 1);
    T(two_31 + 1, -two_31 - 1);

    T(two_31 - 1, two_31 - 1);
    T(two_31 - 1, -two_31 + 1);

    T('0', '0');
    T('1', '-1');
    T('11.121', '11.121');
    T('0.023842', '-0.023842');
    T('1.19', '-1.19');
    T('9.622e-11', '-0.00000000009622');
    T('5.09e-10', '-0.000000000509');
    T('3838.2', '3838.2');
    T('127', '127.0');
    T('4.23073', '4.23073');
    T('2.5469', '-2.5469');
    T('29949', '-29949');
    T('277.1', '-277.10');
    T('4.97898e-15', '-0.00000000000000497898');
    T('53.456', '53.456');
    T('100564', '-100564');
    T('12431.9', '-12431.9');
    T('97633.7', '-97633.7');
    T('220', '220');
    T('188.67', '-188.67');
    T('35', '-35');
    T('2.6', '-2.6');
    T('2.2e-19', '-0.000000000000000000220');
    T('1.469', '-1.469');
    T('150.7', '-150.7');
    T('74', '-74');
    T('3.52e-9', '-0.00000000352');
    T('2221.7', '-2221.7');
    T('0.000004211', '-0.000004211');
    T('1', '-1');
    T('5.886', '-5.886');
    T('16', '16');
    T('4.4493e-9', '0.0000000044493');
    T('47.6', '47.6');
    T('1.6', '-1.60');
    T('1', '-1');
    T('1.5', '-1.5');
    T('5', '-5');
    T('1', '-1');
    T('8027', '8027');
    T('6.36e-16', '-0.000000000000000636');
    T('3.87766', '3.87766');
    T('7.4', '-7.4');
    T('4.449', '-4.449');
    T('5.2218e-19', '-0.000000000000000000522180');
    T('1.3769e-11', '-0.000000000013769');
    T('7.898e-13', '-0.0000000000007898');
    T('522.9', '-522.9');
    T('16.1', '-16.1');
    T('2.15', '2.15');
    T('4.3', '4.3');
    T('3', '-3');
    T('2.8', '-2.8');
    T('1', '-1');
    T('0.0000128696', '-0.0000128696');
    T('13.33', '-13.33');
    T('0.00000132177', '-0.00000132177');
    T('1.41516', '-1.41516');
    T('180.4', '-180.4');
    T('115079', '-115079');
    T('959', '959');
    T('714.4', '714.4');
    T('1.4544', '1.4544');
    T('53.691', '53.691');
    T('2.03832e-12', '-0.00000000000203832');
    T('1', '-1');
    T('10.8', '10.8');
    T('6189.2', '-6189.2');
    T('6.30866', '6.30866');
    T('62306', '62306');
    T('4', '-4.0');
    T('997.1', '-997.1');
    T('27.4', '-27.40');
    T('9242', '9242');
    T('31.1', '-31.1');
    T('23.4', '23.4');
    T('451818', '-451818');
    T('7', '-7');
    T('1.9', '-1.9');
    T('2', '-2');
    T('112.983', '-112.983');
    T('9.36e-8', '-0.0000000936');
    T('12.8515', '12.8515');
    T('73.1', '-73.1');
    T('18.15', '18.150');
    T('11997.8', '11997.8');
    T('23.1', '-23.1');
    T('82.022', '-82.022');
    T('3.916e-20', '-0.00000000000000000003916');
    T('3.3', '-3.3');
    T('892.1', '-892.1');
    T('24.4', '24.4');
    T('72', '72.0');
    T('0.0013346', '0.0013346');
    T('10.4', '-10.4');
    T('367.5', '367.5');
    T('7', '-7');
    T('127.195', '127.195');
    T('7.89e-13', '-0.000000000000789');
    T('63', '-63');
    T('85821.2', '-85821.2');
    T('95.6', '95.6');
    T('8.9e-14', '-0.000000000000089');
    T('112.1', '-112.1');
    T('3.68', '-3.68');
    T('9', '-9');
    T('0.0000975', '-0.0000975');
    T('393.6', '-393.6');
    T('7.4', '-7.4');
    T('69.62', '-69.62');
    T('5201.3', '5201.3');
    T('163', '163');
    T('4.30732', '4.30732');
    T('224.49', '-224.49');
    T('319.8', '-319.8');
    T('88.1', '-88.1');
    T('2.7762e-8', '0.000000027762');
    T('2.043e-7', '-0.0000002043');
    T('75459.3', '-75459.3');
    T('0.178', '0.178');
    T('0.00001633', '0.00001633');
    T('955', '955');
    T('373898', '-373898');
    T('9780.1', '9780.1');
    T('503.47', '503.47');
    T('3.44562', '-3.44562');
    T('1.6', '-1.6');
    T('1.22442', '-1.22442');
    T('1.4', '1.4');
    T('1219.1', '-1219.1');
    T('2.7', '-2.7');
    T('1057', '-1057');
    T('1938', '1938');
    T('1.1983', '1.1983');
    T('0.0012', '-0.0012');
    T('95.713', '-95.713');
    T('2', '-2');
    T('17.24', '-17.24');
    T('10.3', '-10.3');
    T('1', '-1');
    T('65.8', '-65.8');
    T('2.9', '2.9');
    T('54149', '54149');
    T('8', '-8');
    T('1', '1.0');
    T('4', '-4');
    T('6.3', '-6.3');
    T('5.25e-9', '0.00000000525');
    T('52.3', '-52.3');
    T('75290', '-75290');
    T('5.9', '-5.9');
    T('13.7', '13.7');
    T('2.3982e-9', '0.0000000023982');
    T('91.5', '-91.50');
    T('2072.39', '2072.39');
    T('385.6', '385.6');
    T('4.77', '4.77');
    T('18.72', '18.720');
    T('2817', '-2817');
    T('44535', '-44535');
    T('655', '655');
    T('2e-15', '-0.0000000000000020');
    T('0.625', '0.6250');
    T('2', '-2');
    T('5.315', '5.315');
    T('70.9', '70.90');
    T('6.4', '6.4');
    T('1824', '1824');
    T('52.595', '52.595');
    T('3662', '3662.0');
    T('3.1', '3.1');
    T('1.05032e-7', '0.000000105032');
    T('997.063', '-997.063');
    T('41746', '-41746');
    T('24.0402', '24.0402');
    T('0.009135', '0.009135');
    T('2.34e-9', '-0.00000000234');
    T('13.1', '13.1');
    T('228.8', '228.8');
    T('565.85', '565.85');
    T('4e-20', '0.000000000000000000040');
    T('1.73', '1.73');
    T('38.9', '38.9');
    T('1.02e-14', '-0.0000000000000102');
    T('302.8', '-302.8');
    T('7', '-7');
    T('1', '-1');
    T('0.00247', '0.00247');
    T('2', '-2');
    T('3.26', '-3.26');
    T('8.8', '8.8');
    T('90.6', '90.6');
    T('8.3053e-17', '-0.000000000000000083053');
    T('2.5', '-2.5');
    T('376.2', '-376.2');
    T('1.29', '1.29');
    T('1.379', '-1.379');
    T('40921.5', '-40921.5');
    T('1', '-1');
    T('12.5', '12.5');
    T('10.1', '10.1');
    T('1', '-1');
    T('226636', '226636');
    T('1', '-1');
    T('1.7', '-1.7');
    T('31.31', '31.31');
    T('79.9', '-79.9');
    T('4.027e-13', '0.0000000000004027');
    T('43.838', '43.838');
    T('6.47', '-6.47');
    T('5.292e-19', '0.0000000000000000005292');
    T('4.6', '-4.6');
    T('15918', '-15918.0');
    T('239.45', '239.45');
    T('1.02', '-1.02');
    T('14101', '-14101');
    T('7', '-7');
    T('367.34', '367.34');
    T('5', '-5');
    T('19.9', '-19.9');
    T('269.45', '-269.45');
    T('10.34', '-10.34');
    T('3.32882e-12', '-0.00000000000332882');
    T('5.9', '5.9');
    T('9', '-9.0');
    T('1.3597', '-1.3597');
    T('8', '8.0');
    T('1', '1.0');
    T('312.5', '312.5');
    T('1.554', '-1.554');
    T('210.985', '-210.985');
    T('1', '-1');
    T('1.24', '-1.24');
    T('513865', '-513865');
    T('6748', '-6748');
    T('591.51', '-591.51');
    T('2.2', '-2.2');
    T('19.5495', '19.5495');
    T('3.3', '3.3');
    T('30', '-30');
    T('94', '-94');
    T('217.55', '217.55');
    T('2', '-2');
    T('99', '99');
    T('4.067', '-4.067');
    T('702.57', '702.57');
    T('3.7', '-3.70');
    T('4', '4.0');
    T('192944', '192944');
    T('0.000022', '0.000022');
    T('47.6', '47.60');
    T('0.391', '0.3910');
    T('35', '-35');
    T('100', '-100');
    T('3.3', '-3.3');
    T('32.432', '32.432');
    T('1.07849e-18', '0.00000000000000000107849');
    T('2', '-2.0');
    T('23.27', '23.27');
    T('4.054e-15', '-0.000000000000004054');
    T('7.6', '-7.6');
    T('1305', '1305');
    T('1.501', '-1.501');
    T('3.4', '3.4');
    T('22.5', '-22.5');
    T('1.0916', '1.0916');
    T('2', '-2');
    T('58.271', '58.271');
    T('1.73e-12', '0.00000000000173');
    T('1.3458e-15', '0.0000000000000013458');
    T('309.87', '-309.87');
    T('5.318', '-5.318');
    T('1.5302e-8', '0.000000015302');
    T('596765', '596765');
    T('54.42', '-54.42');
    T('6.549e-20', '0.00000000000000000006549');
    T('29', '29');
    T('46.025', '46.025');
    T('2556.78', '-2556.78');
    T('0.00287721', '0.00287721');
    T('1.63', '-1.63');
    T('0.00041', '0.00041');
    T('698', '698');
    T('134.4', '134.4');
    T('2.1', '2.1');
    T('2.07', '-2.07');
    T('122.869', '122.869');
    T('0.00017', '-0.00017');
    T('18.6', '18.6');
    T('7', '-7');
    T('0.0180557', '0.0180557');
    T('5', '-5');
    T('6.2', '-6.2');
    T('8', '-8');
    T('450.96', '-450.96');
    T('20.2', '-20.2');
    T('176.52', '176.52');
    T('0.00017', '-0.000170');
    T('5', '-5');
    T('1', '-1');
    T('1.37856e-14', '0.0000000000000137856');
    T('76.3048', '76.3048');
    T('1803.7', '-1803.7');
    T('74', '74');
    T('1.7e-12', '0.0000000000017');
    T('48.7', '-48.7');
    T('4.48', '-4.48');
    T('1.4', '-1.4');
    T('7.69', '-7.69');
    T('23.5987', '23.5987');
    T('3074', '3074.0');
    T('8.06e-15', '-0.00000000000000806');
    T('21.3757', '-21.3757');
    T('35', '35');
    T('11.056', '11.0560');
    T('3.36e-14', '-0.0000000000000336');
    T('49139.4', '-49139.4');
    T('32.654', '-32.654');
    T('34035.4', '34035.4');
    T('15.22', '15.22');
    T('62', '62.0');
    T('8.89156', '-8.89156');
    T('14', '14');
    T('0.006', '-0.0060');
    T('1.5', '1.5');
    T('7', '-7');
    T('1.6e-11', '0.000000000016');
    T('26.6427', '26.6427');
    T('1.5e-18', '-0.0000000000000000015');
    T('1.52838e-15', '0.00000000000000152838');
    T('119.1', '119.1');
    T('0.004283', '0.004283');
    T('818', '-818');
    T('194', '194');
    T('104.788', '-104.788');
    T('3.74e-11', '0.0000000000374');
    T('6.162', '-6.162');
    T('5.19214e-18', '-0.00000000000000000519214');
    T('1.4', '-1.4');
    T('1.27', '-1.27');
    T('7.83822e-12', '-0.00000000000783822');
    T('1', '-1');
    T('4.4', '4.4');
    T('7.37382e-12', '0.00000000000737382');
    T('13.618', '13.618');
    T('1.03', '-1.03');
    T('3.7457e-13', '0.00000000000037457');
    T('5.2', '-5.2');
    T('3.5', '3.5');
    T('364', '-364');
    T('7.336', '7.336');
    T('1.1447e-16', '-0.00000000000000011447');
    T('510.63', '-510.63');
    T('5.8', '5.8');
    T('7.8', '7.8');
    T('2.96', '-2.96');
    T('15.64', '-15.64');
    T('187863', '-187863');
    T('2.73', '-2.73');
    T('2.671', '-2.671');
    T('18.179', '-18.179');
    T('855885', '855885');
    T('4.16', '4.16');
    T('5.722e-18', '0.000000000000000005722');
    T('67.62', '67.62');
    T('813.31', '813.31');
    T('40.2', '40.20');
    T('0.00002515', '0.00002515');
    T('0.0196', '0.01960');
    T('13.165', '13.165');
    T('6.743', '-6.743');
    T('1', '-1');
    T('200.56', '-200.56');
    T('1.932', '1.932');
    T('92.9', '92.90');
    T('16.74', '16.74');
    T('4.5554e-7', '-0.00000045554');
    T('2.1296e-15', '-0.0000000000000021296');
    T('2.088', '2.088');
    T('2577', '2577');
    T('45.4', '-45.4');
    T('41.3', '-41.3');
    T('3.63', '-3.63');
    T('1.09', '-1.09');
    T('1', '-1');
    T('3.7', '-3.7');
    T('204.54', '204.54');
    T('235.6', '235.6');
    T('384', '-384');
    T('0.0207', '0.02070');
    T('680', '680');
    T('1.09', '1.09');
    T('109.2', '109.2');
    T('0.00010117', '0.00010117');
    T('13.81', '13.81');
    T('192.3', '192.3');
    T('1', '-1');
    T('1.2', '1.2');
    T('4.1', '-4.1');
    T('2.5', '2.5');
    T('8.4076', '-8.4076');
    T('0.0517', '0.0517');
    T('6.3923', '-6.3923');
    T('506.179', '-506.179');
    T('375886', '375886');
    T('618858', '-618858');
    T('8.5e-11', '0.000000000085');
    T('6', '-6.0');
    T('2.4', '2.40');
    T('0.0000013', '-0.0000013');
    T('1.064', '-1.064');
    T('1', '-1');
    T('4', '-4');
    T('4.5', '-4.5');
    T('93.6206', '93.6206');
    T('3.07e-18', '0.00000000000000000307');

    T('52.452468128', '-5.2452468128e+1');
    T('14152590525718936.5008396', '1.41525905257189365008396e+16');
    T('274306808392.8', '2.743068083928e+11');
    T('1.52993064722314247378724599e+26', '-1.52993064722314247378724599e+26');
    T('37205576746', '3.7205576746e+10');
    T('868099644460934347.2665', '8.680996444609343472665e+17');
    T('1254.549', '1.254549e+3');
    T('6.23417196172381875892300762819e-18', '6.23417196172381875892300762819e-18');
    T('13117994082191928443.1', '1.31179940821919284431e+19');
    T('97697726.168', '9.7697726168e+7');
    T('2.663e-10', '-2.663e-10');
    T('1052', '1.052e+3');
    T('3.815873266712e-20', '-3.815873266712e-20');
    T('18', '1.8e+1');
    T('1.033525906631680944018544811261e-13', '1.033525906631680944018544811261e-13');
    T('3.805493087068952925e-11', '-3.805493087068952925e-11');
    T('0.0173948', '1.73948e-2');
    T('5.784e-15', '5.784e-15');
    T('4.448338479762497e-8', '4.448338479762497e-8');
    T('390080230.52', '3.9008023052e+8');
    T('3', '3e+0');
    T('8.61435e-9', '8.61435e-9');
    T('43.7', '-4.37e+1');
    T('8.4034159379836e-18', '-8.4034159379836e-18');
    T('20028573.55721079885824481', '2.002857355721079885824481e+7');
    T('7000871.862', '-7.000871862e+6');

    log('\n ' + passed + ' of ' + total + ' tests passed in ' + (+new Date() - start) + ' ms \n');
    return [passed, total];;
})(this.Big);
if (typeof module !== 'undefined' && module.exports) module.exports = count;