'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * The MIT License (MIT)
 * Copyright (c) 2015-present Dmitry Soshnikov <dmitry.soshnikov@gmail.com>
 */

var LRParserGeneratorDefault = require(ROOT + 'lr/lr-parser-generator-default').default;
var PyParserGeneratorTrait = require('../py-parser-generator-trait');

/**
 * Generic Python template for all LR parsers.
 */
var PY_LR_PARSER_TEMPLATE = _fs2.default.readFileSync(__dirname + '/../templates/lr.template.py', 'utf-8');

/**
 * LR parser generator for Python.
 */

var LRParserGeneratorPy = function (_LRParserGeneratorDef) {
  _inherits(LRParserGeneratorPy, _LRParserGeneratorDef);

  /**
   * Instance constructor.
   */
  function LRParserGeneratorPy(_ref) {
    var _this;

    var grammar = _ref.grammar,
        outputFile = _ref.outputFile,
        _ref$options = _ref.options,
        options = _ref$options === undefined ? {} : _ref$options;

    _classCallCheck(this, LRParserGeneratorPy);

    (_this = _possibleConstructorReturn(this, (LRParserGeneratorPy.__proto__ || Object.getPrototypeOf(LRParserGeneratorPy)).call(this, { grammar: grammar, outputFile: outputFile, options: options })), _this).setTemplate(PY_LR_PARSER_TEMPLATE);

    _this._lexHandlers = [];
    _this._productionHandlers = [];

    // Trait provides methods for lex and production handlers.
    Object.assign(_this, PyParserGeneratorTrait);
    return _this;
  }

  /**
   * Generates parser code.
   */


  _createClass(LRParserGeneratorPy, [{
    key: 'generateParserData',
    value: function generateParserData() {
      _get(LRParserGeneratorPy.prototype.__proto__ || Object.getPrototypeOf(LRParserGeneratorPy.prototype), 'generateParserData', this).call(this);
      this.generateLexHandlers();
      this.generateProductionHandlers();
    }
  }]);

  return LRParserGeneratorPy;
}(LRParserGeneratorDefault);

exports.default = LRParserGeneratorPy;
;