'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * The MIT License (MIT)
 * Copyright (c) 2015-present Dmitry Soshnikov <dmitry.soshnikov@gmail.com>
 */

var LRParserGeneratorDefault = require(ROOT + 'lr/lr-parser-generator-default').default;
var RustParserGeneratorTrait = require('../rust-parser-generator-trait');

/**
 * Generic Rust template for all LR parsers.
 */
var RUST_LR_PARSER_TEMPLATE = _fs2.default.readFileSync(__dirname + '/../templates/lr.template.rs', 'utf-8');

/**
 * LR parser generator for Rust.
 */

var LRParserGeneratorRust = function (_LRParserGeneratorDef) {
  _inherits(LRParserGeneratorRust, _LRParserGeneratorDef);

  /**
   * Instance constructor.
   */
  function LRParserGeneratorRust(_ref) {
    var _this;

    var grammar = _ref.grammar,
        outputFile = _ref.outputFile,
        _ref$options = _ref.options,
        options = _ref$options === undefined ? {} : _ref$options;

    _classCallCheck(this, LRParserGeneratorRust);

    (_this = _possibleConstructorReturn(this, (LRParserGeneratorRust.__proto__ || Object.getPrototypeOf(LRParserGeneratorRust)).call(this, { grammar: grammar, outputFile: outputFile, options: options })), _this).setTemplate(RUST_LR_PARSER_TEMPLATE);

    _this._lexHandlers = [];
    _this._productionHandlers = [];

    /**
     * Stores all used types of the arguments, and return values.
     * This is used to generate `SV` (stack value) enum.
     * Init to `Token` type which is always stored on the stack.
     *
     * enum SV {
     *     _0(Token),
     *     _1(...),
     * }
     */
    _this._allTypes = {
      Token: 0
    };

    // Autoinc index in SV.
    _this._allTypesIndex = 1;

    // Trait provides methods for lex and production handlers.
    Object.assign(_this, RustParserGeneratorTrait);
    return _this;
  }

  /**
   * Generates parser code.
   */


  _createClass(LRParserGeneratorRust, [{
    key: 'generateParserData',
    value: function generateParserData() {
      // Lexical grammar.
      this.generateTokenizer();

      // Syntactic grammar.
      this.generateProductions();

      // Tables.
      this.generateTokensTable();
      this.generateParseTable();

      this.generateLexHandlers();
      this.generateProductionHandlers();
      this.generateStackValueEnum();

      // The module include which should include at least
      // result type: type TResult = <...>;
      this.generateModuleInclude();
    }
  }]);

  return LRParserGeneratorRust;
}(LRParserGeneratorDefault);

exports.default = LRParserGeneratorRust;
;