// @filename: file.tsx
// @jsx: preserve
// @noLib: true
// @libFiles: react.d.ts,lib.d.ts

import React = require('react');

interface PoisonedProp {
    x: string;
    y: 2;
}

class Poisoned extends React.Component<PoisonedProp, {}> {
    render() {
        return <div>Hello</div>;
    }
}

const obj: PoisonedProp = {
    x: "hello world",
    y: 2
};

// OK
let p = <Poisoned {...obj} />;

class EmptyProp extends React.Component<{}, {}> {
    render() {
        return <div>Default hi</div>;
    }
}

// OK
let j: any;
let e1 = <EmptyProp {...{}} />;
let e2 = <EmptyProp {...j} />
let e3 = <EmptyProp {...{ ref: (input) => { this.textInput = input; } }} />
let e4 = <EmptyProp data-prop />
let e5 = <EmptyProp {...{ "data-prop": true}} />