---
layout: "docs"
page_title: "Commands: agent"
sidebar_current: "docs-commands-_agent" # Use "_" to break prefix match
description: >
  The agent command is the main entrypoint to running a Nomad client
  or server.
---

# Command: agent

The agent command is the heart of Nomad: it runs the agent that handles client
or server functionality, including exposing interfaces for client consumption
and running jobs.

Due to the power and flexibility of this command, the Nomad agent is documented
in its own section. See the [Nomad Agent] guide and the [Configuration]
documentation section for more information on how to use this command and the
options it has.

## Command-line Options

A subset of the available Nomad agent configuration can optionally be passed in
via CLI arguments. The `agent` command accepts the following arguments:

- `-alloc-dir=<path>`: Equivalent to the Client [alloc_dir] config
   option.

- `-acl-enabled`: Equivalent to the ACL [enabled] config option.

- `-acl-replication-token`: Equivalent to the ACL [replication_token] config
  option.

- `-bind=<address>`: Equivalent to the [bind_addr] config option.

- `-bootstrap-expect=<num>`: Equivalent to the
  [bootstrap_expect] config option.

- `-client`: Enable client mode on the local agent.

- `-config=<path>`: Specifies the path to a configuration file or a directory of
  configuration files to load. Can be specified multiple times.

- `-consul-address=<addr>`: Equivalent to the [address] config option.

- `-consul-auth=<auth>`: Equivalent to the [auth] config option.

- `-consul-auto-advertise`: Equivalent to the [auto_advertise] config option.

- `-consul-ca-file=<path>`: Equivalent to the [ca_file] config option.

- `-consul-cert-file=<path>`: Equivalent to the [cert_file] config option.

- `-consul-checks-use-advertise`: Equivalent to the [checks_use_advertise]
  config option.

- `-consul-client-auto-join`: Equivalent to the [client_auto_join] config
  option.

- `-consul-client-service-name=<name>`: Equivalent to the [client_service_name]
  config option.

- `-consul-client-http-check-name=<name>`: Equivalent to the
  [client_http_check_name] config option.

- `-consul-key-file=<path>`: Equivalent to the [key_file] config option.

- `-consul-server-service-name=<name>`: Equivalent to the [server_service_name]
  config option.

- `-consul-server-http-check-name=<name>`: Equivalent to the
  [server_http_check_name] config option.

- `-consul-server-serf-check-name=<name>`: Equivalent to the
  [server_serf_check_name] config option.

- `-consul-server-rpc-check-name=<name>`: Equivalent to the
  [server_rpc_check_name] config option.

- `-consul-server-auto-join`: Equivalent to the [server_auto_join] config
  option.

- `-consul-ssl`: Equivalent to the [ssl] config option.

- `-consul-token=<token>`: Equivalent to the [token] config option.

- `-consul-verify-ssl`: Equivalent to the [verify_ssl] config option.

- `-data-dir=<path>`: Equivalent to the [data_dir] config option.

- `-dc=<datacenter>`: Equivalent to the [datacenter] config option.

- `-dev`: Start the agent in development mode. This enables a pre-configured
  dual-role agent (client + server) which is useful for developing or testing
  Nomad. No other configuration is required to start the agent in this mode,
  but you may pass an optional comma-separated list of mode configurations:

- `-dev-connect`: Start the agent in development mode, but bind to a public
  network interface rather than localhost for using Consul Connect. This mode
  is supported only on Linux as root.

- `-encrypt`: Set the Serf encryption key. See the [Encryption Overview] for
  more details.

- `-join=<address>`: Address of another agent to join upon starting up. This can
  be specified multiple times to specify multiple agents to join.

- `-log-level=<level>`: Equivalent to the [log_level] config option.

- `-log-json`: Equivalent to the [log_json] config option.

- `-meta=<key=value>`: Equivalent to the Client [meta] config option.

- `-network-interface=<interface>`: Equivalent to the Client
   [network_interface] config option.

- `-network-speed=<MBits>`: Equivalent to the Client
  [network_speed] config option.

- `-node=<name>`: Equivalent to the [name] config option.

- `-node-class=<class>`: Equivalent to the Client [node_class]
  config option.

- `-plugin-dir=<path>`: Equivalent to the [plugin_dir] config option.

- `-region=<region>`: Equivalent to the [region] config option.

- `-rejoin`: Equivalent to the [rejoin_after_leave] config option.

- `-retry-interval`: Equivalent to the [retry_interval] config option.

- `-retry-join`: Similar to `-join` but allows retrying a join if the first
  attempt fails.

  ```sh
  $ nomad agent -retry-join "127.0.0.1:4648"
  ```

  `retry-join` can be defined as a command line flag only for servers. Clients
  can configure `retry-join` only in configuration files.

- `-retry-max`: Similar to the [retry_max] config option.

- `-server`: Enable server mode on the local agent.

- `-servers=<host:port>`: Equivalent to the Client [servers] config
  option.

- `-state-dir=<path>`: Equivalent to the Client [state_dir] config
  option.

- `-vault-enabled`: Whether to enable or disabled Vault integration.

- `-vault-address=<addr>`: The address to communicate with Vault.

- `-vault-token=<token>`: The Vault token used to derive tokens. Only needs to
  be set on Servers. Overrides the Vault token read from the VAULT_TOKEN
  environment variable.

- `-vault-create-from-role=<role>`: The role name to create tokens for tasks
  from.

- `-vault-ca-file=<path>`: Path to a PEM-encoded CA cert file used to verify the
  Vault server SSL certificate.

- `-vault-ca-path=<path>`: Path to a directory of PEM-encoded CA cert files used
  to verify the Vault server SSL certificate.Whether to enable or disabled Vault
  integration.

- `vault-cert-file=<path>`: The path to the certificate for Vault communication.

- `vault-key-file=<path>`: The path to the private key for Vault communication.

- `vault-namespace=<namespace>`: The Vault namespace used for the integration.
  Required for servers and clients. Overrides the Vault namespace read from the
  VAULT_NAMESPACE environment variable.

- `vault-tls-skip-verify`: A boolean that determines whether to skip SSL
  certificate verification.

- `vault-tls-server-name=<name>`: Used to set the SNI host when connecting to
  Vault over TLS.

[address]: /docs/configuration/consul.html#address
[alloc_dir]: #alloc_dir
[auth]: /docs/configuration/consul.html#auth
[auto_advertise]: /docs/configuration/consul.html#auto_advertise
[bind_addr]: #bind_addr
[bootstrap_expect]: #bootstrap_expect
[ca_file]: /docs/configuration/consul.html#ca_file
[cert_file]: /docs/configuration/consul.html#cert_file
[checks_use_advertise]: /docs/configuration/consul.html#checks_use_advertise
[client_auto_join]: /docs/configuration/consul.html#client_auto_join
[client_http_check_name]: /docs/configuration/consul.html#client_http_check_name
[client_service_name]: /docs/configuration/consul.html#client_service_name
[Configuration]: /docs/configuration/index.html
[data_dir]: /docs/configuration/index.html#data_dir
[datacenter]: #datacenter
[enabled]: /docs/configuration/acl.html#enabled
[Encryption Overview]: /guides/security/encryption.html
[key_file]: /docs/configuration/consul.html#key_file
[log_json]: /docs/configuration/index.html#log_json
[log_level]: /docs/configuration/index.html#log_level
[meta]: #meta
[name]: #name
[network_interface]: #network_interface
[network_speed]: #network_speed
[node_class]: #node_class
[Nomad Agent]: /guides/install/production/nomad-agent.html
[plugin_dir]: /docs/configuration/index.html#plugin_dir
[region]: #region
[rejoin_after_leave]: #rejoin_after_leave
[replication_token]: /docs/configuration/acl.html#replication_token
[retry_interval]: #retry_interval
[retry_max]: #retry_max
[server_auto_join]: /docs/configuration/consul.html#server_auto_join
[server_http_check_name]: /docs/configuration/consul.html#server_http_check_name
[server_rpc_check_name]: /docs/configuration/consul.html#server_rpc_check_name
[server_serf_check_name]: /docs/configuration/consul.html#server_serf_check_name
[server_service_name]: /docs/configuration/consul.html#server_service_name
[servers]: #servers
[ssl]: /docs/configuration/consul.html#ssl
[state_dir]: #state_dir
[token]: /docs/configuration/consul.html#token
[verify_ssl]: /docs/configuration/consul.html#verify_ssl
